/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.jdbc.utils;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class ConnectionResource {
    private static final String JDBC_ODPS_URL_PREFIX = "jdbc:odps:";
    private static final String CHARSET_DEFAULT_VALUE = "UTF-8";
    private static final String LIFECYCLE_DEFAULT_VALUE = "3";
    private static final String ODPS_CONF_URL_KEY = "odps_config";
    private static final String ACCESS_ID_URL_KEY = "accessId";
    private static final String ACCESS_KEY_URL_KEY = "accessKey";
    private static final String PROJECT_URL_KEY = "project";
    private static final String CHARSET_URL_KEY = "charset";
    private static final String LOGVIEW_URL_KEY = "logview";
    private static final String LIFECYCLE_URL_KEY = "lifecycle";
    private static final String LOGLEVEL_URL_KEY = "loglevel";
    private static final String TUNNEL_ENDPOINT_URL_KEY = "tunnelEndpoint";
    private static final String LOGCONFFILE_URL_KEY = "logconffile";
    public static final String ACCESS_ID_PROP_KEY = "access_id";
    public static final String ACCESS_KEY_PROP_KEY = "access_key";
    public static final String PROJECT_PROP_KEY = "project_name";
    public static final String CHARSET_PROP_KEY = "charset";
    public static final String LOGVIEW_HOST_PROP_KEY = "logview_host";
    public static final String LIFECYCLE_PROP_KEY = "lifecycle";
    public static final String LOGLEVEL_PROP_KEY = "log_level";
    public static final String TUNNEL_ENDPOINT_PROP_KEY = "tunnel_endpoint";
    public static final String LOGCONFFILE_PROP_KEY = "log_conf_file";
    private static final String ACCESS_ID_PROP_KEY_ALT = "user";
    private static final String ACCESS_KEY_PROP_KEY_ALT = "password";
    private String endpoint;
    private String accessId;
    private String accessKey;
    private String project;
    private String charset;
    private String logview;
    private String lifecycle;
    private String logLevel;
    private String tunnelEndpoint;
    private String logConfFile;

    public static boolean acceptURL(String url) {
        return url != null && url.startsWith(JDBC_ODPS_URL_PREFIX);
    }

    public ConnectionResource(String url, Properties info) {
        Map<String, String> paramsInURL = this.extractParamsFromUrl(url);
        this.init(info, paramsInURL);
    }

    /*
     * Unable to fully structure code
     */
    void init(Properties info, Map<String, String> paramsInURL) {
        maps = new ArrayList<Map>();
        if (paramsInURL.get("odps_config") != null) {
            try {
                inputStream = new FileInputStream(paramsInURL.get("odps_config"));
                if (inputStream == null) ** GOTO lbl17
                props = new Properties();
                props.load(inputStream);
                maps.add(props);
            }
            catch (IOException e) {
                throw new RuntimeException("Load odps conf failed:", e);
            }
        } else {
            maps.add(info);
            maps.add(paramsInURL);
        }
lbl17:
        // 3 sources

        this.accessId = ConnectionResource.tryGetFirstNonNullValueByAltMapAndAltKey(maps, null, new String[]{"user", "access_id", "accessId"});
        this.accessKey = ConnectionResource.tryGetFirstNonNullValueByAltMapAndAltKey(maps, null, new String[]{"password", "access_key", "accessKey"});
        if (this.accessKey != null) {
            try {
                this.accessKey = URLDecoder.decode(this.accessKey, "UTF-8");
            }
            catch (UnsupportedEncodingException v0) {
                this.accessKey = URLDecoder.decode(this.accessKey);
            }
        }
        this.charset = ConnectionResource.tryGetFirstNonNullValueByAltMapAndAltKey(maps, "UTF-8", new String[]{"charset", "charset"});
        this.project = ConnectionResource.tryGetFirstNonNullValueByAltMapAndAltKey(maps, null, new String[]{"project_name", "project"});
        this.logview = ConnectionResource.tryGetFirstNonNullValueByAltMapAndAltKey(maps, null, new String[]{"logview_host", "logview"});
        this.lifecycle = ConnectionResource.tryGetFirstNonNullValueByAltMapAndAltKey(maps, "3", new String[]{"lifecycle", "lifecycle"});
        this.logLevel = ConnectionResource.tryGetFirstNonNullValueByAltMapAndAltKey(maps, null, new String[]{"log_level", "loglevel"});
        this.tunnelEndpoint = ConnectionResource.tryGetFirstNonNullValueByAltMapAndAltKey(maps, null, new String[]{"tunnel_endpoint", "tunnelEndpoint"});
        this.logConfFile = ConnectionResource.tryGetFirstNonNullValueByAltMapAndAltKey(maps, null, new String[]{"log_conf_file", "logconffile"});
    }

    private Map<String, String> extractParamsFromUrl(String url) {
        HashMap<String, String> paramsInURL = new HashMap<String, String>();
        int atPos = (url = url.substring(JDBC_ODPS_URL_PREFIX.length())).indexOf("?");
        if (atPos == -1) {
            this.endpoint = url;
        } else {
            String[] pairs;
            this.endpoint = url.substring(0, atPos);
            String query = url.substring(atPos + 1);
            String[] stringArray = pairs = query.split("&");
            int n = pairs.length;
            int n2 = 0;
            while (n2 < n) {
                String pair = stringArray[n2];
                int pos = pair.indexOf("=");
                if (pos > 0) {
                    paramsInURL.put(URLDecoder.decode(pair.substring(0, pos)), URLDecoder.decode(pair.substring(pos + 1)));
                } else {
                    paramsInURL.put(URLDecoder.decode(pair), null);
                }
                ++n2;
            }
        }
        return paramsInURL;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getProject() {
        return this.project;
    }

    public String getCharset() {
        return this.charset;
    }

    public String getAccessId() {
        return this.accessId;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getLogview() {
        return this.logview;
    }

    public String getLifecycle() {
        return this.lifecycle;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public String getTunnelEndpoint() {
        return this.tunnelEndpoint;
    }

    public String getLogConfFile() {
        return this.logConfFile;
    }

    private static String tryGetFirstNonNullValueByAltMapAndAltKey(List<Map> maps, String defaultValue, String ... altKeys) {
        String value = null;
        for (Map map : maps) {
            if (map == null) continue;
            String[] stringArray = altKeys;
            int n = altKeys.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                value = (String)map.get(key);
                if (value != null) {
                    return value;
                }
                ++n2;
            }
        }
        return defaultValue;
    }
}

