/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.jdbc;

import com.aliyun.odps.Column;
import com.aliyun.odps.TableSchema;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.data.Varchar;
import com.aliyun.odps.jdbc.OdpsConnection;
import com.aliyun.odps.jdbc.OdpsStatement;
import com.aliyun.odps.jdbc.PublicMethodAspect;
import com.aliyun.odps.jdbc.utils.transformer.to.odps.AbstractToOdpsTransformer;
import com.aliyun.odps.jdbc.utils.transformer.to.odps.ToOdpsTransformerFactory;
import com.aliyun.odps.tunnel.TableTunnel;
import com.aliyun.odps.tunnel.TunnelException;
import com.aliyun.odps.tunnel.io.TunnelRecordWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class OdpsPreparedStatement
extends OdpsStatement
implements PreparedStatement {
    private final String TABLE_NAME = "((\\w+\\.)?\\w+)";
    private final String PREP_VALUES = "\\([\\?,?\\s*]+\\)";
    private final String SPEC_COLS = "\\([\\w+,?\\s*]+\\)";
    private final String PREP_INSERT_WITH_SPEC_COLS = "(?i)^\\s*insert\\s+into\\s+((\\w+\\.)?\\w+)\\s+\\([\\w+,?\\s*]+\\)\\s+values\\s*\\([\\?,?\\s*]+\\)\\s*;?\\s*$";
    private final String PREP_INSERT_WITH_SPEC_COLS_EXAMPLE = "INSERT INTO table (field1, field2) VALUES (?, ?);";
    private final String PREP_INSERT_WITHOUT_SPEC_COLS = "(?i)^\\s*insert\\s+into\\s+((\\w+\\.)?\\w+)\\s+values\\s*\\([\\?,?\\s*]+\\)\\s*;?\\s*$";
    private final String PREP_INSERT_WITHOUT_SPEC_COLS_EXAMPLE = "INSERT INTO table VALUES (?, ?, ?);";
    private final String sql;
    private boolean verified = false;
    private String tableBatchInsertTo;
    private int parametersNum;
    TableTunnel.UploadSession session;
    Record reuseRecord;
    int blocks;
    private HashMap<Integer, Object> parameters = new HashMap();
    private List<Object[]> batchedRows = new ArrayList<Object[]>();
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_21;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_22;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_23;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_24;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_25;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_26;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_27;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_28;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_29;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_30;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_31;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_32;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_33;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_34;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_35;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_36;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_37;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_38;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_39;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_40;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_41;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_42;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_43;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_44;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_45;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_46;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_47;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_48;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_49;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_50;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_51;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_52;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_53;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_54;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_55;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_56;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_57;

    OdpsPreparedStatement(OdpsConnection conn, String sql) {
        super(conn);
        this.sql = sql;
        int counter = 0;
        int i = 0;
        while (i < sql.length()) {
            if (sql.charAt(i) == '?') {
                ++counter;
            }
            ++i;
        }
        this.parametersNum = counter;
        conn.log.debug("create prepared statements: " + sql);
    }

    OdpsPreparedStatement(OdpsConnection conn, String sql, boolean isResultSetScrollable) {
        this(conn, sql);
        this.isResultSetScrollable = isResultSetScrollable;
    }

    @Override
    public void addBatch() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            Object[] arr = new Object[this.parametersNum];
            int i = 0;
            while (i < arr.length) {
                arr[i] = this.parameters.get(i + 1);
                ++i;
            }
            this.batchedRows.add(arr);
            this.parameters.clear();
            Object var4_4 = null;
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(var4_4, joinPoint);
            return;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void clearParameters() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            this.parameters.clear();
            Object var2_2 = null;
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(var2_2, joinPoint);
            return;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            this.batchedRows.clear();
            Object var2_2 = null;
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(var2_2, joinPoint);
            return;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        try {
            int[] nArray;
            int[] nArray2;
            int[] nArray3;
            int batchedSize;
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            if (!this.verified) {
                if (!this.sql.matches("(?i)^\\s*insert\\s+into\\s+((\\w+\\.)?\\w+)\\s+values\\s*\\([\\?,?\\s*]+\\)\\s*;?\\s*$")) {
                    throw new SQLException("batched statement only support following syntax: INSERT INTO table VALUES (?, ?, ?);");
                }
                Matcher matcher = Pattern.compile("(?i)^\\s*insert\\s+into\\s+((\\w+\\.)?\\w+)\\s+values\\s*\\([\\?,?\\s*]+\\)\\s*;?\\s*$").matcher(this.sql);
                if (!matcher.find()) {
                    throw new SQLException("cannot extract table name in SQL: " + this.sql);
                }
                this.tableBatchInsertTo = matcher.group(1);
                TableTunnel tunnel = new TableTunnel(this.getConnection().getOdps());
                try {
                    if (this.tableBatchInsertTo.contains(".")) {
                        String[] splited = this.tableBatchInsertTo.split("\\.");
                        this.session = tunnel.createUploadSession(splited[0], splited[1]);
                    } else {
                        String defaultProject = this.getConnection().getOdps().getDefaultProject();
                        this.session = tunnel.createUploadSession(defaultProject, this.tableBatchInsertTo);
                    }
                }
                catch (TunnelException e) {
                    throw new SQLException(e);
                }
                this.getConnection().log.debug("create upload session id=" + this.session.getId());
                TableSchema schema = this.session.getSchema();
                this.reuseRecord = this.session.newRecord();
                int colNum = schema.getColumns().size();
                int valNum = this.batchedRows.get(0).length;
                if (valNum != colNum) {
                    throw new SQLException("the table has " + colNum + " columns, but insert " + valNum + " values");
                }
                this.blocks = 0;
                this.verified = true;
            }
            if ((batchedSize = this.batchedRows.size()) == 0) {
                nArray2 = nArray3 = new int[0];
            } else {
                this.getConnection().log.debug(String.valueOf(batchedSize) + " records are going to be uploaded to table " + this.tableBatchInsertTo + " in batch");
                int[] updateCounts = new int[batchedSize];
                Arrays.fill(updateCounts, -1);
                try {
                    long startTime = System.currentTimeMillis();
                    TunnelRecordWriter recordWriter = (TunnelRecordWriter)this.session.openRecordWriter((long)this.blocks, true);
                    List columns = this.session.getSchema().getColumns();
                    int i = 0;
                    while (i < batchedSize) {
                        Object[] row = this.batchedRows.get(i);
                        int j = 0;
                        while (j < columns.size()) {
                            AbstractToOdpsTransformer transformer = ToOdpsTransformerFactory.getTransformer(((Column)columns.get(j)).getTypeInfo().getOdpsType());
                            this.reuseRecord.set(j, transformer.transform(row[j], this.getConnection().getCharset()));
                            ++j;
                        }
                        recordWriter.write(this.reuseRecord);
                        updateCounts[i] = 1;
                        ++i;
                    }
                    long duration = System.currentTimeMillis() - startTime;
                    float megaBytesPerSec = (float)recordWriter.getTotalBytes() / 1024.0f / 1024.0f / (float)duration * 1000.0f;
                    recordWriter.close();
                    this.getConnection().log.info(String.format("It took me %d ms to insert %d records [%d], %.2f MiB/s", duration, batchedSize, this.blocks, Float.valueOf(megaBytesPerSec)));
                    ++this.blocks;
                }
                catch (TunnelException e) {
                    throw new SQLException(e);
                }
                catch (IOException e) {
                    throw new SQLException(e);
                }
                this.clearBatch();
                nArray2 = nArray3 = updateCounts;
            }
            int[] nArray4 = nArray = nArray2;
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(nArray, joinPoint);
            return nArray3;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void close() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            if (this.session != null && this.blocks > 0) {
                Long[] blockList = new Long[this.blocks];
                this.getConnection().log.info("commit session: " + this.blocks + " blocks");
                int i = 0;
                while (i < this.blocks) {
                    blockList[i] = i;
                    ++i;
                }
                try {
                    this.session.commit(blockList);
                }
                catch (TunnelException e) {
                    throw new SQLException(e);
                }
                catch (IOException e) {
                    throw new SQLException(e);
                }
            }
            super.close();
            Object var4_6 = null;
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(var4_6, joinPoint);
            return;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public boolean execute() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
        try {
            boolean bl;
            boolean bl2;
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            boolean bl3 = bl2 = (bl = super.execute(this.updateSql(this.sql, this.parameters)));
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(Conversions.booleanObject((boolean)bl2), joinPoint);
            return bl;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
        try {
            ResultSet resultSet;
            ResultSet resultSet2;
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            ResultSet resultSet3 = resultSet2 = (resultSet = super.executeQuery(this.updateSql(this.sql, this.parameters)));
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(resultSet2, joinPoint);
            return resultSet;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public int executeUpdate() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
        try {
            int n;
            int n2;
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            int n3 = n2 = (n = super.executeUpdate(this.updateSql(this.sql, this.parameters)));
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(Conversions.intObject((int)n2), joinPoint);
            return n;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        int n = parameterIndex;
        Array array = x;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), (Object)array);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        int n = parameterIndex;
        InputStream inputStream = x;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), (Object)inputStream);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        int n = parameterIndex;
        InputStream inputStream = x;
        int n2 = length;
        Object[] objectArray = new Object[]{Conversions.intObject((int)n), inputStream, Conversions.intObject((int)n2)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object[])objectArray);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        int n = parameterIndex;
        InputStream inputStream = x;
        long l = length;
        Object[] objectArray = new Object[]{Conversions.intObject((int)n), inputStream, Conversions.longObject((long)l)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, (Object[])objectArray);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        int n = parameterIndex;
        InputStream inputStream = x;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), (Object)inputStream);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        int n = parameterIndex;
        InputStream inputStream = x;
        int n2 = length;
        Object[] objectArray = new Object[]{Conversions.intObject((int)n), inputStream, Conversions.intObject((int)n2)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this, (Object[])objectArray);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        int n = parameterIndex;
        InputStream inputStream = x;
        long l = length;
        Object[] objectArray = new Object[]{Conversions.intObject((int)n), inputStream, Conversions.longObject((long)l)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this, (Object[])objectArray);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        int n = parameterIndex;
        Blob blob = x;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), (Object)blob);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        int n = parameterIndex;
        InputStream inputStream2 = inputStream;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), (Object)inputStream2);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        int n = parameterIndex;
        InputStream inputStream2 = inputStream;
        long l = length;
        Object[] objectArray = new Object[]{Conversions.intObject((int)n), inputStream2, Conversions.longObject((long)l)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this, (Object[])objectArray);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        int n = parameterIndex;
        byte[] byArray = x;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), (Object)byArray);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            this.parameters.put(parameterIndex, x);
            Object var6_6 = null;
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(var6_6, joinPoint);
            return;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        int n = parameterIndex;
        Reader reader2 = reader;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_21, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), (Object)reader2);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        int n = parameterIndex;
        Reader reader2 = reader;
        int n2 = length;
        Object[] objectArray = new Object[]{Conversions.intObject((int)n), reader2, Conversions.intObject((int)n2)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_22, (Object)this, (Object)this, (Object[])objectArray);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        int n = parameterIndex;
        Reader reader2 = reader;
        long l = length;
        Object[] objectArray = new Object[]{Conversions.intObject((int)n), reader2, Conversions.longObject((long)l)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_23, (Object)this, (Object)this, (Object[])objectArray);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        int n = parameterIndex;
        Clob clob = x;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_24, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), (Object)clob);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        int n = parameterIndex;
        Reader reader2 = reader;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_25, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), (Object)reader2);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        int n = parameterIndex;
        Reader reader2 = reader;
        long l = length;
        Object[] objectArray = new Object[]{Conversions.intObject((int)n), reader2, Conversions.longObject((long)l)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_26, (Object)this, (Object)this, (Object[])objectArray);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        int n = parameterIndex;
        Date date = x;
        Calendar calendar = cal;
        Object[] objectArray = new Object[]{Conversions.intObject((int)n), date, calendar};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_27, (Object)this, (Object)this, (Object[])objectArray);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        int n = parameterIndex;
        Reader reader = value;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_28, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), (Object)reader);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        int n = parameterIndex;
        Reader reader = value;
        long l = length;
        Object[] objectArray = new Object[]{Conversions.intObject((int)n), reader, Conversions.longObject((long)l)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_29, (Object)this, (Object)this, (Object[])objectArray);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        int n = parameterIndex;
        NClob nClob = value;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_30, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), (Object)nClob);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        int n = parameterIndex;
        Reader reader2 = reader;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_31, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), (Object)reader2);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        int n = parameterIndex;
        Reader reader2 = reader;
        long l = length;
        Object[] objectArray = new Object[]{Conversions.intObject((int)n), reader2, Conversions.longObject((long)l)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_32, (Object)this, (Object)this, (Object[])objectArray);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        int n = parameterIndex;
        String string = value;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_33, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), (Object)string);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        int n = parameterIndex;
        int n2 = sqlType;
        String string = typeName;
        Object[] objectArray = new Object[]{Conversions.intObject((int)n), Conversions.intObject((int)n2), string};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_34, (Object)this, (Object)this, (Object[])objectArray);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            this.parameters.put(parameterIndex, null);
            Object var9_9 = null;
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(var9_9, joinPoint);
            return;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        int n = parameterIndex;
        Object object = x;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_35, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), (Object)object);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            if (x == null) {
                this.setNull(parameterIndex, 0);
            } else if (x instanceof String) {
                this.setString(parameterIndex, (String)x);
            } else if (x instanceof byte[]) {
                this.setBytes(parameterIndex, (byte[])x);
            } else if (x instanceof Short) {
                this.setShort(parameterIndex, (Short)x);
            } else if (x instanceof Integer) {
                this.setInt(parameterIndex, (Integer)x);
            } else if (x instanceof Long) {
                this.setLong(parameterIndex, (Long)x);
            } else if (x instanceof Float) {
                this.setFloat(parameterIndex, ((Float)x).floatValue());
            } else if (x instanceof Double) {
                this.setDouble(parameterIndex, (Double)x);
            } else if (x instanceof Boolean) {
                this.setBoolean(parameterIndex, (Boolean)x);
            } else if (x instanceof Byte) {
                this.setByte(parameterIndex, (Byte)x);
            } else if (x instanceof BigDecimal) {
                this.setBigDecimal(parameterIndex, (BigDecimal)x);
            } else if (x instanceof Timestamp) {
                this.setTimestamp(parameterIndex, (Timestamp)x);
            } else if (x instanceof Time) {
                this.setTime(parameterIndex, (Time)x);
            } else if (x instanceof Date) {
                this.setDate(parameterIndex, (Date)x);
            } else if (x instanceof java.util.Date) {
                this.parameters.put(parameterIndex, x);
            } else {
                throw new SQLException("can not set an object of type: " + x.getClass().getName());
            }
            Object var6_6 = null;
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(var6_6, joinPoint);
            return;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        int n = parameterIndex;
        BigDecimal bigDecimal = x;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_36, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), (Object)bigDecimal);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            this.parameters.put(parameterIndex, x);
            Object var6_6 = null;
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(var6_6, joinPoint);
            return;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        int n = parameterIndex;
        boolean bl = x;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_37, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), (Object)Conversions.booleanObject((boolean)bl));
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            this.parameters.put(parameterIndex, x);
            Object var6_6 = null;
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(var6_6, joinPoint);
            return;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        int n = parameterIndex;
        byte by = x;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_38, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), (Object)Conversions.byteObject((byte)by));
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            this.parameters.put(parameterIndex, x);
            Object var6_6 = null;
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(var6_6, joinPoint);
            return;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        int n = parameterIndex;
        Date date = x;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_39, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), (Object)date);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            this.parameters.put(parameterIndex, x);
            Object var6_6 = null;
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(var6_6, joinPoint);
            return;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        int n = parameterIndex;
        double d = x;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_40, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), (Object)Conversions.doubleObject((double)d));
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            this.parameters.put(parameterIndex, x);
            Object var8_6 = null;
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(var8_6, joinPoint);
            return;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        int n = parameterIndex;
        float f = x;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_41, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), (Object)Conversions.floatObject((float)f));
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            this.parameters.put(parameterIndex, Float.valueOf(x));
            Object var6_6 = null;
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(var6_6, joinPoint);
            return;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        int n = parameterIndex;
        int n2 = x;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_42, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), (Object)Conversions.intObject((int)n2));
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            this.parameters.put(parameterIndex, x);
            Object var6_6 = null;
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(var6_6, joinPoint);
            return;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        int n = parameterIndex;
        long l = x;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_43, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), (Object)Conversions.longObject((long)l));
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            this.parameters.put(parameterIndex, x);
            Object var8_6 = null;
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(var8_6, joinPoint);
            return;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        int n = parameterIndex;
        int n2 = sqlType;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_44, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), (Object)Conversions.intObject((int)n2));
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            this.parameters.put(parameterIndex, null);
            Object var6_6 = null;
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(var6_6, joinPoint);
            return;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        int n = parameterIndex;
        short s = x;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_45, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), (Object)Conversions.shortObject((short)s));
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            this.parameters.put(parameterIndex, x);
            Object var6_6 = null;
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(var6_6, joinPoint);
            return;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        int n = parameterIndex;
        String string = x;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_46, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), (Object)string);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            if (x == null) {
                this.parameters.put(parameterIndex, null);
            } else {
                this.parameters.put(parameterIndex, x.getBytes());
            }
            Object var6_6 = null;
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(var6_6, joinPoint);
            return;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        int n = parameterIndex;
        Time time = x;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_47, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), (Object)time);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            this.parameters.put(parameterIndex, x);
            Object var6_6 = null;
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(var6_6, joinPoint);
            return;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        int n = parameterIndex;
        Timestamp timestamp = x;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_48, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), (Object)timestamp);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            this.parameters.put(parameterIndex, x);
            Object var6_6 = null;
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(var6_6, joinPoint);
            return;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        int n = parameterIndex;
        Object object = x;
        int n2 = targetSqlType;
        Object[] objectArray = new Object[]{Conversions.intObject((int)n), object, Conversions.intObject((int)n2)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_49, (Object)this, (Object)this, (Object[])objectArray);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        int n = parameterIndex;
        Object object = x;
        int n2 = targetSqlType;
        int n3 = scaleOrLength;
        Object[] objectArray = new Object[]{Conversions.intObject((int)n), object, Conversions.intObject((int)n2), Conversions.intObject((int)n3)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_50, (Object)this, (Object)this, (Object[])objectArray);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        int n = parameterIndex;
        Ref ref = x;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_51, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), (Object)ref);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        int n = parameterIndex;
        RowId rowId = x;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_52, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), (Object)rowId);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        int n = parameterIndex;
        SQLXML sQLXML = xmlObject;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_53, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), (Object)sQLXML);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        int n = parameterIndex;
        Time time = x;
        Calendar calendar = cal;
        Object[] objectArray = new Object[]{Conversions.intObject((int)n), time, calendar};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_54, (Object)this, (Object)this, (Object[])objectArray);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        int n = parameterIndex;
        Timestamp timestamp = x;
        Calendar calendar = cal;
        Object[] objectArray = new Object[]{Conversions.intObject((int)n), timestamp, calendar};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_55, (Object)this, (Object)this, (Object[])objectArray);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        int n = parameterIndex;
        URL uRL = x;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_56, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), (Object)uRL);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        int n = parameterIndex;
        InputStream inputStream = x;
        int n2 = length;
        Object[] objectArray = new Object[]{Conversions.intObject((int)n), inputStream, Conversions.intObject((int)n2)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_57, (Object)this, (Object)this, (Object[])objectArray);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    private String updateSql(String sql, HashMap<Integer, Object> parameters) throws SQLException {
        if (!sql.contains("?")) {
            return sql;
        }
        StringBuilder newSql = new StringBuilder(sql);
        int paramIndex = 1;
        int pos = 0;
        while (pos < newSql.length()) {
            if (newSql.charAt(pos) == '?') {
                if (parameters.containsKey(paramIndex)) {
                    newSql.deleteCharAt(pos);
                    String str = this.convertJavaTypeToSqlString(parameters.get(paramIndex));
                    newSql.insert(pos, str);
                    pos += str.length() - 1;
                }
                ++paramIndex;
                continue;
            }
            ++pos;
        }
        return newSql.toString();
    }

    private String convertJavaTypeToSqlString(Object x) throws SQLException {
        if (Byte.class.isInstance(x)) {
            return String.format("%sY", x.toString());
        }
        if (Short.class.isInstance(x)) {
            return String.format("%sS", x.toString());
        }
        if (Integer.class.isInstance(x)) {
            return x.toString();
        }
        if (Long.class.isInstance(x)) {
            return String.format("%sL", x.toString());
        }
        if (Float.class.isInstance(x) || Double.class.isInstance(x)) {
            return x.toString();
        }
        if (BigDecimal.class.isInstance(x)) {
            return String.format("%sBD", x.toString());
        }
        if (Varchar.class.isInstance(x)) {
            return x.toString();
        }
        if (String.class.isInstance(x)) {
            return "'" + (String)x + "'";
        }
        if (byte[].class.isInstance(x)) {
            try {
                String charset = this.getConnection().getCharset();
                if (charset != null) {
                    return "'" + new String((byte[])x, charset) + "'";
                }
                throw new SQLException("charset is null");
            }
            catch (UnsupportedEncodingException e) {
                throw new SQLException(e);
            }
        }
        if (Timestamp.class.isInstance(x)) {
            return String.format("TIMESTAMP\"%s\"", x.toString());
        }
        if (java.util.Date.class.isInstance(x) || Date.class.isInstance(x) || Time.class.isInstance(x)) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return String.format("DATETIME\"%s\"", formatter.format(x));
        }
        if (Boolean.class.isInstance(x)) {
            return x.toString().toUpperCase();
        }
        if (x == null || x.equals(0)) {
            return "NULL";
        }
        throw new SQLException("unrecognized Java class: " + x.getClass().getName());
    }

    static {
        OdpsPreparedStatement.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OdpsPreparedStatement.java", OdpsPreparedStatement.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addBatch", "com.aliyun.odps.jdbc.OdpsPreparedStatement", "", "", "java.sql.SQLException", "void"), 132);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "clearParameters", "com.aliyun.odps.jdbc.OdpsPreparedStatement", "", "", "java.sql.SQLException", "void"), 142);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setArray", "com.aliyun.odps.jdbc.OdpsPreparedStatement", "int:java.sql.Array", "parameterIndex:x", "java.sql.SQLException", "void"), 296);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setAsciiStream", "com.aliyun.odps.jdbc.OdpsPreparedStatement", "int:java.io.InputStream", "parameterIndex:x", "java.sql.SQLException", "void"), 301);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setAsciiStream", "com.aliyun.odps.jdbc.OdpsPreparedStatement", "int:java.io.InputStream:int", "parameterIndex:x:length", "java.sql.SQLException", "void"), 306);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setAsciiStream", "com.aliyun.odps.jdbc.OdpsPreparedStatement", "int:java.io.InputStream:long", "parameterIndex:x:length", "java.sql.SQLException", "void"), 312);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setBinaryStream", "com.aliyun.odps.jdbc.OdpsPreparedStatement", "int:java.io.InputStream", "parameterIndex:x", "java.sql.SQLException", "void"), 318);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setBinaryStream", "com.aliyun.odps.jdbc.OdpsPreparedStatement", "int:java.io.InputStream:int", "parameterIndex:x:length", "java.sql.SQLException", "void"), 323);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setBinaryStream", "com.aliyun.odps.jdbc.OdpsPreparedStatement", "int:java.io.InputStream:long", "parameterIndex:x:length", "java.sql.SQLException", "void"), 329);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setBlob", "com.aliyun.odps.jdbc.OdpsPreparedStatement", "int:java.sql.Blob", "parameterIndex:x", "java.sql.SQLException", "void"), 335);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setBlob", "com.aliyun.odps.jdbc.OdpsPreparedStatement", "int:java.io.InputStream", "parameterIndex:inputStream", "java.sql.SQLException", "void"), 340);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setBlob", "com.aliyun.odps.jdbc.OdpsPreparedStatement", "int:java.io.InputStream:long", "parameterIndex:inputStream:length", "java.sql.SQLException", "void"), 345);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "clearBatch", "com.aliyun.odps.jdbc.OdpsPreparedStatement", "", "", "java.sql.SQLException", "void"), 147);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setBytes", "com.aliyun.odps.jdbc.OdpsPreparedStatement", "int:[B", "parameterIndex:x", "java.sql.SQLException", "void"), 351);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setCharacterStream", "com.aliyun.odps.jdbc.OdpsPreparedStatement", "int:java.io.Reader", "parameterIndex:reader", "java.sql.SQLException", "void"), 356);
        ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setCharacterStream", "com.aliyun.odps.jdbc.OdpsPreparedStatement", "int:java.io.Reader:int", "parameterIndex:reader:length", "java.sql.SQLException", "void"), 362);
        ajc$tjp_23 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setCharacterStream", "com.aliyun.odps.jdbc.OdpsPreparedStatement", "int:java.io.Reader:long", "parameterIndex:reader:length", "java.sql.SQLException", "void"), 368);
        ajc$tjp_24 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setClob", "com.aliyun.odps.jdbc.OdpsPreparedStatement", "int:java.sql.Clob", "parameterIndex:x", "java.sql.SQLException", "void"), 374);
        ajc$tjp_25 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setClob", "com.aliyun.odps.jdbc.OdpsPreparedStatement", "int:java.io.Reader", "parameterIndex:reader", "java.sql.SQLException", "void"), 379);
        ajc$tjp_26 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setClob", "com.aliyun.odps.jdbc.OdpsPreparedStatement", "int:java.io.Reader:long", "parameterIndex:reader:length", "java.sql.SQLException", "void"), 384);
        ajc$tjp_27 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setDate", "com.aliyun.odps.jdbc.OdpsPreparedStatement", "int:java.sql.Date:java.util.Calendar", "parameterIndex:x:cal", "java.sql.SQLException", "void"), 390);
        ajc$tjp_28 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setNCharacterStream", "com.aliyun.odps.jdbc.OdpsPreparedStatement", "int:java.io.Reader", "parameterIndex:value", "java.sql.SQLException", "void"), 395);
        ajc$tjp_29 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setNCharacterStream", "com.aliyun.odps.jdbc.OdpsPreparedStatement", "int:java.io.Reader:long", "parameterIndex:value:length", "java.sql.SQLException", "void"), 401);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "executeBatch", "com.aliyun.odps.jdbc.OdpsPreparedStatement", "", "", "java.sql.SQLException", "[I"), 165);
        ajc$tjp_30 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setNClob", "com.aliyun.odps.jdbc.OdpsPreparedStatement", "int:java.sql.NClob", "parameterIndex:value", "java.sql.SQLException", "void"), 407);
        ajc$tjp_31 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setNClob", "com.aliyun.odps.jdbc.OdpsPreparedStatement", "int:java.io.Reader", "parameterIndex:reader", "java.sql.SQLException", "void"), 412);
        ajc$tjp_32 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setNClob", "com.aliyun.odps.jdbc.OdpsPreparedStatement", "int:java.io.Reader:long", "parameterIndex:reader:length", "java.sql.SQLException", "void"), 417);
        ajc$tjp_33 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setNString", "com.aliyun.odps.jdbc.OdpsPreparedStatement", "int:java.lang.String", "parameterIndex:value", "java.sql.SQLException", "void"), 423);
        ajc$tjp_34 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setNull", "com.aliyun.odps.jdbc.OdpsPreparedStatement", "int:int:java.lang.String", "parameterIndex:sqlType:typeName", "java.sql.SQLException", "void"), 428);
        ajc$tjp_35 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setObject", "com.aliyun.odps.jdbc.OdpsPreparedStatement", "int:java.lang.Object", "parameterIndex:x", "java.sql.SQLException", "void"), 435);
        ajc$tjp_36 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setBigDecimal", "com.aliyun.odps.jdbc.OdpsPreparedStatement", "int:java.math.BigDecimal", "parameterIndex:x", "java.sql.SQLException", "void"), 472);
        ajc$tjp_37 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setBoolean", "com.aliyun.odps.jdbc.OdpsPreparedStatement", "int:boolean", "parameterIndex:x", "java.sql.SQLException", "void"), 477);
        ajc$tjp_38 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setByte", "com.aliyun.odps.jdbc.OdpsPreparedStatement", "int:byte", "parameterIndex:x", "java.sql.SQLException", "void"), 482);
        ajc$tjp_39 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setDate", "com.aliyun.odps.jdbc.OdpsPreparedStatement", "int:java.sql.Date", "parameterIndex:x", "java.sql.SQLException", "void"), 486);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "close", "com.aliyun.odps.jdbc.OdpsPreparedStatement", "", "", "java.sql.SQLException", "void"), 251);
        ajc$tjp_40 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setDouble", "com.aliyun.odps.jdbc.OdpsPreparedStatement", "int:double", "parameterIndex:x", "java.sql.SQLException", "void"), 491);
        ajc$tjp_41 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setFloat", "com.aliyun.odps.jdbc.OdpsPreparedStatement", "int:float", "parameterIndex:x", "java.sql.SQLException", "void"), 496);
        ajc$tjp_42 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setInt", "com.aliyun.odps.jdbc.OdpsPreparedStatement", "int:int", "parameterIndex:x", "java.sql.SQLException", "void"), 501);
        ajc$tjp_43 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setLong", "com.aliyun.odps.jdbc.OdpsPreparedStatement", "int:long", "parameterIndex:x", "java.sql.SQLException", "void"), 506);
        ajc$tjp_44 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setNull", "com.aliyun.odps.jdbc.OdpsPreparedStatement", "int:int", "parameterIndex:sqlType", "java.sql.SQLException", "void"), 511);
        ajc$tjp_45 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setShort", "com.aliyun.odps.jdbc.OdpsPreparedStatement", "int:short", "parameterIndex:x", "java.sql.SQLException", "void"), 517);
        ajc$tjp_46 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setString", "com.aliyun.odps.jdbc.OdpsPreparedStatement", "int:java.lang.String", "parameterIndex:x", "java.sql.SQLException", "void"), 522);
        ajc$tjp_47 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setTime", "com.aliyun.odps.jdbc.OdpsPreparedStatement", "int:java.sql.Time", "parameterIndex:x", "java.sql.SQLException", "void"), 531);
        ajc$tjp_48 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setTimestamp", "com.aliyun.odps.jdbc.OdpsPreparedStatement", "int:java.sql.Timestamp", "parameterIndex:x", "java.sql.SQLException", "void"), 536);
        ajc$tjp_49 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setObject", "com.aliyun.odps.jdbc.OdpsPreparedStatement", "int:java.lang.Object:int", "parameterIndex:x:targetSqlType", "java.sql.SQLException", "void"), 541);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "execute", "com.aliyun.odps.jdbc.OdpsPreparedStatement", "", "", "java.sql.SQLException", "boolean"), 271);
        ajc$tjp_50 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setObject", "com.aliyun.odps.jdbc.OdpsPreparedStatement", "int:java.lang.Object:int:int", "parameterIndex:x:targetSqlType:scaleOrLength", "java.sql.SQLException", "void"), 547);
        ajc$tjp_51 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setRef", "com.aliyun.odps.jdbc.OdpsPreparedStatement", "int:java.sql.Ref", "parameterIndex:x", "java.sql.SQLException", "void"), 553);
        ajc$tjp_52 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setRowId", "com.aliyun.odps.jdbc.OdpsPreparedStatement", "int:java.sql.RowId", "parameterIndex:x", "java.sql.SQLException", "void"), 558);
        ajc$tjp_53 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setSQLXML", "com.aliyun.odps.jdbc.OdpsPreparedStatement", "int:java.sql.SQLXML", "parameterIndex:xmlObject", "java.sql.SQLException", "void"), 563);
        ajc$tjp_54 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setTime", "com.aliyun.odps.jdbc.OdpsPreparedStatement", "int:java.sql.Time:java.util.Calendar", "parameterIndex:x:cal", "java.sql.SQLException", "void"), 568);
        ajc$tjp_55 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setTimestamp", "com.aliyun.odps.jdbc.OdpsPreparedStatement", "int:java.sql.Timestamp:java.util.Calendar", "parameterIndex:x:cal", "java.sql.SQLException", "void"), 573);
        ajc$tjp_56 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setURL", "com.aliyun.odps.jdbc.OdpsPreparedStatement", "int:java.net.URL", "parameterIndex:x", "java.sql.SQLException", "void"), 579);
        ajc$tjp_57 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setUnicodeStream", "com.aliyun.odps.jdbc.OdpsPreparedStatement", "int:java.io.InputStream:int", "parameterIndex:x:length", "java.sql.SQLException", "void"), 584);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "executeQuery", "com.aliyun.odps.jdbc.OdpsPreparedStatement", "", "", "java.sql.SQLException", "java.sql.ResultSet"), 276);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "executeUpdate", "com.aliyun.odps.jdbc.OdpsPreparedStatement", "", "", "java.sql.SQLException", "int"), 281);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMetaData", "com.aliyun.odps.jdbc.OdpsPreparedStatement", "", "", "java.sql.SQLException", "java.sql.ResultSetMetaData"), 286);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getParameterMetaData", "com.aliyun.odps.jdbc.OdpsPreparedStatement", "", "", "java.sql.SQLException", "java.sql.ParameterMetaData"), 291);
    }
}

