/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.jdbc;

import com.aliyun.odps.data.Record;
import com.aliyun.odps.jdbc.OdpsResultSet;
import com.aliyun.odps.jdbc.OdpsResultSetMetaData;
import com.aliyun.odps.jdbc.OdpsStatement;
import com.aliyun.odps.jdbc.PublicMethodAspect;
import com.aliyun.odps.tunnel.InstanceTunnel;
import com.aliyun.odps.tunnel.TunnelException;
import com.aliyun.odps.tunnel.io.TunnelRecordReader;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class OdpsForwardResultSet
extends OdpsResultSet
implements ResultSet {
    private InstanceTunnel.DownloadSession sessionHandle;
    private TunnelRecordReader reader = null;
    private Record reuseRecord = null;
    private Object[] currentRow;
    private long fetchedRows = 0L;
    private final long totalRows;
    private boolean isClosed = false;
    private long startTime;
    private static final long ACCUM_FETCHED_ROWS = 10000L;
    long accumTime;
    long accumKBytes = 0L;
    private static final int READER_REOPEN_TIME_MAX = 5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    OdpsForwardResultSet(OdpsStatement stmt, OdpsResultSetMetaData meta, InstanceTunnel.DownloadSession session) throws SQLException {
        super(stmt.getConnection(), stmt, meta);
        this.sessionHandle = session;
        int maxRows = stmt.resultSetMaxRows;
        long recordCount = this.sessionHandle.getRecordCount();
        this.totalRows = maxRows > 0 && (long)maxRows <= recordCount ? (long)maxRows : recordCount;
        this.startTime = System.currentTimeMillis();
    }

    protected void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("The result set has been closed");
        }
    }

    @Override
    public int getRow() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        try {
            int n;
            int n2;
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            this.checkClosed();
            int n3 = n2 = (n = (int)this.fetchedRows);
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(Conversions.intObject((int)n2), joinPoint);
            return n;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public int getType() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        try {
            int n;
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            int n2 = 1003;
            int n3 = n = 1003;
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(Conversions.intObject((int)n), joinPoint);
            return n2;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        try {
            boolean bl;
            boolean bl2;
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            boolean bl3 = bl2 = (bl = this.isClosed);
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(Conversions.booleanObject((boolean)bl2), joinPoint);
            return bl;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void close() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            if (!this.isClosed) {
                this.isClosed = true;
                this.sessionHandle = null;
                try {
                    if (this.reader != null) {
                        this.reader.close();
                    }
                }
                catch (IOException e) {
                    throw new SQLException(e);
                }
                this.conn.log.debug("the result set has been closed");
            }
            Object var3_3 = null;
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(var3_3, joinPoint);
            return;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public boolean next() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        try {
            boolean bl;
            boolean bl2;
            boolean bl3;
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            this.checkClosed();
            if (this.fetchedRows == this.totalRows) {
                bl2 = bl3 = false;
            } else {
                int retry = 0;
                while (true) {
                    try {
                        if (this.reader == null) {
                            this.rebuildReader();
                            this.accumTime = System.currentTimeMillis();
                        }
                        this.reuseRecord = this.reader.read(this.reuseRecord);
                        int columns = this.reuseRecord.getColumnCount();
                        this.currentRow = new Object[columns];
                        int i = 0;
                        while (i < columns) {
                            this.currentRow[i] = this.reuseRecord.get(i);
                            ++i;
                        }
                        ++this.fetchedRows;
                        if (this.fetchedRows == this.totalRows) {
                            long end = System.currentTimeMillis();
                            this.conn.log.debug("It took me " + (end - this.startTime) + " ms to fetch all records");
                        }
                        if (this.fetchedRows % 10000L == 0L && this.fetchedRows != 0L) {
                            long delta = this.reader.getTotalBytes() / 1024L - this.accumKBytes;
                            long duration = System.currentTimeMillis() - this.accumTime;
                            this.conn.log.debug(String.format("fetched %d rows, %d KB, %.2f KB/s", 10000L, delta, Float.valueOf((float)delta / (float)duration * 1000.0f)));
                            this.accumKBytes = this.reader.getTotalBytes() / 1024L;
                            this.accumTime = System.currentTimeMillis();
                        }
                        bl2 = bl3 = true;
                    }
                    catch (IOException e) {
                        this.conn.log.info("read from a bad file, retry=" + retry);
                        if (++retry == 5) {
                            throw new SQLException("to much retries because: " + e.getMessage());
                        }
                        this.rebuildReader();
                        continue;
                    }
                    break;
                }
            }
            boolean bl4 = bl = bl2;
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(Conversions.booleanObject((boolean)bl), joinPoint);
            return bl3;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    private void rebuildReader() throws SQLException {
        try {
            long count = this.totalRows - this.fetchedRows;
            this.reader = this.sessionHandle.openRecordReader(this.fetchedRows, count, true);
            this.conn.log.debug(String.format("open read record, start=%d, cnt=%d", this.fetchedRows, count));
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
        catch (TunnelException e) {
            throw new SQLException(e);
        }
    }

    @Override
    protected Object[] rowAtCursor() throws SQLException {
        if (this.currentRow == null) {
            throw new SQLException("the row should be not-null, row=" + this.fetchedRows);
        }
        if (this.currentRow.length == 0) {
            throw new SQLException("the row should have more than 1 column , row=" + this.fetchedRows);
        }
        return this.currentRow;
    }

    static {
        OdpsForwardResultSet.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OdpsForwardResultSet.java", OdpsForwardResultSet.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getRow", "com.aliyun.odps.jdbc.OdpsForwardResultSet", "", "", "java.sql.SQLException", "int"), 81);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getType", "com.aliyun.odps.jdbc.OdpsForwardResultSet", "", "", "java.sql.SQLException", "int"), 87);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isClosed", "com.aliyun.odps.jdbc.OdpsForwardResultSet", "", "", "java.sql.SQLException", "boolean"), 92);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "close", "com.aliyun.odps.jdbc.OdpsForwardResultSet", "", "", "java.sql.SQLException", "void"), 97);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "next", "com.aliyun.odps.jdbc.OdpsForwardResultSet", "", "", "java.sql.SQLException", "boolean"), 115);
    }
}

