/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.jdbc;

import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.account.Account;
import com.aliyun.odps.account.AliyunAccount;
import com.aliyun.odps.jdbc.OdpsDatabaseMetaData;
import com.aliyun.odps.jdbc.OdpsPreparedStatement;
import com.aliyun.odps.jdbc.OdpsStatement;
import com.aliyun.odps.jdbc.PublicMethodAspect;
import com.aliyun.odps.jdbc.WrapperAdapter;
import com.aliyun.odps.jdbc.utils.ConnectionResource;
import com.aliyun.odps.jdbc.utils.OdpsLogger;
import com.aliyun.odps.jdbc.utils.Utils;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.Executor;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.MDC;

public class OdpsConnection
extends WrapperAdapter
implements Connection {
    private final Odps odps;
    private final Properties info;
    private final List<Statement> stmtHandles;
    private final String charset;
    private final String logviewHost;
    protected final int lifecycle;
    private boolean isClosed = false;
    protected OdpsLogger log;
    private SQLWarning warningChain = null;
    private String connectionId;
    private final Properties sqlTaskProperties = new Properties();
    private String tunnelEndpoint;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_21;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_22;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_23;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_24;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_25;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_26;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_27;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_28;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_29;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_30;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_31;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_32;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_33;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_34;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_35;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_36;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_37;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_38;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_39;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_40;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_41;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_42;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_43;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_44;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_45;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_46;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_47;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_48;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_49;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_50;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_51;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_52;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_53;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_54;

    OdpsConnection(String url, Properties info) throws SQLException {
        int lifecycle;
        ConnectionResource connRes = new ConnectionResource(url, info);
        String accessId = connRes.getAccessId();
        String accessKey = connRes.getAccessKey();
        String charset = connRes.getCharset();
        String project = connRes.getProject();
        String endpoint = connRes.getEndpoint();
        String tunnelEndpoint = connRes.getTunnelEndpoint();
        String logviewHost = connRes.getLogview();
        String logConfFile = connRes.getLogConfFile();
        try {
            lifecycle = Integer.parseInt(connRes.getLifecycle());
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("lifecycle is expected to be an integer");
        }
        this.connectionId = UUID.randomUUID().toString().substring(24);
        MDC.put((String)"connectionId", (String)this.connectionId);
        this.log = new OdpsLogger(this.getClass().getName(), null, false, logConfFile);
        if (connRes.getLogLevel() != null) {
            this.log.warn("The logLevel is deprecated, please set log level in log conf file!");
        }
        String version = Utils.retrieveVersion("driver.version");
        this.log.info("ODPS JDBC driver, Version " + version);
        this.log.info(String.format("endpoint=%s, project=%s", endpoint, project));
        this.log.info("JVM timezone : " + TimeZone.getDefault().getID());
        this.log.debug(String.format("charset=%s, logview=%s, lifecycle=%d", charset, logviewHost, lifecycle));
        AliyunAccount account = new AliyunAccount(accessId, accessKey);
        this.log.debug("debug mode on");
        this.odps = new Odps((Account)account);
        this.odps.setEndpoint(endpoint);
        this.odps.setDefaultProject(project);
        this.odps.setUserAgent("odps-jdbc-" + version);
        this.info = info;
        this.charset = charset;
        this.logviewHost = logviewHost;
        this.lifecycle = lifecycle;
        this.tunnelEndpoint = tunnelEndpoint;
        this.stmtHandles = new ArrayList<Statement>();
        try {
            this.odps.projects().get().reload();
            String msg = "Connect to odps project %s successfully";
            this.log.debug(String.format(msg, this.odps.getDefaultProject()));
        }
        catch (OdpsException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public OdpsPreparedStatement prepareStatement(String sql) throws SQLException {
        String string = sql;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        try {
            OdpsPreparedStatement odpsPreparedStatement;
            OdpsPreparedStatement odpsPreparedStatement2;
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            OdpsPreparedStatement stmt = new OdpsPreparedStatement(this, sql);
            this.stmtHandles.add(stmt);
            OdpsPreparedStatement odpsPreparedStatement3 = odpsPreparedStatement2 = (odpsPreparedStatement = stmt);
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(odpsPreparedStatement2, joinPoint);
            return odpsPreparedStatement;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        String string = sql;
        int n = autoGeneratedKeys;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string, (Object)Conversions.intObject((int)n));
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            this.log.error(String.valueOf(Thread.currentThread().getStackTrace()[1].getMethodName()) + " is not supported!!!");
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        String string = sql;
        int[] nArray = columnIndexes;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string, (Object)nArray);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            this.log.error(String.valueOf(Thread.currentThread().getStackTrace()[1].getMethodName()) + " is not supported!!!");
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        String string = sql;
        String[] stringArray = columnNames;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string, (Object)stringArray);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            this.log.error(String.valueOf(Thread.currentThread().getStackTrace()[1].getMethodName()) + " is not supported!!!");
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public OdpsPreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        String string = sql;
        int n = resultSetType;
        int n2 = resultSetConcurrency;
        Object[] objectArray = new Object[]{string, Conversions.intObject((int)n), Conversions.intObject((int)n2)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object[])objectArray);
        try {
            OdpsPreparedStatement odpsPreparedStatement;
            OdpsPreparedStatement odpsPreparedStatement2;
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            this.checkClosed();
            if (resultSetType == 1005) {
                throw new SQLFeatureNotSupportedException("Statement with resultset type: " + resultSetType + " is not supported");
            }
            if (resultSetConcurrency == 1008) {
                throw new SQLFeatureNotSupportedException("Statement with resultset concurrency: " + resultSetConcurrency + " is not supported");
            }
            boolean isResultSetScrollable = resultSetType == 1004;
            OdpsPreparedStatement stmt = new OdpsPreparedStatement(this, sql, isResultSetScrollable);
            this.stmtHandles.add(stmt);
            OdpsPreparedStatement odpsPreparedStatement3 = odpsPreparedStatement2 = (odpsPreparedStatement = stmt);
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(odpsPreparedStatement2, joinPoint);
            return odpsPreparedStatement;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        String string = sql;
        int n = resultSetType;
        int n2 = resultSetConcurrency;
        int n3 = resultSetHoldability;
        Object[] objectArray = new Object[]{string, Conversions.intObject((int)n), Conversions.intObject((int)n2), Conversions.intObject((int)n3)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object[])objectArray);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            this.log.error(String.valueOf(Thread.currentThread().getStackTrace()[1].getMethodName()) + " is not supported!!!");
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        String string = sql;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)string);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            this.log.error(String.valueOf(Thread.currentThread().getStackTrace()[1].getMethodName()) + " is not supported!!!");
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        String string = sql;
        int n = resultSetType;
        int n2 = resultSetConcurrency;
        Object[] objectArray = new Object[]{string, Conversions.intObject((int)n), Conversions.intObject((int)n2)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object[])objectArray);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        String string = sql;
        int n = resultSetType;
        int n2 = resultSetConcurrency;
        int n3 = resultSetHoldability;
        Object[] objectArray = new Object[]{string, Conversions.intObject((int)n), Conversions.intObject((int)n2), Conversions.intObject((int)n3)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object[])objectArray);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            this.log.error(String.valueOf(Thread.currentThread().getStackTrace()[1].getMethodName()) + " is not supported!!!");
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        String string = sql;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)string);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            this.log.error(String.valueOf(Thread.currentThread().getStackTrace()[1].getMethodName()) + " is not supported!!!");
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        boolean bl = autoCommit;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            if (!autoCommit) {
                this.log.error(String.valueOf(Thread.currentThread().getStackTrace()[1].getMethodName()) + " to false is not supported!!!");
                throw new SQLFeatureNotSupportedException("enabling autocommit is not supported");
            }
            Object var4_4 = null;
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(var4_4, joinPoint);
            return;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this);
        try {
            boolean bl;
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            boolean bl2 = true;
            boolean bl3 = bl = true;
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(Conversions.booleanObject((boolean)bl), joinPoint);
            return bl2;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void commit() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            this.log.error(String.valueOf(Thread.currentThread().getStackTrace()[1].getMethodName()) + " is not supported!!!");
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void rollback() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            this.log.error(String.valueOf(Thread.currentThread().getStackTrace()[1].getMethodName()) + " is not supported!!!");
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        Savepoint savepoint2 = savepoint;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this, (Object)savepoint2);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            this.log.error(String.valueOf(Thread.currentThread().getStackTrace()[1].getMethodName()) + " is not supported!!!");
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void close() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            MDC.remove((String)"connectionId");
            if (!this.isClosed) {
                for (Statement stmt : this.stmtHandles) {
                    if (stmt == null) continue;
                    stmt.close();
                }
            }
            this.isClosed = true;
            this.log.info("connection closed");
            Object var4_4 = null;
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(var4_4, joinPoint);
            return;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this);
        try {
            boolean bl;
            boolean bl2;
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            boolean bl3 = bl2 = (bl = this.isClosed);
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(Conversions.booleanObject((boolean)bl2), joinPoint);
            return bl;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this);
        try {
            OdpsDatabaseMetaData odpsDatabaseMetaData;
            OdpsDatabaseMetaData odpsDatabaseMetaData2;
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            this.checkClosed();
            OdpsDatabaseMetaData odpsDatabaseMetaData3 = odpsDatabaseMetaData2 = (odpsDatabaseMetaData = new OdpsDatabaseMetaData(this));
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(odpsDatabaseMetaData2, joinPoint);
            return odpsDatabaseMetaData;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        boolean bl = readOnly;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            if (readOnly) {
                this.log.error(String.valueOf(Thread.currentThread().getStackTrace()[1].getMethodName()) + " is not supported!!!");
                throw new SQLFeatureNotSupportedException("enabling read-only is not supported");
            }
            Object var4_4 = null;
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(var4_4, joinPoint);
            return;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this);
        try {
            boolean bl;
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            boolean bl2 = false;
            boolean bl3 = bl = false;
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(Conversions.booleanObject((boolean)bl), joinPoint);
            return bl2;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        String string = catalog;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)this, (Object)this, (Object)string);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            Object var4_4 = null;
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(var4_4, joinPoint);
            return;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public String getCatalog() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_21, (Object)this, (Object)this);
        try {
            String string;
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            String string2 = null;
            String string3 = string = null;
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(string, joinPoint);
            return string2;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        int n = level;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_22, (Object)this, (Object)this, (Object)Conversions.intObject((int)n));
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            this.log.error(String.valueOf(Thread.currentThread().getStackTrace()[1].getMethodName()) + " is not supported!!!");
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_23, (Object)this, (Object)this);
        try {
            int n;
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            int n2 = 0;
            int n3 = n = 0;
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(Conversions.intObject((int)n), joinPoint);
            return n2;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_24, (Object)this, (Object)this);
        try {
            SQLWarning sQLWarning;
            SQLWarning sQLWarning2;
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            SQLWarning sQLWarning3 = sQLWarning2 = (sQLWarning = this.warningChain);
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(sQLWarning2, joinPoint);
            return sQLWarning;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_25, (Object)this, (Object)this);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            this.warningChain = null;
            Object var2_2 = null;
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(var2_2, joinPoint);
            return;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_26, (Object)this, (Object)this);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            this.log.error(String.valueOf(Thread.currentThread().getStackTrace()[1].getMethodName()) + " is not supported!!!");
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        Map<String, Class<?>> map2 = map;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_27, (Object)this, (Object)this, map2);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            this.log.error(String.valueOf(Thread.currentThread().getStackTrace()[1].getMethodName()) + " is not supported!!!");
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        int n = holdability;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_28, (Object)this, (Object)this, (Object)Conversions.intObject((int)n));
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            this.log.error(String.valueOf(Thread.currentThread().getStackTrace()[1].getMethodName()) + " is not supported!!!");
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_29, (Object)this, (Object)this);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            this.log.error(String.valueOf(Thread.currentThread().getStackTrace()[1].getMethodName()) + " is not supported!!!");
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_30, (Object)this, (Object)this);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            this.log.error(String.valueOf(Thread.currentThread().getStackTrace()[1].getMethodName()) + " is not supported!!!");
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        String string = name;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_31, (Object)this, (Object)this, (Object)string);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            this.log.error(String.valueOf(Thread.currentThread().getStackTrace()[1].getMethodName()) + " is not supported!!!");
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        Savepoint savepoint2 = savepoint;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_32, (Object)this, (Object)this, (Object)savepoint2);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            this.log.error(String.valueOf(Thread.currentThread().getStackTrace()[1].getMethodName()) + " is not supported!!!");
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public OdpsStatement createStatement() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_33, (Object)this, (Object)this);
        try {
            OdpsStatement odpsStatement;
            OdpsStatement odpsStatement2;
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            this.checkClosed();
            OdpsStatement stmt = new OdpsStatement(this, false);
            this.stmtHandles.add(stmt);
            OdpsStatement odpsStatement3 = odpsStatement2 = (odpsStatement = stmt);
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(odpsStatement2, joinPoint);
            return odpsStatement;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public OdpsStatement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        int n = resultSetType;
        int n2 = resultSetConcurrency;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_34, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), (Object)Conversions.intObject((int)n2));
        try {
            OdpsStatement odpsStatement;
            OdpsStatement odpsStatement2;
            boolean isResultSetScrollable;
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            this.checkClosed();
            switch (resultSetType) {
                case 1003: {
                    isResultSetScrollable = false;
                    break;
                }
                case 1004: {
                    isResultSetScrollable = true;
                    break;
                }
                default: {
                    throw new SQLFeatureNotSupportedException("only support statement with ResultSet type: TYPE_SCROLL_INSENSITIVE, ResultSet.TYPE_FORWARD_ONLY");
                }
            }
            switch (resultSetConcurrency) {
                case 1007: {
                    break;
                }
                default: {
                    throw new SQLFeatureNotSupportedException("only support statement with ResultSet concurrency: CONCUR_READ_ONLY");
                }
            }
            OdpsStatement stmt = new OdpsStatement(this, isResultSetScrollable);
            this.stmtHandles.add(stmt);
            OdpsStatement odpsStatement3 = odpsStatement2 = (odpsStatement = stmt);
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(odpsStatement2, joinPoint);
            return odpsStatement;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        int n = resultSetType;
        int n2 = resultSetConcurrency;
        int n3 = resultSetHoldability;
        Object[] objectArray = new Object[]{Conversions.intObject((int)n), Conversions.intObject((int)n2), Conversions.intObject((int)n3)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_35, (Object)this, (Object)this, (Object[])objectArray);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            this.log.error(String.valueOf(Thread.currentThread().getStackTrace()[1].getMethodName()) + " is not supported!!!");
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public Clob createClob() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_36, (Object)this, (Object)this);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            this.log.error(String.valueOf(Thread.currentThread().getStackTrace()[1].getMethodName()) + " is not supported!!!");
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public Blob createBlob() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_37, (Object)this, (Object)this);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            this.log.error(String.valueOf(Thread.currentThread().getStackTrace()[1].getMethodName()) + " is not supported!!!");
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public NClob createNClob() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_38, (Object)this, (Object)this);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            this.log.error(String.valueOf(Thread.currentThread().getStackTrace()[1].getMethodName()) + " is not supported!!!");
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_39, (Object)this, (Object)this);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            this.log.error(String.valueOf(Thread.currentThread().getStackTrace()[1].getMethodName()) + " is not supported!!!");
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        int n = timeout;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_40, (Object)this, (Object)this, (Object)Conversions.intObject((int)n));
        try {
            boolean bl;
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            boolean bl2 = true;
            boolean bl3 = bl = true;
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(Conversions.booleanObject((boolean)bl), joinPoint);
            return bl2;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        Properties properties2 = properties;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_41, (Object)this, (Object)this, (Object)properties2);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            this.info.putAll((Map<?, ?>)properties);
            Object var4_4 = null;
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(var4_4, joinPoint);
            return;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        String string = name;
        String string2 = value;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_42, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            this.info.put(name, value);
            Object var6_6 = null;
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(var6_6, joinPoint);
            return;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_43, (Object)this, (Object)this);
        try {
            Properties properties;
            Properties properties2;
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            Properties properties3 = properties2 = (properties = this.info);
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(properties2, joinPoint);
            return properties;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        String string = name;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_44, (Object)this, (Object)this, (Object)string);
        try {
            String string2;
            String string3;
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            String string4 = string3 = (string2 = this.info.getProperty(name));
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(string3, joinPoint);
            return string2;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        String string = typeName;
        Object[] objectArray = elements;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_45, (Object)this, (Object)this, (Object)string, (Object)objectArray);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            this.log.error(String.valueOf(Thread.currentThread().getStackTrace()[1].getMethodName()) + " is not supported!!!");
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        String string = typeName;
        Object[] objectArray = attributes;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_46, (Object)this, (Object)this, (Object)string, (Object)objectArray);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            this.log.error(String.valueOf(Thread.currentThread().getStackTrace()[1].getMethodName()) + " is not supported!!!");
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        String string = schema;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_47, (Object)this, (Object)this, (Object)string);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            this.checkClosed();
            this.odps.setDefaultProject(schema);
            Object var4_4 = null;
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(var4_4, joinPoint);
            return;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public String getSchema() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_48, (Object)this, (Object)this);
        try {
            String string;
            String string2;
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            this.checkClosed();
            String string3 = string2 = (string = this.odps.getDefaultProject());
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(string2, joinPoint);
            return string;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        Executor executor2 = executor;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_49, (Object)this, (Object)this, (Object)executor2);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            this.log.error(String.valueOf(Thread.currentThread().getStackTrace()[1].getMethodName()) + " is not supported!!!");
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        Executor executor2 = executor;
        int n = milliseconds;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_50, (Object)this, (Object)this, (Object)executor2, (Object)Conversions.intObject((int)n));
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            this.log.error(String.valueOf(Thread.currentThread().getStackTrace()[1].getMethodName()) + " is not supported!!!");
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_51, (Object)this, (Object)this);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            this.log.error(String.valueOf(Thread.currentThread().getStackTrace()[1].getMethodName()) + " is not supported!!!");
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    public Odps getOdps() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_52, (Object)this, (Object)this);
        try {
            Odps odps;
            Odps odps2;
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            Odps odps3 = odps2 = (odps = this.odps);
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(odps2, joinPoint);
            return odps;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    private void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("the connection has already been closed");
        }
    }

    protected String getCharset() {
        return this.charset;
    }

    protected String getLogviewHost() {
        return this.logviewHost;
    }

    public Properties getSqlTaskProperties() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_53, (Object)this, (Object)this);
        try {
            Properties properties;
            Properties properties2;
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            Properties properties3 = properties2 = (properties = this.sqlTaskProperties);
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(properties2, joinPoint);
            return properties;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    public String getTunnelEndpoint() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_54, (Object)this, (Object)this);
        try {
            String string;
            String string2;
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            String string3 = string2 = (string = this.tunnelEndpoint);
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(string2, joinPoint);
            return string;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    static {
        OdpsConnection.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OdpsConnection.java", OdpsConnection.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "prepareStatement", "com.aliyun.odps.jdbc.OdpsConnection", "java.lang.String", "sql", "java.sql.SQLException", "com.aliyun.odps.jdbc.OdpsPreparedStatement"), 151);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "prepareStatement", "com.aliyun.odps.jdbc.OdpsConnection", "java.lang.String:int", "sql:autoGeneratedKeys", "java.sql.SQLException", "java.sql.PreparedStatement"), 158);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setAutoCommit", "com.aliyun.odps.jdbc.OdpsConnection", "boolean", "autoCommit", "java.sql.SQLException", "void"), 238);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAutoCommit", "com.aliyun.odps.jdbc.OdpsConnection", "", "", "java.sql.SQLException", "boolean"), 247);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "commit", "com.aliyun.odps.jdbc.OdpsConnection", "", "", "java.sql.SQLException", "void"), 252);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "rollback", "com.aliyun.odps.jdbc.OdpsConnection", "", "", "java.sql.SQLException", "void"), 258);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "rollback", "com.aliyun.odps.jdbc.OdpsConnection", "java.sql.Savepoint", "savepoint", "java.sql.SQLException", "void"), 264);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "close", "com.aliyun.odps.jdbc.OdpsConnection", "", "", "java.sql.SQLException", "void"), 270);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isClosed", "com.aliyun.odps.jdbc.OdpsConnection", "", "", "java.sql.SQLException", "boolean"), 284);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMetaData", "com.aliyun.odps.jdbc.OdpsConnection", "", "", "java.sql.SQLException", "java.sql.DatabaseMetaData"), 289);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setReadOnly", "com.aliyun.odps.jdbc.OdpsConnection", "boolean", "readOnly", "java.sql.SQLException", "void"), 295);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isReadOnly", "com.aliyun.odps.jdbc.OdpsConnection", "", "", "java.sql.SQLException", "boolean"), 303);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "prepareStatement", "com.aliyun.odps.jdbc.OdpsConnection", "java.lang.String:[I", "sql:columnIndexes", "java.sql.SQLException", "java.sql.PreparedStatement"), 164);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setCatalog", "com.aliyun.odps.jdbc.OdpsConnection", "java.lang.String", "catalog", "java.sql.SQLException", "void"), 312);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCatalog", "com.aliyun.odps.jdbc.OdpsConnection", "", "", "java.sql.SQLException", "java.lang.String"), 317);
        ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setTransactionIsolation", "com.aliyun.odps.jdbc.OdpsConnection", "int", "level", "java.sql.SQLException", "void"), 322);
        ajc$tjp_23 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTransactionIsolation", "com.aliyun.odps.jdbc.OdpsConnection", "", "", "java.sql.SQLException", "int"), 328);
        ajc$tjp_24 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getWarnings", "com.aliyun.odps.jdbc.OdpsConnection", "", "", "java.sql.SQLException", "java.sql.SQLWarning"), 333);
        ajc$tjp_25 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "clearWarnings", "com.aliyun.odps.jdbc.OdpsConnection", "", "", "java.sql.SQLException", "void"), 338);
        ajc$tjp_26 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTypeMap", "com.aliyun.odps.jdbc.OdpsConnection", "", "", "java.sql.SQLException", "java.util.Map"), 343);
        ajc$tjp_27 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setTypeMap", "com.aliyun.odps.jdbc.OdpsConnection", "java.util.Map", "map", "java.sql.SQLException", "void"), 349);
        ajc$tjp_28 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setHoldability", "com.aliyun.odps.jdbc.OdpsConnection", "int", "holdability", "java.sql.SQLException", "void"), 355);
        ajc$tjp_29 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getHoldability", "com.aliyun.odps.jdbc.OdpsConnection", "", "", "java.sql.SQLException", "int"), 361);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "prepareStatement", "com.aliyun.odps.jdbc.OdpsConnection", "java.lang.String:[Ljava.lang.String;", "sql:columnNames", "java.sql.SQLException", "java.sql.PreparedStatement"), 170);
        ajc$tjp_30 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setSavepoint", "com.aliyun.odps.jdbc.OdpsConnection", "", "", "java.sql.SQLException", "java.sql.Savepoint"), 367);
        ajc$tjp_31 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setSavepoint", "com.aliyun.odps.jdbc.OdpsConnection", "java.lang.String", "name", "java.sql.SQLException", "java.sql.Savepoint"), 373);
        ajc$tjp_32 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "releaseSavepoint", "com.aliyun.odps.jdbc.OdpsConnection", "java.sql.Savepoint", "savepoint", "java.sql.SQLException", "void"), 379);
        ajc$tjp_33 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createStatement", "com.aliyun.odps.jdbc.OdpsConnection", "", "", "java.sql.SQLException", "com.aliyun.odps.jdbc.OdpsStatement"), 385);
        ajc$tjp_34 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createStatement", "com.aliyun.odps.jdbc.OdpsConnection", "int:int", "resultSetType:resultSetConcurrency", "java.sql.SQLException", "com.aliyun.odps.jdbc.OdpsStatement"), 401);
        ajc$tjp_35 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createStatement", "com.aliyun.odps.jdbc.OdpsConnection", "int:int:int", "resultSetType:resultSetConcurrency:resultSetHoldability", "java.sql.SQLException", "java.sql.Statement"), 433);
        ajc$tjp_36 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createClob", "com.aliyun.odps.jdbc.OdpsConnection", "", "", "java.sql.SQLException", "java.sql.Clob"), 440);
        ajc$tjp_37 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createBlob", "com.aliyun.odps.jdbc.OdpsConnection", "", "", "java.sql.SQLException", "java.sql.Blob"), 446);
        ajc$tjp_38 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createNClob", "com.aliyun.odps.jdbc.OdpsConnection", "", "", "java.sql.SQLException", "java.sql.NClob"), 452);
        ajc$tjp_39 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createSQLXML", "com.aliyun.odps.jdbc.OdpsConnection", "", "", "java.sql.SQLException", "java.sql.SQLXML"), 458);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "prepareStatement", "com.aliyun.odps.jdbc.OdpsConnection", "java.lang.String:int:int", "sql:resultSetType:resultSetConcurrency", "java.sql.SQLException", "com.aliyun.odps.jdbc.OdpsPreparedStatement"), 185);
        ajc$tjp_40 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isValid", "com.aliyun.odps.jdbc.OdpsConnection", "int", "timeout", "java.sql.SQLException", "boolean"), 464);
        ajc$tjp_41 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setClientInfo", "com.aliyun.odps.jdbc.OdpsConnection", "java.util.Properties", "properties", "java.sql.SQLClientInfoException", "void"), 470);
        ajc$tjp_42 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setClientInfo", "com.aliyun.odps.jdbc.OdpsConnection", "java.lang.String:java.lang.String", "name:value", "java.sql.SQLClientInfoException", "void"), 475);
        ajc$tjp_43 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getClientInfo", "com.aliyun.odps.jdbc.OdpsConnection", "", "", "java.sql.SQLException", "java.util.Properties"), 480);
        ajc$tjp_44 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getClientInfo", "com.aliyun.odps.jdbc.OdpsConnection", "java.lang.String", "name", "java.sql.SQLException", "java.lang.String"), 485);
        ajc$tjp_45 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createArrayOf", "com.aliyun.odps.jdbc.OdpsConnection", "java.lang.String:[Ljava.lang.Object;", "typeName:elements", "java.sql.SQLException", "java.sql.Array"), 490);
        ajc$tjp_46 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createStruct", "com.aliyun.odps.jdbc.OdpsConnection", "java.lang.String:[Ljava.lang.Object;", "typeName:attributes", "java.sql.SQLException", "java.sql.Struct"), 496);
        ajc$tjp_47 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setSchema", "com.aliyun.odps.jdbc.OdpsConnection", "java.lang.String", "schema", "java.sql.SQLException", "void"), 501);
        ajc$tjp_48 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSchema", "com.aliyun.odps.jdbc.OdpsConnection", "", "", "java.sql.SQLException", "java.lang.String"), 506);
        ajc$tjp_49 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "abort", "com.aliyun.odps.jdbc.OdpsConnection", "java.util.concurrent.Executor", "executor", "java.sql.SQLException", "void"), 511);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "prepareStatement", "com.aliyun.odps.jdbc.OdpsConnection", "java.lang.String:int:int:int", "sql:resultSetType:resultSetConcurrency:resultSetHoldability", "java.sql.SQLException", "java.sql.PreparedStatement"), 206);
        ajc$tjp_50 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setNetworkTimeout", "com.aliyun.odps.jdbc.OdpsConnection", "java.util.concurrent.Executor:int", "executor:milliseconds", "java.sql.SQLException", "void"), 516);
        ajc$tjp_51 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getNetworkTimeout", "com.aliyun.odps.jdbc.OdpsConnection", "", "", "java.sql.SQLException", "int"), 521);
        ajc$tjp_52 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getOdps", "com.aliyun.odps.jdbc.OdpsConnection", "", "", "", "com.aliyun.odps.Odps"), 526);
        ajc$tjp_53 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSqlTaskProperties", "com.aliyun.odps.jdbc.OdpsConnection", "", "", "", "java.util.Properties"), 544);
        ajc$tjp_54 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTunnelEndpoint", "com.aliyun.odps.jdbc.OdpsConnection", "", "", "", "java.lang.String"), 548);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "prepareCall", "com.aliyun.odps.jdbc.OdpsConnection", "java.lang.String", "sql", "java.sql.SQLException", "java.sql.CallableStatement"), 213);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "prepareCall", "com.aliyun.odps.jdbc.OdpsConnection", "java.lang.String:int:int", "sql:resultSetType:resultSetConcurrency", "java.sql.SQLException", "java.sql.CallableStatement"), 219);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "prepareCall", "com.aliyun.odps.jdbc.OdpsConnection", "java.lang.String:int:int:int", "sql:resultSetType:resultSetConcurrency:resultSetHoldability", "java.sql.SQLException", "java.sql.CallableStatement"), 225);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "nativeSQL", "com.aliyun.odps.jdbc.OdpsConnection", "java.lang.String", "sql", "java.sql.SQLException", "java.lang.String"), 232);
    }
}

