/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.util.ClassLoaderBase;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class DynamicClassLoader
extends ClassLoaderBase {
    private static final Logger LOG = LoggerFactory.getLogger(DynamicClassLoader.class);
    private static final String DYNAMIC_JARS_DIR = File.separator + "jars" + File.separator;
    private static final String DYNAMIC_JARS_DIR_KEY = "hbase.dynamic.jars.dir";
    private static final String DYNAMIC_JARS_OPTIONAL_CONF_KEY = "hbase.use.dynamic.jars";
    private static final boolean DYNAMIC_JARS_OPTIONAL_DEFAULT = false;
    private boolean useDynamicJars;
    private File localDir;
    private FileSystem remoteDirFs;
    private Path remoteDir;
    private HashMap<String, Long> jarModifiedTime;

    public DynamicClassLoader(Configuration conf, ClassLoader parent) {
        super(parent);
        this.useDynamicJars = conf.getBoolean(DYNAMIC_JARS_OPTIONAL_CONF_KEY, false);
        if (this.useDynamicJars) {
            this.initTempDir(conf);
        }
    }

    private synchronized void initTempDir(Configuration conf) {
        this.jarModifiedTime = new HashMap();
        String localDirPath = conf.get("hbase.local.dir", "/tmp/hbase-local-dir") + DYNAMIC_JARS_DIR;
        this.localDir = new File(localDirPath);
        if (!this.localDir.mkdirs() && !this.localDir.isDirectory()) {
            throw new RuntimeException("Failed to create local dir " + this.localDir.getPath() + ", DynamicClassLoader failed to init");
        }
        String remotePath = conf.get(DYNAMIC_JARS_DIR_KEY);
        if (remotePath == null || remotePath.equals(localDirPath)) {
            this.remoteDir = null;
        } else {
            this.remoteDir = new Path(remotePath);
            try {
                this.remoteDirFs = this.remoteDir.getFileSystem(conf);
            }
            catch (IOException ioe) {
                LOG.warn("Failed to identify the fs of dir " + this.remoteDir + ", ignored", (Throwable)ioe);
                this.remoteDir = null;
            }
        }
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        try {
            return this.parent.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Class " + name + " not found - using dynamical class loader");
            }
            if (this.useDynamicJars) {
                return this.tryRefreshClass(name);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> tryRefreshClass(String name) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> clasz = this.findLoadedClass(name);
            if (clasz != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Class " + name + " already loaded");
                }
            } else {
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Finding class: " + name);
                    }
                    clasz = this.findClass(name);
                }
                catch (ClassNotFoundException cnfe) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Loading new jar files, if any");
                    }
                    this.loadNewJars();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Finding class again: " + name);
                    }
                    clasz = this.findClass(name);
                }
            }
            return clasz;
        }
    }

    private synchronized void loadNewJars() {
        File[] files;
        File[] fileArray = files = this.localDir == null ? null : this.localDir.listFiles();
        if (files != null) {
            for (File file : files) {
                String fileName = file.getName();
                if (this.jarModifiedTime.containsKey(fileName) || !file.isFile() || !fileName.endsWith(".jar")) continue;
                this.jarModifiedTime.put(fileName, file.lastModified());
                try {
                    URL url = file.toURI().toURL();
                    this.addURL(url);
                }
                catch (MalformedURLException mue) {
                    LOG.warn("Failed to load new jar " + fileName, (Throwable)mue);
                }
            }
        }
        FileStatus[] statuses = null;
        if (this.remoteDir != null) {
            try {
                statuses = this.remoteDirFs.listStatus(this.remoteDir);
            }
            catch (IOException ioe) {
                LOG.warn("Failed to check remote dir status " + this.remoteDir, (Throwable)ioe);
            }
        }
        if (statuses == null || statuses.length == 0) {
            return;
        }
        for (FileStatus status : statuses) {
            long lastModified;
            if (status.isDirectory()) continue;
            Path path = status.getPath();
            String fileName = path.getName();
            if (!fileName.endsWith(".jar")) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Ignored non-jar file " + fileName);
                continue;
            }
            Long cachedLastModificationTime = this.jarModifiedTime.get(fileName);
            if (cachedLastModificationTime != null && (lastModified = status.getModificationTime()) < cachedLastModificationTime) continue;
            try {
                File dst = new File(this.localDir, fileName);
                this.remoteDirFs.copyToLocalFile(path, new Path(dst.getPath()));
                this.jarModifiedTime.put(fileName, dst.lastModified());
                URL url = dst.toURI().toURL();
                this.addURL(url);
            }
            catch (IOException ioe) {
                LOG.warn("Failed to load new jar " + fileName, (Throwable)ioe);
            }
        }
    }
}

