/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.wrapper;

import com.aliyun.datahub.DatahubClient;
import com.aliyun.datahub.DatahubConfiguration;
import com.aliyun.datahub.common.data.RecordSchema;
import com.aliyun.datahub.common.data.RecordType;
import com.aliyun.datahub.model.GetCursorRequest;
import com.aliyun.datahub.model.GetRecordsResult;
import com.aliyun.datahub.model.GetTopicResult;
import com.aliyun.datahub.model.PutRecordsResult;
import com.aliyun.datahub.model.RecordEntry;
import com.aliyun.datahub.model.ShardDesc;
import com.aliyun.datahub.model.ShardEntry;
import java.util.List;

public class Topic {
    private GetTopicResult data;
    private DatahubClient client;

    private Topic(GetTopicResult data, DatahubClient client) {
        this.data = data;
        this.client = client;
    }

    public List<ShardEntry> listShard() {
        return this.client.listShard(this.data.getProjectName(), this.data.getTopicName()).getShards();
    }

    public List<ShardDesc> splitShard(String shardId, String splitKey) {
        return this.client.splitShard(this.data.getProjectName(), this.data.getTopicName(), shardId, splitKey).getShards();
    }

    public List<ShardDesc> splitShard(String shardId) {
        return this.client.splitShard(this.data.getProjectName(), this.data.getTopicName(), shardId).getShards();
    }

    public ShardDesc mergeShard(String shardId, String adjacentShardId) {
        return this.client.mergeShard(this.data.getProjectName(), this.data.getTopicName(), shardId, adjacentShardId).getChildShard();
    }

    public void waitForShardReady() {
        this.client.waitForShardReady(this.data.getProjectName(), this.data.getTopicName());
    }

    public void waitForShardReady(int timeout) {
        this.client.waitForShardReady(this.data.getProjectName(), this.data.getTopicName(), timeout);
    }

    public String getCursor(String shardId, long timestamp) {
        return this.client.getCursor(this.data.getProjectName(), this.data.getTopicName(), shardId, timestamp).getCursor();
    }

    public String getCursor(String shardId, GetCursorRequest.CursorType type) {
        return this.client.getCursor(this.data.getProjectName(), this.data.getTopicName(), shardId, type).getCursor();
    }

    public GetRecordsResult getRecords(String shardId, String cursor, int size) {
        return this.client.getRecords(this.data.getProjectName(), this.data.getTopicName(), shardId, cursor, size, this.data.getRecordSchema());
    }

    public PutRecordsResult putRecords(List<RecordEntry> entries) {
        return this.client.putRecords(this.data.getProjectName(), this.data.getTopicName(), entries);
    }

    public PutRecordsResult putRecords(List<RecordEntry> entries, int retries) {
        return this.client.putRecords(this.data.getProjectName(), this.data.getTopicName(), entries, retries);
    }

    public String getProjectName() {
        return this.data.getProjectName();
    }

    public String getTopicName() {
        return this.data.getTopicName();
    }

    public int getShardCount() {
        return this.data.getShardCount();
    }

    public int getLifeCycle() {
        return this.data.getLifeCycle();
    }

    public RecordType getRecordType() {
        return this.data.getRecordType();
    }

    public RecordSchema getRecordSchema() {
        return this.data.getRecordSchema();
    }

    public String getComment() {
        return this.data.getComment();
    }

    public long getCreateTime() {
        return this.data.getCreateTime();
    }

    public long getLastModifyTime() {
        return this.data.getLastModifyTime();
    }

    public static class Builder {
        public static Topic build(String projectName, String topicName, DatahubClient client) {
            return new Topic(client.getTopic(projectName, topicName), client);
        }

        public static Topic build(String projectName, String topicName, DatahubConfiguration conf) {
            DatahubClient client = new DatahubClient(conf);
            return Builder.build(projectName, topicName, client);
        }
    }
}

