/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.rest;

import com.aliyun.datahub.auth.Account;
import com.aliyun.datahub.common.transport.Connection;
import com.aliyun.datahub.common.transport.DefaultRequest;
import com.aliyun.datahub.common.transport.HttpMethod;
import com.aliyun.datahub.common.transport.Response;
import com.aliyun.datahub.common.transport.Transport;
import com.aliyun.datahub.common.util.RetryUtil;
import com.aliyun.datahub.exception.DatahubServiceException;
import com.aliyun.datahub.model.compress.Compression;
import com.aliyun.datahub.model.compress.CompressionFormat;
import com.aliyun.datahub.rest.ErrorMessage;
import com.aliyun.datahub.rest.JAXBUtils;
import com.aliyun.datahub.rest.RestException;
import java.io.IOException;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestClient {
    private Logger LOG = LoggerFactory.getLogger(RestClient.class);
    public static final int DEFAULT_CONNECT_TIMEOUT = 5;
    public static final int DEFAULT_CONNECT_RETRYTIMES = 4;
    public static final int DEFAULT_READ_TIMEOUT = 120;
    public static final boolean DEFAULT_IGNORE_CERTS = false;
    private final Transport transport;
    private Account account;
    private String endpoint;
    private boolean ignoreCerts = false;
    private static final String USER_AGENT_PREFIX = "JavaSDK Version ";
    private String userAgent;
    private CompressionFormat compressionFormat;
    private String sourceIp;
    private Boolean secureTransport;
    private RetryLogger logger = null;
    private static final String CHARSET = "UTF-8";
    int connectTimeout = 5;
    int readTimeout = 120;
    int retryTimes = 4;

    public RetryLogger getRetryLogger() {
        return this.logger;
    }

    public void setRetryLogger(RetryLogger logger) {
        this.logger = logger;
    }

    public RestClient(Transport transport, CompressionFormat compressionFormat) {
        this.transport = transport;
        this.compressionFormat = compressionFormat;
    }

    public Response request(final DefaultRequest request) {
        int retryTimes = 0;
        HttpMethod method = request.getHttpMethod();
        if (method == HttpMethod.GET || method == HttpMethod.HEAD) {
            retryTimes = this.getRetryTimes();
        }
        long retryWaitTime = this.getConnectTimeout() + this.getReadTimeout();
        try {
            return RetryUtil.executeWithRetry(new Callable<Response>(){

                @Override
                public Response call() throws Exception {
                    Response response = RestClient.this.requestWithNoRetry(request);
                    if (response == null) {
                        throw new DatahubServiceException("Response is null.");
                    }
                    if (response.getStatus() / 100 == 4) {
                        return response;
                    }
                    RestClient.this.handleErrorResponse(response);
                    return response;
                }
            }, retryTimes, retryWaitTime * 1000L, false);
        }
        catch (Exception e) {
            this.LOG.error("", (Throwable)e);
            throw new DatahubServiceException("Failed in Connection Retry.");
        }
    }

    private void handleErrorResponse(Response resp) {
        if (!resp.isOK()) {
            ErrorMessage error = null;
            try {
                error = JAXBUtils.unmarshal(resp, ErrorMessage.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            DatahubServiceException e = null;
            if (resp.getStatus() == 404) {
                if (error != null) {
                    e = new DatahubServiceException(error.getMessage(), new RestException(error));
                }
            } else if (error != null) {
                e = new DatahubServiceException(error.getMessage(), new RestException(error));
            } else {
                e = new DatahubServiceException(new String(resp.getBody()));
                e.setRequestId(resp.getHeader("x-datahub-request-id"));
            }
            throw e;
        }
    }

    public Response requestWithNoRetry(DefaultRequest request) {
        String type;
        if (this.compressionFormat != null && request.getBody() != null) {
            request.addHeader("Content-Encoding", this.compressionFormat.toString());
            if (this.compressionFormat.equals((Object)CompressionFormat.LZ4)) {
                request.addHeader("x-datahub-content-raw-size", Integer.toString(request.getBody().length));
            }
            request.addHeader("Accept-Encoding", this.compressionFormat.toString());
            byte[] compressed = Compression.compress(request.getBody(), this.compressionFormat);
            request.setBody(compressed);
        }
        if (this.sourceIp != null && !this.sourceIp.isEmpty()) {
            request.addHeader("x-datahub-source-ip", this.sourceIp);
        }
        if (this.secureTransport != null) {
            request.addHeader("x-datahub-secure-transport", this.secureTransport != false ? "true" : "false");
        }
        this.account.getRequestSigner().sign(request.getResource(), request);
        Response response = null;
        try {
            response = this.transport.request(request);
        }
        catch (IOException e) {
            throw new DatahubServiceException(e.getMessage(), e);
        }
        if (response.getBody() != null && response.getBody().length != 0 && (type = response.getHeaders().get("Content-Encoding")) != null && !type.isEmpty()) {
            try {
                CompressionFormat format = CompressionFormat.fromValue(type);
                if (format.equals((Object)CompressionFormat.LZ4)) {
                    String rawSizeString = response.getHeader("x-datahub-content-raw-size");
                    if (rawSizeString == null || rawSizeString.isEmpty()) {
                        throw new DatahubServiceException("DecompressError", "x-datahub-content-raw-sizeis missing.", response);
                    }
                    byte[] restored = Compression.decompress(response.getBody(), format, Integer.valueOf(rawSizeString));
                    response.setBody(restored);
                } else {
                    byte[] restored = Compression.decompress(response.getBody(), format);
                    response.setBody(restored);
                }
            }
            catch (RuntimeException e) {
                throw new DatahubServiceException("DecompressError", e.getMessage(), response);
            }
        }
        return response;
    }

    public Connection connect(DefaultRequest request) throws IOException {
        if (this.sourceIp != null && !this.sourceIp.isEmpty()) {
            request.addHeader("x-datahub-source-ip", this.sourceIp);
        }
        if (this.secureTransport != null) {
            request.addHeader("x-datahub-secure-transport", this.secureTransport != false ? "true" : "false");
        }
        this.account.getRequestSigner().sign(request.getResource(), request);
        return this.transport.connect(request);
    }

    public void setAccount(Account account) {
        this.account = account;
    }

    public Account getAccount() {
        return this.account;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public Transport getTransport() {
        return this.transport;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = ("JavaSDK Version  " + userAgent).trim();
    }

    public void setConnectTimeout(int timeout) {
        this.connectTimeout = timeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setReadTimeout(int timeout) {
        this.readTimeout = timeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public int getRetryTimes() {
        return this.retryTimes;
    }

    public void setRetryTimes(int retryTimes) {
        this.retryTimes = retryTimes;
    }

    public boolean isIgnoreCerts() {
        return this.ignoreCerts;
    }

    public void setIgnoreCerts(boolean ignoreCerts) {
        this.ignoreCerts = ignoreCerts;
    }

    public String getSourceIp() {
        return this.sourceIp;
    }

    public void setSourceIp(String sourceIp) {
        this.sourceIp = sourceIp;
    }

    public boolean getSecureTransport() {
        return this.secureTransport;
    }

    public void setSecureTransport(boolean secureTransport) {
        this.secureTransport = secureTransport;
    }

    public static abstract class RetryLogger {
        public abstract void onRetryLog(Throwable var1, long var2, long var4);
    }
}

