/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.model.serialize;

import com.aliyun.datahub.common.transport.DefaultRequest;
import com.aliyun.datahub.common.transport.HttpMethod;
import com.aliyun.datahub.common.util.JacksonParser;
import com.aliyun.datahub.exception.DatahubClientException;
import com.aliyun.datahub.model.PutRecordsRequest;
import com.aliyun.datahub.model.RecordEntry;
import com.aliyun.datahub.model.serialize.Serializer;
import java.util.List;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;

public class PutRecordsRequestJsonSer
implements Serializer<DefaultRequest, PutRecordsRequest> {
    private static PutRecordsRequestJsonSer instance;

    @Override
    public DefaultRequest serialize(PutRecordsRequest request) throws DatahubClientException {
        DefaultRequest req = new DefaultRequest();
        req.setResource("/projects/" + request.getProjectName() + "/topics/" + request.getTopicName() + "/shards");
        req.setHttpMethod(HttpMethod.POST);
        ObjectMapper mapper = JacksonParser.getObjectMapper();
        ObjectNode node = mapper.createObjectNode();
        node.put("Action", "pub");
        ArrayNode records = node.putArray("Records");
        List<RecordEntry> list = request.getRecords();
        for (RecordEntry record : list) {
            records.add(record.toJsonNode());
        }
        req.setBody(node.toString());
        return req;
    }

    private PutRecordsRequestJsonSer() {
    }

    public static PutRecordsRequestJsonSer getInstance() {
        if (instance == null) {
            instance = new PutRecordsRequestJsonSer();
        }
        return instance;
    }
}

