/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.model.serialize;

import com.aliyun.datahub.DatahubConstants;
import com.aliyun.datahub.common.transport.Response;
import com.aliyun.datahub.common.util.JacksonParser;
import com.aliyun.datahub.exception.DatahubServiceException;
import com.aliyun.datahub.model.ListShardRequest;
import com.aliyun.datahub.model.ListShardResult;
import com.aliyun.datahub.model.ShardEntry;
import com.aliyun.datahub.model.ShardState;
import com.aliyun.datahub.model.serialize.Deserializer;
import com.aliyun.datahub.model.serialize.JsonErrorParser;
import java.io.IOException;
import java.util.Iterator;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;

public class ListShardResultJsonDeser
implements Deserializer<ListShardResult, ListShardRequest, Response> {
    private static ListShardResultJsonDeser instance;

    @Override
    public ListShardResult deserialize(ListShardRequest request, Response response) throws DatahubServiceException {
        if (!response.isOK()) {
            throw JsonErrorParser.getInstance().parse(response);
        }
        ListShardResult rs = new ListShardResult();
        ObjectMapper mapper = JacksonParser.getObjectMapper();
        JsonNode tree = null;
        try {
            tree = mapper.readTree(response.getBody());
        }
        catch (IOException e) {
            throw new DatahubServiceException("JsonParseError", "Parse body failed:" + response.getBody(), response);
        }
        JsonNode node = tree.get("Shards");
        if (node != null && !node.isNull() && node.isArray()) {
            Iterator it = node.getElements();
            while (it.hasNext()) {
                JsonNode closedTime;
                JsonNode shard = (JsonNode)it.next();
                ShardEntry entry = new ShardEntry();
                entry.setShardId(shard.get("ShardId").asText());
                entry.setState(ShardState.valueOf(shard.get("State").asText()));
                entry.setBeginHashKey(shard.get("BeginHashKey").asText());
                entry.setEndHashKey(shard.get("EndHashKey").asText());
                JsonNode parents = shard.get("ParentShardIds");
                if (parents != null && !parents.isNull() && node.isArray()) {
                    Iterator pit = parents.getElements();
                    while (pit.hasNext()) {
                        JsonNode parent = (JsonNode)pit.next();
                        entry.addParentShardIds(parent.asText());
                    }
                }
                if ((closedTime = shard.get("ClosedTime")) != null) {
                    entry.setClosedTime(closedTime.asLong());
                }
                if (entry.getClosedTime() == 0L) {
                    if (!shard.get("LeftShardId").asText().equals(DatahubConstants.MAX_SHARD_ID)) {
                        entry.setLeftShardId(shard.get("LeftShardId").asText());
                    }
                    if (!shard.get("RightShardId").asText().equals(DatahubConstants.MAX_SHARD_ID)) {
                        entry.setRightShardId(shard.get("RightShardId").asText());
                    }
                }
                rs.addShard(entry);
            }
        }
        return rs;
    }

    private ListShardResultJsonDeser() {
    }

    public static ListShardResultJsonDeser getInstance() {
        if (instance == null) {
            instance = new ListShardResultJsonDeser();
        }
        return instance;
    }
}

