/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.model;

import com.aliyun.datahub.common.data.Field;
import com.aliyun.datahub.common.data.FieldType;
import com.aliyun.datahub.common.data.RecordSchema;
import com.aliyun.datahub.common.util.JacksonParser;
import com.aliyun.datahub.exception.DatahubClientException;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;

public class RecordEntry {
    private String partitionKey;
    private String hashKey;
    private String shardId;
    private Map<String, String> attributes = new HashMap<String, String>();
    private long systemTime;
    private Field[] fields;
    private Object[] values;
    private HashMap<String, Integer> nameMap = new HashMap();
    private static final String STRING_CHARSET = "UTF-8";
    private static final long DATETIME_MAX_TICKS = 253402271999000000L;
    private static final long DATETIME_MIN_TICKS = -62135798400000000L;

    public RecordEntry(RecordSchema schema) {
        if (schema == null) {
            throw new IllegalArgumentException("schema must not be null");
        }
        this.init(schema.getFields().toArray(new Field[0]));
    }

    public RecordEntry(Field[] fields) {
        if (fields == null) {
            throw new IllegalArgumentException("field list must not be null");
        }
        this.init(fields);
    }

    private void init(Field[] fields) {
        this.fields = fields;
        this.values = new Object[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            this.nameMap.put(fields[i].getName(), i);
        }
    }

    public long getRecordSize() {
        long len = 0L;
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] == null) continue;
            Field field = this.fields[i];
            if (field.getType() == FieldType.BIGINT) {
                len += 8L;
                continue;
            }
            if (field.getType() == FieldType.BOOLEAN) {
                len += 4L;
                continue;
            }
            if (field.getType() == FieldType.DOUBLE) {
                len += 8L;
                continue;
            }
            if (field.getType() == FieldType.TIMESTAMP) {
                len += 8L;
                continue;
            }
            if (field.getType() == FieldType.STRING) {
                len += (long)((String)this.values[i]).length();
                continue;
            }
            throw new IllegalArgumentException("unknown record type :" + field.getType().name());
        }
        return len;
    }

    public long getSystemTime() {
        return this.systemTime;
    }

    public void setSystemTime(long systemTime) {
        this.systemTime = systemTime;
    }

    public int getFieldCount() {
        return this.values.length;
    }

    public Field[] getFields() {
        return this.fields;
    }

    private Object get(int idx) {
        return this.values[idx];
    }

    private Object get(String columnName) {
        return this.values[this.getFieldIndex(columnName)];
    }

    public void setBigint(int idx, Long value) {
        if (value != null && (value > Long.MAX_VALUE || value <= Long.MIN_VALUE)) {
            throw new IllegalArgumentException("InvalidData: Bigint out of range.");
        }
        this.values[idx] = value;
    }

    public Long getBigint(int idx) {
        return (Long)this.get(idx);
    }

    public void setBigint(String columnName, Long value) {
        this.setBigint(this.getFieldIndex(columnName), value);
    }

    public Long getBigint(String columnName) {
        return (Long)this.get(columnName);
    }

    public void setDouble(int idx, Double value) {
        this.values[idx] = value;
    }

    public Double getDouble(int idx) {
        return (Double)this.get(idx);
    }

    public void setDouble(String columnName, Double value) {
        this.setDouble(this.getFieldIndex(columnName), value);
    }

    public Double getDouble(String columnName) {
        return (Double)this.get(columnName);
    }

    public void setBoolean(int idx, Boolean value) {
        this.values[idx] = value;
    }

    public Boolean getBoolean(int idx) {
        return (Boolean)this.get(idx);
    }

    public void setBoolean(String columnName, Boolean value) {
        this.setBoolean(this.getFieldIndex(columnName), value);
    }

    public Boolean getBoolean(String columnName) {
        return (Boolean)this.get(columnName);
    }

    public void setTimeStamp(int idx, Long value) {
        if (value != null && (value > Long.MAX_VALUE || value <= Long.MIN_VALUE)) {
            throw new IllegalArgumentException("InvalidData: timestamp out of range.");
        }
        this.values[idx] = value;
    }

    public Long getTimeStamp(int idx) {
        return (Long)this.get(idx);
    }

    public void setTimeStamp(String columnName, Long value) {
        this.setTimeStamp(this.getFieldIndex(columnName), value);
    }

    public Long getTimeStamp(String columnName) {
        return (Long)this.get(columnName);
    }

    public void setString(int idx, String value) {
        this.values[idx] = value;
    }

    public String getString(int idx) {
        Object o = this.get(idx);
        if (o == null) {
            return null;
        }
        return (String)o;
    }

    public void setString(String columnName, String value) {
        this.setString(this.getFieldIndex(columnName), value);
    }

    public String getString(String columnName) {
        return this.getString(this.getFieldIndex(columnName));
    }

    public int getFieldIndex(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Field name is null");
        }
        Integer idx = this.nameMap.get(name.toLowerCase());
        if (idx == null) {
            throw new IllegalArgumentException("No such column:" + name.toLowerCase());
        }
        return idx;
    }

    public void clear() {
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = null;
        }
    }

    public String getShardId() {
        return this.shardId;
    }

    public void setShardId(String shardId) {
        this.shardId = shardId;
    }

    public String getPartitionKey() {
        return this.partitionKey;
    }

    public void setPartitionKey(String partitionKey) {
        this.partitionKey = partitionKey;
    }

    public String getHashKey() {
        return this.hashKey;
    }

    public void setHashKey(String hashKey) {
        this.hashKey = hashKey;
    }

    public Map<String, String> getAttributes() {
        return new HashMap<String, String>(this.attributes);
    }

    public void putAttribute(String key, String value) {
        this.attributes.put(key, value);
    }

    public JsonNode toJsonNode() {
        ObjectMapper mapper = JacksonParser.getObjectMapper();
        ObjectNode node = mapper.createObjectNode();
        if (this.shardId != null && !this.shardId.isEmpty()) {
            node.put("ShardId", this.shardId);
        } else if (this.partitionKey != null && !this.partitionKey.isEmpty()) {
            node.put("PartitionKey", this.partitionKey);
        } else if (this.hashKey != null && !this.hashKey.isEmpty()) {
            node.put("HashKey", this.hashKey);
        } else {
            throw new DatahubClientException("Parameter shardId/partitionKey/hashKey not set.");
        }
        ObjectNode attr = node.putObject("Attributes");
        for (String key : this.attributes.keySet()) {
            attr.put(key, this.attributes.get(key));
        }
        ArrayNode record = node.putArray("Data");
        for (int i = 0; i < this.getFieldCount(); ++i) {
            if (this.get(i) != null) {
                record.add(String.valueOf(this.get(i)));
                continue;
            }
            record.add((JsonNode)null);
        }
        return node;
    }
}

