/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.exception;

import com.aliyun.datahub.common.transport.Response;
import com.aliyun.datahub.exception.DatahubClientException;

public class DatahubServiceException
extends DatahubClientException {
    private static final long serialVersionUID = 1L;
    private String requestId;
    private String errorCode;
    private String errorMessage;
    private int statusCode;

    public DatahubServiceException(String errorMessage) {
        super((String)null);
        this.errorMessage = errorMessage;
    }

    public DatahubServiceException(String errorMessage, Exception cause) {
        super(null, cause);
        this.errorMessage = errorMessage;
    }

    public DatahubServiceException(String errorCode, String errorMessage, Response response) {
        super((String)null);
        this.requestId = response.getHeader("x-datahub-request-id");
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
        this.statusCode = response.getStatus();
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String value) {
        this.errorMessage = value;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    public String getMessage() {
        return this.getErrorMessage() + " (Status Code: " + this.getStatusCode() + "; Error Code: " + this.getErrorCode() + "; Request ID: " + this.getRequestId() + ")";
    }
}

