/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.example;

import com.aliyun.datahub.DatahubClient;
import com.aliyun.datahub.DatahubConfiguration;
import com.aliyun.datahub.auth.AliyunAccount;
import com.aliyun.datahub.common.data.Field;
import com.aliyun.datahub.common.data.FieldType;
import com.aliyun.datahub.common.data.RecordSchema;
import com.aliyun.datahub.common.data.RecordType;
import com.aliyun.datahub.exception.DatahubClientException;
import com.aliyun.datahub.exception.InvalidCursorException;
import com.aliyun.datahub.model.GetCursorRequest;
import com.aliyun.datahub.model.GetCursorResult;
import com.aliyun.datahub.model.GetRecordsResult;
import com.aliyun.datahub.model.GetTopicResult;
import com.aliyun.datahub.model.ListShardResult;
import com.aliyun.datahub.model.PutRecordsResult;
import com.aliyun.datahub.model.RecordEntry;
import java.util.ArrayList;
import java.util.List;

public class DatahubExample {
    private String accessId = "***";
    private String accessKey = "***";
    private String endpoint = "http://dh-cn-hangzhou.aliyuncs.com";
    private String projectName = "project_test_example";
    private String topicName = "topic_test_example";
    private RecordSchema schema = null;
    private DatahubConfiguration conf = new DatahubConfiguration(new AliyunAccount(this.accessId, this.accessKey), this.endpoint);
    private DatahubClient client = new DatahubClient(this.conf);

    public void init() {
        this.schema = new RecordSchema();
        this.schema.addField(new Field("a", FieldType.STRING));
        this.client.createTopic(this.projectName, this.topicName, 3, 3, RecordType.TUPLE, this.schema, "topic");
        GetTopicResult topic = this.client.getTopic(this.projectName, this.topicName);
        this.schema = topic.getRecordSchema();
    }

    public void putRecords() {
        ListShardResult shards = this.client.listShard(this.projectName, this.topicName);
        ArrayList<RecordEntry> recordEntries = new ArrayList<RecordEntry>();
        int recordNum = 10;
        for (int n = 0; n < recordNum; ++n) {
            RecordEntry entry = new RecordEntry(this.schema);
            for (int i = 0; i < entry.getFieldCount(); ++i) {
                entry.setString(i, "");
            }
            String shardId = shards.getShards().get(0).getShardId();
            entry.setShardId(shardId);
            entry.putAttribute("partition", "ds=2016");
            recordEntries.add(entry);
        }
        PutRecordsResult result = this.client.putRecords(this.projectName, this.topicName, recordEntries);
    }

    public void getRecords() {
        ListShardResult shards = this.client.listShard(this.projectName, this.topicName);
        String shardId = shards.getShards().get(0).getShardId();
        GetCursorResult cursorRs = this.client.getCursor(this.projectName, this.topicName, shardId, System.currentTimeMillis() - 86400000L);
        String cursor = cursorRs.getCursor();
        int limit = 10;
        while (true) {
            try {
                while (true) {
                    GetRecordsResult recordRs = this.client.getRecords(this.projectName, this.topicName, shardId, cursor, limit, this.schema);
                    List<RecordEntry> recordEntries = recordRs.getRecords();
                    if (cursor.equals(recordRs.getNextCursor())) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    cursor = recordRs.getNextCursor();
                }
            }
            catch (InvalidCursorException ex) {
                cursorRs = this.client.getCursor(this.projectName, this.topicName, shardId, GetCursorRequest.CursorType.OLDEST);
                cursor = cursorRs.getCursor();
                continue;
            }
            break;
        }
    }

    public static void main(String[] args) {
        DatahubExample example = new DatahubExample();
        try {
            example.init();
            example.putRecords();
            example.getRecords();
        }
        catch (DatahubClientException e) {
            e.printStackTrace();
        }
    }
}

