/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.common.util;

import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryUtil {
    private static final Logger LOG = LoggerFactory.getLogger(RetryUtil.class);
    private static final long MAX_SLEEP_MILLISECOND = 256000L;

    public static <T> T executeWithRetry(Callable<T> callable, int retryTimes, long sleepTimeInMilliSecond, boolean exponential) throws Exception {
        Retry retry = new Retry();
        return retry.doRetry(callable, retryTimes, sleepTimeInMilliSecond, exponential);
    }

    private static class Retry {
        private Retry() {
        }

        public <T> T doRetry(Callable<T> callable, int retryTimes, long sleepTimeInMilliSecond, boolean exponential) throws Exception {
            if (null == callable) {
                throw new IllegalArgumentException("Callable!");
            }
            if (retryTimes < 0) {
                throw new IllegalArgumentException(String.format("retryTime[%d]!", retryTimes));
            }
            Exception saveException = null;
            for (int i = 0; i <= retryTimes; ++i) {
                try {
                    return this.call(callable);
                }
                catch (Exception e) {
                    long timeToSleep;
                    LOG.error("Exception when calling callable, " + (i + 1) + "ErrMsg:" + e.getMessage());
                    saveException = e;
                    if (i + 1 >= retryTimes || sleepTimeInMilliSecond <= 0L) continue;
                    if (exponential) {
                        timeToSleep = sleepTimeInMilliSecond * (long)Math.pow(2.0, i);
                        if (timeToSleep >= 256000L) {
                            timeToSleep = 256000L;
                        }
                    } else {
                        timeToSleep = sleepTimeInMilliSecond;
                        if (timeToSleep >= 256000L) {
                            timeToSleep = 256000L;
                        }
                    }
                    try {
                        Thread.sleep(timeToSleep);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
            }
            throw saveException;
        }

        protected <T> T call(Callable<T> callable) throws Exception {
            return callable.call();
        }
    }
}

