/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.common.util;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class IOUtils {
    public static final int READ_BUFFER_SIZE = 4096;
    private static final int EOF = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFully(InputStream in) throws IOException {
        try {
            byte[] buf = new byte[4096];
            int read = -1;
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            while ((read = in.read(buf)) != -1) {
                os.write(buf, 0, read);
            }
            os.close();
            byte[] byArray = os.toByteArray();
            return byArray;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public static long getInputStreamLength(InputStream in) throws IOException {
        if (in instanceof FileInputStream) {
            return ((FileInputStream)in).getChannel().size();
        }
        return in.available();
    }

    public static void resetInputStream(InputStream in) throws IOException {
        if (in.markSupported()) {
            in.reset();
        }
        if (in instanceof FileInputStream) {
            ((FileInputStream)in).getChannel().position(0L);
        }
    }

    public static long copyLarge(InputStream input, OutputStream output) throws IOException {
        return IOUtils.copyLarge(input, output, new byte[4096]);
    }

    public static long copyLarge(InputStream input, OutputStream output, byte[] buffer) throws IOException {
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static String readStreamAsString(InputStream in, String charset) throws IOException {
        return new String(IOUtils.readFully(in), charset);
    }

    public static String readStreamAsString(InputStream in) throws IOException {
        return new String(IOUtils.readFully(in), "utf-8");
    }
}

