/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.common.transport;

import com.aliyun.datahub.common.transport.HttpMethod;
import com.aliyun.datahub.common.util.DateUtils;
import com.aliyun.datahub.common.util.RevisionUtils;
import com.aliyun.datahub.exception.InvalidParameterException;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class DefaultRequest {
    protected HttpMethod httpMethod = HttpMethod.GET;
    protected String resource;
    protected final Map<String, String> params = new HashMap<String, String>();
    protected final Map<String, String> headers = new HashMap<String, String>();
    private static final String USER_AGENT = "JavaSDK Revision:" + RevisionUtils.getGitRevision() + " Version:" + RevisionUtils.getMavenVersion() + " JavaVersion:" + RevisionUtils.getJavaVersion();
    protected byte[] body = null;

    public DefaultRequest() {
        this.headers.put("Content-Type", "application/json");
        this.headers.put("Content-Length", "0");
        this.headers.put("Date", DateUtils.formatRfc822Date(new Date()));
        this.headers.put("User-Agent", USER_AGENT);
        this.headers.put("x-datahub-client-version", "1.1");
    }

    public void addParam(String key, String value) {
        this.params.put(key, value);
    }

    public void addParam(Map<String, String> exParams) {
        this.params.putAll(exParams);
    }

    public void setHttpMethod(HttpMethod httpMethod) {
        this.httpMethod = httpMethod;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public void addHeader(String key, String value) {
        this.headers.put(key, value);
    }

    public void addHeader(Map<String, String> exHeaders) {
        this.headers.putAll(exHeaders);
    }

    public void setBody(String body) {
        assert (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{body}));
        try {
            this.setBody(body.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new InvalidParameterException("unsupported encoding");
        }
    }

    public void setBody(byte[] body) {
        if (body != null) {
            this.body = body;
            this.headers.put("Content-Length", String.valueOf(this.body.length));
        }
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public String getResource() {
        return this.resource;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public byte[] getBody() {
        return this.body;
    }
}

