/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.core.utils;

import com.aliyun.core.utils.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class XmlUtil {
    public static Map<String, Object> deserializeXml(String xmlStr) throws DocumentException {
        if (StringUtils.isEmpty(xmlStr)) {
            return null;
        }
        return XmlUtil.DomToMap(DocumentHelper.parseText((String)xmlStr));
    }

    public static String serializeXml(Map xmlMap, String rootName) {
        if (xmlMap == null) {
            return null;
        }
        return XmlUtil.MapToDom(xmlMap, rootName).asXML();
    }

    private static Map<String, Object> DomToMap(Document document) {
        Element rootElement = document.getRootElement();
        HashMap<String, Object> map = new HashMap<String, Object>();
        XmlUtil.ElementToMap(rootElement, map);
        return map;
    }

    private static Object ElementToMap(Element element, Map<String, Object> map) {
        List elements = element.elements();
        if (elements.size() == 0) {
            if (null != map) {
                map.put(element.getName(), element.getTextTrim());
            }
            return element.getTextTrim();
        }
        HashMap<String, Object> subMap = new HashMap<String, Object>();
        if (null != map) {
            map.put(element.getName(), subMap);
        }
        for (Element elem : elements) {
            if (subMap.containsKey(elem.getName())) {
                Object remove;
                ArrayList<Object> list;
                Object o = subMap.get(elem.getName());
                Class<?> clazz = o.getClass();
                if (List.class.isAssignableFrom(clazz)) {
                    ((List)o).add(XmlUtil.ElementToMap(elem, null));
                    continue;
                }
                if (Map.class.isAssignableFrom(clazz)) {
                    list = new ArrayList<Object>();
                    remove = (Map)subMap.remove(elem.getName());
                    list.add(remove);
                    list.add(XmlUtil.ElementToMap(elem, null));
                    subMap.put(elem.getName(), list);
                    continue;
                }
                list = new ArrayList();
                remove = subMap.remove(elem.getName());
                list.add(remove);
                list.add(XmlUtil.ElementToMap(elem, null));
                subMap.put(elem.getName(), list);
                continue;
            }
            XmlUtil.ElementToMap(elem, subMap);
        }
        return subMap;
    }

    public static Document MapToDom(Map map, String rootName) {
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement(rootName);
        XmlUtil.MapToElement(root, map);
        return document;
    }

    private static void MapToElement(Element root, Map<String, ?> map) {
        if (null == map) {
            return;
        }
        for (Map.Entry<String, ?> en : map.entrySet()) {
            Element element;
            if (null == en.getValue()) continue;
            if (en.getValue() instanceof Map) {
                element = root.addElement(en.getKey());
                XmlUtil.MapToElement(element, (Map)en.getValue());
                continue;
            }
            if (en.getValue() instanceof List) {
                List value = (List)en.getValue();
                for (Object obj : value) {
                    Element element2 = root.addElement(en.getKey());
                    if (obj instanceof Map) {
                        XmlUtil.MapToElement(element2, (Map)obj);
                        continue;
                    }
                    element2.add(DocumentHelper.createText((String)obj.toString()));
                }
                continue;
            }
            element = root.addElement(en.getKey());
            element.add(DocumentHelper.createText((String)en.getValue().toString()));
        }
    }
}

