package com.aliyun.core.utils.tracing;

import com.aliyun.core.utils.Context;

import java.time.OffsetDateTime;
import java.util.Map;

public interface Tracer {

    String DISABLE_TRACING_KEY = "disable-tracing";

    Context start(String methodName, Context context);

    Context start(String methodName, Context context, ProcessKind processKind);

    void end(int responseCode, Throwable error, Context context);

    void end(String statusMessage, Throwable error, Context context);

    void setAttribute(String key, String value, Context context);

    Context setSpanName(String spanName, Context context);

    void addLink(Context context);

    Context extractContext(String diagnosticId, Context context);

    default Context getSharedSpanBuilder(String spanName, Context context) {
        // no-op
        return Context.NONE;
    }

    default void addEvent(String name, Map<String, Object> attributes, OffsetDateTime timestamp) {
    }
}
