package com.aliyun.core.http;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public class Header {
    private final String name;
    private final List<String> values;
    private String cachedStringValue;

    public Header(String name, String value) {
        Objects.requireNonNull(name, "'name' cannot be null.");
        this.name = name;
        this.values = new LinkedList<>();
        this.values.add(value);
    }

    public Header(String name, String... values) {
        Objects.requireNonNull(name, "'name' cannot be null.");
        this.name = name;
        this.values = new LinkedList<>();
        for (String value : values) {
            this.values.add(value);
        }
    }

    public Header(String name, List<String> values) {
        Objects.requireNonNull(name, "'name' cannot be null.");
        this.name = name;
        this.values = new LinkedList<>(values);
    }

    public String getName() {
        return name;
    }

    public String getValue() {
        checkCachedStringValue();
        return cachedStringValue;
    }

    public String[] getValues() {
        return values.toArray(new String[]{});
    }

    public List<String> getValuesList() {
        return Collections.unmodifiableList(values);
    }

    public void addValue(String value) {
        this.values.add(value);
        this.cachedStringValue = null;
    }

    @Override
    public String toString() {
        checkCachedStringValue();
        return name + ":" + cachedStringValue;
    }

    private void checkCachedStringValue() {
        if (cachedStringValue == null) {
            cachedStringValue = String.join(",", values);
        }
    }
}
