/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.auth.credentials.provider;

import com.aliyun.auth.credentials.Credential;
import com.aliyun.auth.credentials.ICredential;
import com.aliyun.auth.credentials.exception.CredentialException;
import com.aliyun.auth.credentials.http.CompatibleUrlConnClient;
import com.aliyun.auth.credentials.http.HttpRequest;
import com.aliyun.auth.credentials.http.HttpResponse;
import com.aliyun.auth.credentials.http.MethodType;
import com.aliyun.auth.credentials.provider.HttpCredentialProvider;
import com.aliyun.auth.credentials.utils.AuthUtils;
import com.aliyun.auth.credentials.utils.ParameterHelper;
import com.aliyun.auth.credentials.utils.RefreshResult;
import com.aliyun.core.utils.StringUtils;
import com.google.gson.Gson;
import java.time.Instant;
import java.util.Map;

public final class EcsRamRoleCredentialProvider
extends HttpCredentialProvider {
    private static final String URL_IN_ECS_METADATA = "/latest/meta-data/ram/security-credentials/";
    private static final String URL_IN_METADATA_TOKEN = "/latest/api/token";
    private static final String ECS_METADAT_FETCH_ERROR_MSG = "Failed to get RAM session credentials from ECS metadata service.";
    private final String roleName;
    private final String metadataServiceHost;
    private final Boolean disableIMDSv1;
    private final int connectionTimeout;
    private final int readTimeout;
    private final CompatibleUrlConnClient client;

    private EcsRamRoleCredentialProvider(BuilderImpl builder) {
        super(builder);
        if (AuthUtils.isDisableECSMetaData()) {
            throw new CredentialException("IMDS credentials is disabled.");
        }
        this.roleName = builder.roleName == null ? AuthUtils.getEnvironmentECSMetaData() : builder.roleName;
        this.disableIMDSv1 = builder.disableIMDSv1 == null ? AuthUtils.getDisableECSIMDSv1() : builder.disableIMDSv1;
        this.metadataServiceHost = builder.metadataServiceHost == null ? "100.100.100.200" : builder.metadataServiceHost;
        this.connectionTimeout = builder.connectionTimeout == null ? 1000 : builder.connectionTimeout;
        this.readTimeout = builder.readTimeout == null ? 1000 : builder.readTimeout;
        this.client = new CompatibleUrlConnClient();
        this.buildRefreshCache();
    }

    public static EcsRamRoleCredentialProvider create(String roleName) {
        return EcsRamRoleCredentialProvider.builder().roleName(roleName).build();
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    private String getMetadata(String url) {
        HttpResponse response;
        HttpRequest request = new HttpRequest(url);
        request.setSysMethod(MethodType.GET);
        request.setSysConnectTimeout(this.connectionTimeout);
        request.setSysReadTimeout(this.readTimeout);
        String metadataToken = this.getMetadataToken();
        if (metadataToken != null) {
            request.putHeaderParameter("X-aliyun-ecs-metadata-token", metadataToken);
        }
        try {
            response = this.client.syncInvoke(request);
        }
        catch (Exception e) {
            throw new CredentialException("Failed to connect ECS Metadata Service: " + e);
        }
        if (response.getResponseCode() == 404) {
            throw new CredentialException("The role name was not found in the instance.");
        }
        if (response.getResponseCode() != 200) {
            throw new CredentialException("Failed to get RAM session credentials from ECS metadata service. HttpCode=" + response.getResponseCode());
        }
        return response.getHttpContentString();
    }

    private String getMetadataToken() {
        try {
            HttpResponse response;
            HttpRequest request = new HttpRequest("http://" + this.metadataServiceHost + URL_IN_METADATA_TOKEN);
            request.setSysMethod(MethodType.PUT);
            request.setSysConnectTimeout(this.connectionTimeout);
            request.setSysReadTimeout(this.readTimeout);
            request.putHeaderParameter("X-aliyun-ecs-metadata-token-ttl-seconds", "21600");
            try {
                response = this.client.syncInvoke(request);
            }
            catch (Exception e) {
                throw new CredentialException("Failed to connect ECS Metadata Service: " + e);
            }
            if (response.getResponseCode() != 200) {
                throw new CredentialException("Failed to get token from ECS Metadata Service. HttpCode=" + response.getResponseCode() + ", ResponseMessage=" + response.getHttpContentString());
            }
            return new String(response.getHttpContent());
        }
        catch (Exception ex) {
            return this.throwErrorOrReturn(ex);
        }
    }

    private String throwErrorOrReturn(Exception e) {
        if (this.disableIMDSv1.booleanValue()) {
            throw new CredentialException("Failed to get token from ECS Metadata Service, and fallback to IMDS v1 is disabled via the disableIMDSv1 configuration is turned on. Original error: " + e.getMessage());
        }
        return null;
    }

    @Override
    public RefreshResult<ICredential> refreshCredentials() {
        String jsonContent;
        Map result;
        String roleName = this.roleName;
        if (StringUtils.isEmpty((CharSequence)this.roleName)) {
            roleName = this.getMetadata("http://" + this.metadataServiceHost + URL_IN_ECS_METADATA);
        }
        if (!"Success".equals((result = (Map)new Gson().fromJson(jsonContent = this.getMetadata("http://" + this.metadataServiceHost + URL_IN_ECS_METADATA + roleName), Map.class)).get("Code"))) {
            throw new CredentialException(ECS_METADAT_FETCH_ERROR_MSG);
        }
        if (!(result.containsKey("AccessKeyId") && result.containsKey("AccessKeySecret") && result.containsKey("SecurityToken"))) {
            throw new CredentialException(String.format("Error retrieving credentials from IMDS result: %s.", jsonContent));
        }
        Instant expiration = ParameterHelper.getUTCDate((String)result.get("Expiration")).toInstant();
        Credential credential = Credential.builder().accessKeyId((String)result.get("AccessKeyId")).accessKeySecret((String)result.get("AccessKeySecret")).securityToken((String)result.get("SecurityToken")).build();
        return RefreshResult.builder(credential).staleTime(this.getStaleTime(expiration)).prefetchTime(this.getPrefetchTime(expiration)).build();
    }

    @Override
    public void close() {
        super.close();
        this.client.close();
    }

    private static final class BuilderImpl
    extends HttpCredentialProvider.BuilderImpl<EcsRamRoleCredentialProvider, Builder>
    implements Builder {
        private String roleName;
        private String metadataServiceHost;
        private Boolean disableIMDSv1;
        private Integer connectionTimeout;
        private Integer readTimeout;

        private BuilderImpl() {
        }

        @Override
        public Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        @Override
        public Builder metadataServiceHost(String metadataServiceHost) {
            this.metadataServiceHost = metadataServiceHost;
            return this;
        }

        @Override
        public Builder disableIMDSv1(Boolean disableIMDSv1) {
            this.disableIMDSv1 = disableIMDSv1;
            return this;
        }

        @Override
        public Builder connectionTimeout(Integer connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        @Override
        public Builder readTimeout(Integer readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        @Override
        public EcsRamRoleCredentialProvider build() {
            return new EcsRamRoleCredentialProvider(this);
        }
    }

    public static interface Builder
    extends HttpCredentialProvider.Builder<EcsRamRoleCredentialProvider, Builder> {
        public Builder roleName(String var1);

        public Builder metadataServiceHost(String var1);

        public Builder disableIMDSv1(Boolean var1);

        public Builder connectionTimeout(Integer var1);

        public Builder readTimeout(Integer var1);

        @Override
        public EcsRamRoleCredentialProvider build();
    }
}

