package com.aliyun.auth.signature.signer;

import com.aliyun.auth.signature.exception.SignatureException;

import javax.crypto.Mac;
import java.security.NoSuchAlgorithmException;

public enum SignAlgorithmHmacSHA1 {
    HmacSHA1("HmacSHA1");

    private final ThreadLocal<Mac> reference;
    private final String algorithmName;

    SignAlgorithmHmacSHA1(String algorithmName) {
        this.algorithmName = algorithmName;
        reference = new MacThreadLocal(algorithmName);
    }

    public String getAlgorithmName(){
        return this.algorithmName;
    }

    public Mac getMac() {
        return reference.get();
    }

    private static class MacThreadLocal extends ThreadLocal<Mac> {
        private final String algorithmName;

        MacThreadLocal(String algorithmName) {
            this.algorithmName = algorithmName;
        }

        @Override
        protected Mac initialValue() {
            try {
                return Mac.getInstance(algorithmName);
            } catch (NoSuchAlgorithmException e) {
                throw new SignatureException("Unable to fetch Mac instance for Algorithm "
                                + algorithmName + e.getMessage());

            }
        }
    }
}
