/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.test.runner;

import com.alipay.sofa.test.annotation.DelegateToRunner;
import com.alipay.sofa.test.utils.TestModeUtil;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.manipulation.Sortable;
import org.junit.runner.manipulation.Sorter;
import org.junit.runner.notification.RunNotifier;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.util.ClassUtils;

public class SofaJUnit4Runner
extends Runner
implements Filterable,
Sortable {
    private static final String DEFAULT_JUNIT4_RUNNER = "org.junit.runners.JUnit4";
    private static final String SOFA_ARK_JUNIT4_RUNNER = "com.alipay.sofa.ark.support.runner.ArkJUnit4Runner";
    protected Runner runner;

    public SofaJUnit4Runner(Class<?> klazz) {
        String testRunner = null;
        Class<Object> runnerClass = null;
        DelegateToRunner annotation = (DelegateToRunner)AnnotationUtils.getAnnotation(klazz, DelegateToRunner.class);
        if (annotation != null) {
            runnerClass = annotation.value();
        } else {
            testRunner = TestModeUtil.isArkMode() ? this.getArkModeRunner() : this.getDefaultRunner();
        }
        try {
            if (runnerClass == null) {
                runnerClass = ClassUtils.getDefaultClassLoader().loadClass(testRunner);
            }
            if (TestModeUtil.isArkMode() && SpringJUnit4ClassRunner.class.isAssignableFrom(runnerClass)) {
                throw new RuntimeException(String.format("As TestRunner is %s, dependency of sofa-ark-springboot-starter should be removed from classpath!", runnerClass.getCanonicalName()));
            }
            this.runner = (Runner)runnerClass.getConstructor(Class.class).newInstance(klazz);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public Description getDescription() {
        return this.runner.getDescription();
    }

    public void run(RunNotifier notifier) {
        this.runner.run(notifier);
    }

    public void filter(Filter filter) throws NoTestsRemainException {
        ((Filterable)this.runner).filter(filter);
    }

    public void sort(Sorter sorter) {
        ((Sortable)this.runner).sort(sorter);
    }

    public String getArkModeRunner() {
        return SOFA_ARK_JUNIT4_RUNNER;
    }

    public String getDefaultRunner() {
        return DEFAULT_JUNIT4_RUNNER;
    }
}

