/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.registry.local;

import com.alipay.sofa.rpc.client.ProviderGroup;
import com.alipay.sofa.rpc.client.ProviderHelper;
import com.alipay.sofa.rpc.client.ProviderInfo;
import com.alipay.sofa.rpc.common.struct.ScheduledService;
import com.alipay.sofa.rpc.common.utils.CommonUtils;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.config.ConsumerConfig;
import com.alipay.sofa.rpc.config.ProviderConfig;
import com.alipay.sofa.rpc.config.RegistryConfig;
import com.alipay.sofa.rpc.ext.Extension;
import com.alipay.sofa.rpc.listener.ProviderInfoListener;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.registry.Registry;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;

@Extension(value="domain")
public class DomainRegistry
extends Registry {
    private static final Logger LOGGER = LoggerFactory.getLogger(DomainRegistry.class);
    private static final Map<ProviderInfo, ProviderInfo> EMPTY_MAP = new HashMap<ProviderInfo, ProviderInfo>(0);
    protected Map<String, List<ConsumerConfig>> notifyListeners = new ConcurrentHashMap<String, List<ConsumerConfig>>();
    protected Map<String, List<ProviderInfo>> domainCache = new ConcurrentHashMap<String, List<ProviderInfo>>();
    protected int scanPeriod = 10000;
    protected ScheduledService scheduledExecutorService;
    protected AtomicBoolean inited = new AtomicBoolean();

    protected DomainRegistry(RegistryConfig registryConfig) {
        super(registryConfig);
    }

    @Override
    public void init() {
        if (this.inited.compareAndSet(false, true)) {
            this.scanPeriod = CommonUtils.parseInt(this.registryConfig.getParameter("registry.domain.scan.period"), this.scanPeriod);
            Runnable task = () -> {
                try {
                    this.refreshDomain();
                    this.notifyListener();
                }
                catch (Throwable e) {
                    LOGGER.error(e.getMessage(), e);
                }
            };
            this.scheduledExecutorService = new ScheduledService("DomainRegistry-Back-Load", 1, task, this.scanPeriod, this.scanPeriod, TimeUnit.MILLISECONDS).start();
        }
    }

    protected void refreshDomain() {
        HashSet<String> keySet = new HashSet<String>();
        for (Map.Entry<String, List<ConsumerConfig>> entry : this.notifyListeners.entrySet()) {
            String directUrl = entry.getKey();
            String[] providerStrs = StringUtils.splitWithCommaOrSemicolon(directUrl);
            keySet.addAll(Arrays.asList(providerStrs));
        }
        for (String directUrl : keySet) {
            ProviderInfo providerInfo = ProviderHelper.toProviderInfo(directUrl);
            List<ProviderInfo> result = this.directUrl2IpUrl(providerInfo, this.domainCache.get(directUrl));
            this.domainCache.put(directUrl, result);
        }
    }

    protected void notifyListener() {
        for (Map.Entry<String, List<ConsumerConfig>> entry : this.notifyListeners.entrySet()) {
            String directUrls = entry.getKey();
            String[] providerStrs = StringUtils.splitWithCommaOrSemicolon(directUrls);
            ArrayList<ProviderInfo> result = new ArrayList<ProviderInfo>();
            for (String providerStr : providerStrs) {
                List<ProviderInfo> providerInfos = this.domainCache.get(providerStr);
                result.addAll(providerInfos);
            }
            List<ConsumerConfig> configs = entry.getValue();
            for (ConsumerConfig config : configs) {
                ProviderGroup providerGroup = new ProviderGroup("_DIRECT", result);
                ProviderInfoListener providerInfoListener = config.getProviderInfoListener();
                if (config.getProviderInfoListener() == null) continue;
                providerInfoListener.updateProviders(providerGroup);
            }
        }
    }

    private ProviderGroup getDirectGroup(String directUrl) {
        String[] providerStrs;
        ArrayList<ProviderInfo> tmpProviderInfoList = new ArrayList<ProviderInfo>();
        for (String providerStr : providerStrs = StringUtils.splitWithCommaOrSemicolon(directUrl)) {
            List<ProviderInfo> providerInfos = this.resolveDomain(providerStr);
            tmpProviderInfoList.addAll(providerInfos);
        }
        return new ProviderGroup("_DIRECT", tmpProviderInfoList);
    }

    protected List<ProviderInfo> resolveDomain(String directUrl) {
        List<ProviderInfo> providerInfos = this.domainCache.get(directUrl);
        if (providerInfos != null) {
            return providerInfos;
        }
        ProviderInfo providerInfo = this.convertToProviderInfo(directUrl);
        List<ProviderInfo> result = this.directUrl2IpUrl(providerInfo, this.domainCache.get(directUrl));
        this.domainCache.put(directUrl, result);
        return result;
    }

    protected ProviderInfo convertToProviderInfo(String providerStr) {
        return ProviderHelper.toProviderInfo(providerStr);
    }

    protected List<ProviderInfo> directUrl2IpUrl(ProviderInfo providerInfo, List<ProviderInfo> originList) {
        ArrayList<ProviderInfo> result = new ArrayList<ProviderInfo>();
        try {
            String originHost = providerInfo.getHost();
            String originUrl = providerInfo.getOriginUrl();
            InetAddress[] addresses = InetAddress.getAllByName(originHost);
            if (addresses != null && addresses.length > 0) {
                Map<ProviderInfo, ProviderInfo> originMap = originList == null ? EMPTY_MAP : originList.stream().collect(Collectors.toMap(Function.identity(), Function.identity()));
                String firstHost = addresses[0].getHostAddress();
                if (firstHost == null || firstHost.equals(providerInfo.getHost())) {
                    this.addProviderInfo(result, originMap, providerInfo);
                    return result;
                }
                if (StringUtils.isNotBlank(originUrl)) {
                    for (InetAddress address : addresses) {
                        String newHost = address.getHostAddress();
                        ProviderInfo tmp = providerInfo.clone();
                        String newUrl = originUrl.replace(originHost, newHost);
                        tmp.setOriginUrl(newUrl);
                        tmp.setHost(newHost);
                        this.addProviderInfo(result, originMap, tmp);
                    }
                    return result;
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("directUrl2IpUrl error", e);
        }
        ArrayList<ProviderInfo> providerInfos = new ArrayList<ProviderInfo>();
        providerInfos.add(providerInfo);
        return providerInfos;
    }

    protected void addProviderInfo(List<ProviderInfo> target, Map<ProviderInfo, ProviderInfo> originMap, ProviderInfo providerInfo) {
        ProviderInfo originProviderInfo = originMap.get(providerInfo);
        if (originProviderInfo != null) {
            target.add(originProviderInfo);
        } else {
            target.add(providerInfo);
        }
    }

    @Override
    public boolean start() {
        return false;
    }

    @Override
    public void register(ProviderConfig config) {
        throw new UnsupportedOperationException("DomainRegistry not support register providerConfig:" + config.getInterfaceId());
    }

    @Override
    public void unRegister(ProviderConfig config) {
        throw new UnsupportedOperationException("DomainRegistry not support unRegister providerConfig:" + config.getInterfaceId());
    }

    @Override
    public void batchUnRegister(List<ProviderConfig> configs) {
    }

    @Override
    public List<ProviderGroup> subscribe(ConsumerConfig config) {
        String directUrl = config.getDirectUrl();
        if (StringUtils.isNotBlank(directUrl)) {
            List<ConsumerConfig> listeners = this.notifyListeners.get(directUrl);
            if (listeners == null) {
                this.notifyListeners.putIfAbsent(directUrl, new CopyOnWriteArrayList());
                listeners = this.notifyListeners.get(directUrl);
            }
            listeners.add(config);
            ProviderGroup directGroup = this.getDirectGroup(directUrl);
            ArrayList<ProviderGroup> providerGroups = new ArrayList<ProviderGroup>();
            providerGroups.add(directGroup);
            return providerGroups;
        }
        return null;
    }

    @Override
    public void unSubscribe(ConsumerConfig consumerConfig) {
        String directUrl = consumerConfig.getDirectUrl();
        this.notifyListeners.get(directUrl).remove(consumerConfig);
    }

    @Override
    public void batchUnSubscribe(List<ConsumerConfig> configs) {
        for (ConsumerConfig config : configs) {
            this.unSubscribe(config);
        }
    }

    @Override
    public void destroy() {
        this.notifyListeners.clear();
        this.domainCache.clear();
        if (this.scheduledExecutorService != null) {
            this.scheduledExecutorService.shutdown();
        }
    }
}

