/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.registry.consul.model;

import com.alipay.sofa.rpc.registry.consul.common.ConsulURL;
import com.alipay.sofa.rpc.registry.consul.common.ConsulURLUtils;
import com.alipay.sofa.rpc.registry.consul.model.AbstractBuilder;
import com.alipay.sofa.rpc.registry.consul.model.ThrallRoleType;
import com.ecwid.consul.v1.session.model.NewSession;
import com.ecwid.consul.v1.session.model.Session;

public final class ConsulEphemeralNode {
    private final ConsulURL url;
    private final String interval;
    private final ThrallRoleType ephemeralType;

    private ConsulEphemeralNode(Builder builder) {
        this.url = builder.url;
        this.interval = builder.interval;
        this.ephemeralType = builder.ephemeralType;
    }

    public NewSession getNewSession() {
        NewSession newSersson = new NewSession();
        newSersson.setName(this.getSessionName());
        newSersson.setLockDelay(15L);
        newSersson.setBehavior(Session.Behavior.DELETE);
        newSersson.setTtl(this.interval + "s");
        return newSersson;
    }

    public String getSessionName() {
        return this.ephemeralType.name() + "_" + this.url.getHost() + "_" + this.url.getPort();
    }

    public String getEphemralNodeKey() {
        return ConsulURLUtils.ephemralNodePath(this.url, this.ephemeralType);
    }

    public String getEphemralNodeValue() {
        return this.url.toFullString();
    }

    public static Builder newEphemralNode() {
        return new Builder();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ephemeralType == null ? 0 : this.ephemeralType.hashCode());
        result = 31 * result + (this.interval == null ? 0 : this.interval.hashCode());
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConsulEphemeralNode other = (ConsulEphemeralNode)obj;
        if (this.ephemeralType != other.ephemeralType) {
            return false;
        }
        if (this.interval == null ? other.interval != null : !this.interval.equals(other.interval)) {
            return false;
        }
        return !(this.url == null ? other.url != null : !this.url.equals(other.url));
    }

    public String toString() {
        return "ConsulEphemeralNode [url=" + this.url + ", interval=" + this.interval + ", ephemeralType=" + (Object)((Object)this.ephemeralType) + "]";
    }

    public static class Builder
    extends AbstractBuilder {
        private ConsulURL url;
        private String interval;
        private ThrallRoleType ephemeralType;

        public Builder withUrl(ConsulURL url) {
            this.url = url;
            return this;
        }

        public Builder withEphemralType(ThrallRoleType ephemeralType) {
            this.ephemeralType = ephemeralType;
            return this;
        }

        public Builder withCheckInterval(String interval) {
            this.interval = this.substituteEnvironmentVariables(interval);
            return this;
        }

        public ConsulEphemeralNode build() {
            return new ConsulEphemeralNode(this);
        }
    }
}

