/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.registry.consul.common;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class ConsulURL
implements Serializable {
    private static final long serialVersionUID = -1985165475234910535L;
    static final String UTF8_ENCODING = "UTF-8";
    static final String INTERFACE = "interface";
    static final String GROUP_KEY = "group";
    private final String protocol;
    private final String host;
    private final int port;
    private final String group;
    private final String interfaceId;
    private final String path;
    private final Map<String, String> parameters;
    private volatile transient String ip;
    private volatile transient String full;
    private volatile transient String string;

    protected ConsulURL() {
        this.protocol = null;
        this.host = null;
        this.port = 0;
        this.path = null;
        this.group = null;
        this.interfaceId = null;
        this.parameters = null;
    }

    public ConsulURL(String protocol, String host, int port, String path, String group, String interfaceId, Map<String, String> parameters) {
        this.protocol = protocol;
        this.host = host;
        this.port = port < 0 ? 0 : port;
        this.path = path;
        this.interfaceId = interfaceId;
        this.group = group;
        while (path != null && path.startsWith("/")) {
            path = path.substring(1);
        }
        parameters = parameters == null ? new HashMap<String, String>() : new HashMap<String, String>(parameters);
        this.parameters = Collections.unmodifiableMap(parameters);
    }

    public static ConsulURL valueOf(String url) {
        if (url == null || (url = url.trim()).length() == 0) {
            throw new IllegalArgumentException("url is null");
        }
        String protocol = null;
        String host = null;
        String interfaceId = null;
        String group = null;
        int port = 0;
        String path = null;
        HashMap<String, String> parameters = null;
        int i = url.indexOf("?");
        if (i >= 0) {
            String[] parts = url.substring(i + 1).split("\\&");
            parameters = new HashMap<String, String>();
            for (String part : parts) {
                if ((part = part.trim()).length() <= 0) continue;
                int j = part.indexOf(61);
                if (j >= 0) {
                    parameters.put(part.substring(0, j), part.substring(j + 1));
                    continue;
                }
                parameters.put(part, part);
            }
            interfaceId = (String)parameters.get(INTERFACE);
            group = (String)parameters.get(GROUP_KEY);
            url = url.substring(0, i);
        }
        if ((i = url.indexOf("://")) >= 0) {
            if (i == 0) {
                throw new IllegalStateException("url missing protocol: \"" + url + "\"");
            }
            protocol = url.substring(0, i);
            url = url.substring(i + 3);
        } else {
            i = url.indexOf(":/");
            if (i >= 0) {
                if (i == 0) {
                    throw new IllegalStateException("url missing protocol: \"" + url + "\"");
                }
                protocol = url.substring(0, i);
                url = url.substring(i + 1);
            }
        }
        i = url.indexOf("/");
        if (i >= 0) {
            path = url.substring(i + 1);
            url = url.substring(0, i);
        }
        if ((i = url.indexOf(":")) >= 0 && i < url.length() - 1) {
            port = Integer.parseInt(url.substring(i + 1));
            url = url.substring(0, i);
        }
        if (url.length() > 0) {
            host = url;
        }
        return new ConsulURL(protocol, host, port, path, group, interfaceId, parameters);
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public String getIp() {
        try {
            return InetAddress.getByName(this.ip).getHostAddress();
        }
        catch (UnknownHostException e) {
            return this.ip;
        }
    }

    public int getPort() {
        return this.port;
    }

    public int getPort(int defaultPort) {
        return this.port <= 0 ? defaultPort : this.port;
    }

    public String getAddress() {
        return this.port <= 0 ? this.host : this.host + ":" + this.port;
    }

    public String getPath() {
        return this.path;
    }

    public ConsulURL setProtocol(String protocol) {
        return new ConsulURL(protocol, this.host, this.port, this.path, this.interfaceId, this.group, this.getParameters());
    }

    public ConsulURL setAddress(String address) {
        String host;
        int i = address.lastIndexOf(58);
        int port = this.port;
        if (i >= 0) {
            host = address.substring(0, i);
            port = Integer.parseInt(address.substring(i + 1));
        } else {
            host = address;
        }
        return new ConsulURL(this.protocol, host, port, this.path, this.interfaceId, this.group, this.getParameters());
    }

    public ConsulURL setPort(int port) {
        return new ConsulURL(this.protocol, this.host, port, this.path, this.interfaceId, this.group, this.getParameters());
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public String getParameter(String key) {
        String value = this.parameters.get(key);
        return value;
    }

    public String getParameter(String key, String defaultValue) {
        String value = this.getParameter(key);
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        return value;
    }

    public String toString() {
        if (this.string != null) {
            return this.string;
        }
        this.string = this.buildString(false, true, new String[0]);
        return this.string;
    }

    public String toString(String ... parameters) {
        return this.buildString(false, true, parameters);
    }

    public String toFullString() {
        if (this.full != null) {
            return this.full;
        }
        this.full = this.buildString(true, true, new String[0]);
        return this.full;
    }

    private void buildParameters(StringBuilder buf, boolean concat, String[] parameters) {
        if (this.getParameters() != null && this.getParameters().size() > 0) {
            List<String> includes = parameters == null || parameters.length == 0 ? null : Arrays.asList(parameters);
            boolean first = true;
            for (Map.Entry<String, String> entry : new TreeMap<String, String>(this.getParameters()).entrySet()) {
                if (entry.getKey() == null || entry.getKey().length() <= 0 || includes != null && !includes.contains(entry.getKey())) continue;
                if (first) {
                    if (concat) {
                        buf.append("?");
                    }
                    first = false;
                } else {
                    buf.append("&");
                }
                buf.append(entry.getKey());
                buf.append("=");
                buf.append(entry.getValue() == null ? "" : entry.getValue().trim());
            }
        }
    }

    private String buildString(boolean appendUser, boolean appendParameter, String ... parameters) {
        return this.buildString(appendUser, appendParameter, false, false, parameters);
    }

    private String buildString(boolean appendUser, boolean appendParameter, boolean useIP, boolean useService, String ... parameters) {
        String path;
        String host;
        StringBuilder buf = new StringBuilder();
        if (this.protocol != null && this.protocol.length() > 0) {
            buf.append(this.protocol);
            buf.append("://");
        }
        if ((host = useIP ? this.getIp() : this.getHost()) != null && host.length() > 0) {
            buf.append(host);
            if (this.port > 0) {
                buf.append(":");
                buf.append(this.port);
            }
        }
        if ((path = useService ? this.getServiceKey() : this.getPath()) != null && path.length() > 0) {
            buf.append("/");
            buf.append(path);
        }
        if (appendParameter) {
            this.buildParameters(buf, true, parameters);
        }
        return buf.toString();
    }

    public String getServiceKey() {
        String inf = this.getServiceInterface();
        if (inf == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        String group = this.getGroup();
        if (group != null && group.length() > 0) {
            buf.append(group).append("/");
        }
        buf.append(inf);
        String version = this.getVersion();
        if (version != null && version.length() > 0) {
            buf.append(":").append(version);
        }
        return buf.toString();
    }

    public String getGroup() {
        return this.getParameter("uniqueId", "_DEFAULT");
    }

    public String getVersion() {
        return this.getParameter("rpcVer", "1.0.0");
    }

    public String getServiceInterface() {
        return this.getParameter(INTERFACE, "");
    }

    public static String encode(String value) {
        if (value == null || value.length() == 0) {
            return "";
        }
        try {
            return URLEncoder.encode(value, UTF8_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static String decode(String value) {
        if (value == null || value.length() == 0) {
            return "";
        }
        try {
            return URLDecoder.decode(value, UTF8_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 31 * result + this.port;
        result = 31 * result + (this.protocol == null ? 0 : this.protocol.hashCode());
        result = 31 * result + (this.getGroup() == null ? 0 : this.getGroup().hashCode());
        result = 31 * result + (this.getVersion() == null ? 0 : this.getVersion().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConsulURL other = (ConsulURL)obj;
        if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
            return false;
        }
        if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
            return false;
        }
        if (this.port != other.port) {
            return false;
        }
        if (this.protocol == null ? other.protocol != null : !this.protocol.equals(other.protocol)) {
            return false;
        }
        if (this.getGroup() == null ? other.getGroup() != null : !this.getGroup().equals(other.getGroup())) {
            return false;
        }
        return !(this.getVersion() == null ? other.getVersion() != null : !this.getVersion().equals(other.getVersion()));
    }
}

