/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.spi.argument;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;

public class LaunchCommand {
    private URL executableArkBizJar;
    private URL[] classpath;
    private String entryClassName;
    private String entryMethodName;
    private String entryMethodDescriptor;
    private String[] launchArgs;
    private Boolean isTestMode;

    public boolean isExecutedByCommandLine() {
        return this.executableArkBizJar != null;
    }

    public URL getExecutableArkBizJar() {
        return this.executableArkBizJar;
    }

    public LaunchCommand setExecutableArkBizJar(URL executableArkBizJar) {
        this.executableArkBizJar = executableArkBizJar;
        return this;
    }

    public URL[] getClasspath() {
        return this.classpath;
    }

    public LaunchCommand setClasspath(URL[] classpath) {
        this.classpath = classpath;
        return this;
    }

    public String getEntryMethodName() {
        return this.entryMethodName;
    }

    public LaunchCommand setEntryMethodName(String entryMethodName) {
        this.entryMethodName = entryMethodName;
        return this;
    }

    public String getEntryClassName() {
        return this.entryClassName;
    }

    public LaunchCommand setEntryClassName(String entryClassName) {
        this.entryClassName = entryClassName;
        return this;
    }

    public String[] getLaunchArgs() {
        return this.launchArgs;
    }

    public LaunchCommand setLaunchArgs(String[] launchArgs) {
        this.launchArgs = launchArgs;
        return this;
    }

    public String getEntryMethodDescriptor() {
        return this.entryMethodDescriptor;
    }

    public LaunchCommand setEntryMethodDescriptor(String entryMethodDescriptor) {
        this.entryMethodDescriptor = entryMethodDescriptor;
        return this;
    }

    public Boolean isTestMode() {
        return this.isTestMode == null ? false : this.isTestMode;
    }

    public LaunchCommand setTestMode(Boolean testMode) {
        this.isTestMode = testMode;
        return this;
    }

    public static LaunchCommand parse(String arkCommand, String[] args) throws MalformedURLException {
        String[] arkArgs;
        LaunchCommand launchCommand = new LaunchCommand();
        String arkJarPrefix = String.format("%s%s=", "-A", "jar");
        String arkClasspathPrefix = String.format("%s%s=", "-A", "classpath");
        String entryClassNamePrefix = String.format("%s%s=", "-B", "className");
        String entryMethodNamePrefix = String.format("%s%s=", "-B", "methodName");
        String entryMethodDescriptorPrefix = String.format("%s%s=", "-B", "methodDescription");
        String testRunMode = String.format("%s%s=%s", "-B", "runMode", "TEST");
        for (String arg : arkArgs = arkCommand.split("&&")) {
            if ((arg = arg.trim()).startsWith(arkJarPrefix)) {
                String fatJarUrl = arg.substring(arkJarPrefix.length());
                launchCommand.setExecutableArkBizJar(new URL(fatJarUrl));
            }
            if (arg.startsWith(entryClassNamePrefix)) {
                String entryClassName = arg.substring(entryClassNamePrefix.length());
                launchCommand.setEntryClassName(entryClassName);
            }
            if (arg.startsWith(entryMethodNamePrefix)) {
                String entryMethodName = arg.substring(entryMethodNamePrefix.length());
                launchCommand.setEntryMethodName(entryMethodName);
            }
            if (arg.startsWith(entryMethodDescriptorPrefix)) {
                String entryMethodDescriptor = arg.substring(entryMethodDescriptorPrefix.length());
                launchCommand.setEntryMethodDescriptor(entryMethodDescriptor);
            }
            if (arg.equals(testRunMode)) {
                launchCommand.setTestMode(true);
            }
            if (!arg.startsWith(arkClasspathPrefix)) continue;
            String classpath = arg.substring(arkClasspathPrefix.length());
            ArrayList<URL> urlList = new ArrayList<URL>();
            for (String url : classpath.split(",")) {
                if (url.isEmpty()) continue;
                urlList.add(new URL(url));
            }
            launchCommand.setClasspath(urlList.toArray(new URL[urlList.size()]));
        }
        launchCommand.setLaunchArgs(args);
        return launchCommand;
    }

    public static String toString(String[] args) {
        StringBuilder sb = new StringBuilder();
        for (String arg : args) {
            sb.append(arg);
        }
        return sb.toString();
    }
}

