/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.container.test;

import com.alipay.sofa.ark.common.util.ClassUtils;
import com.alipay.sofa.ark.common.util.EnvironmentUtils;
import com.alipay.sofa.ark.common.util.StringUtils;
import com.alipay.sofa.ark.container.model.BizModel;
import com.alipay.sofa.ark.container.service.ArkServiceContainerHolder;
import com.alipay.sofa.ark.container.service.classloader.BizClassLoader;
import com.alipay.sofa.ark.exception.ArkLoaderException;
import com.alipay.sofa.ark.exception.ArkRuntimeException;
import com.alipay.sofa.ark.spi.model.Biz;
import com.alipay.sofa.ark.spi.model.BizState;
import com.alipay.sofa.ark.spi.service.biz.BizManagerService;
import java.net.URL;
import java.util.Arrays;
import java.util.List;

public class TestClassLoader
extends BizClassLoader {
    private final ClassLoader delegateClassLoader;
    private static String[] packageForTest = new String[]{"org.junit", "junit", "org.hamcrest", "org.testng", "com.beust.jcommander", "bsh", "org.mockito", "com.alipay.sofa.ark.support.common", "org.apache.catalina", "org.apache.coyote", "org.apache.juli", "org.apache.naming", "org.apache.tomcat", "org.apache.el", "javax"};
    private List<String> delegateClassToAppClassLoader;
    private List<String> delegateClassToTestClassLoader;

    public TestClassLoader(String bizIdentity, URL[] urls, ClassLoader delegate) {
        super(bizIdentity, urls, true);
        this.delegateClassLoader = delegate;
        BizManagerService bizManagerService = ArkServiceContainerHolder.getContainer().getService(BizManagerService.class);
        Biz testBiz = this.createTestBiz(bizIdentity);
        bizManagerService.registerBiz(testBiz);
        ((BizModel)testBiz).setBizState(BizState.ACTIVATED);
    }

    @Override
    protected Class<?> loadClassInternal(String name, boolean resolve) throws ArkLoaderException {
        if (this.isDelegateToAppClassLoader(ClassUtils.getPackageName((String)name))) {
            try {
                return this.delegateClassLoader.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                throw new ArkLoaderException(String.format("[TestClass Loader] %s : can not load class: %s", this.getBizIdentity(), name));
            }
        }
        return super.loadClassInternal(name, resolve);
    }

    private boolean isDelegateToAppClassLoader(String name) {
        String classes;
        if (this.delegateClassToAppClassLoader == null) {
            classes = EnvironmentUtils.getProperty((String)"com.alipay.sofa.ark.delegate.to.appClassLoader", (String)"");
            this.delegateClassToAppClassLoader = Arrays.asList(classes.split(","));
        }
        if (this.delegateClassToTestClassLoader == null) {
            classes = EnvironmentUtils.getProperty((String)"com.alipay.sofa.ark.delegate.to.testClassLoader", (String)"");
            this.delegateClassToTestClassLoader = Arrays.asList(classes.split(","));
        }
        for (String pkg : this.delegateClassToAppClassLoader) {
            if (StringUtils.isEmpty((String)pkg) || !name.startsWith(pkg)) continue;
            return true;
        }
        for (String pkg : this.delegateClassToTestClassLoader) {
            if (StringUtils.isEmpty((String)pkg) || !name.startsWith(pkg)) continue;
            return false;
        }
        for (String pkg : packageForTest) {
            if (!name.startsWith(pkg)) continue;
            return true;
        }
        return false;
    }

    private Biz createTestBiz(String bizIdentity) {
        String[] bizNameAndVersion = bizIdentity.split(":");
        if (bizNameAndVersion.length != 2) {
            throw new ArkRuntimeException("error bizIdentity format.");
        }
        BizManagerService bizManagerService = ArkServiceContainerHolder.getContainer().getService(BizManagerService.class);
        BizModel testBiz = new BizModel().setBizName(bizNameAndVersion[0]).setBizVersion(bizNameAndVersion[1]).setClassLoader(this).setDenyImportPackages("").setDenyImportClasses("").setDenyImportResources("").setBizState(BizState.RESOLVED);
        bizManagerService.registerBiz((Biz)testBiz);
        return testBiz;
    }
}

