/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.container.session;

import com.alipay.sofa.ark.common.log.ArkLogger;
import com.alipay.sofa.ark.common.log.ArkLoggerFactory;
import com.alipay.sofa.ark.common.thread.CommonThreadPool;
import com.alipay.sofa.ark.common.thread.ThreadPoolManager;
import com.alipay.sofa.ark.common.util.AssertUtils;
import com.alipay.sofa.ark.common.util.EnvironmentUtils;
import com.alipay.sofa.ark.common.util.PortSelectUtils;
import com.alipay.sofa.ark.common.util.StringUtils;
import com.alipay.sofa.ark.container.session.NettyTelnetServer;
import com.alipay.sofa.ark.exception.ArkRuntimeException;
import com.alipay.sofa.ark.spi.service.session.TelnetServerService;
import com.google.inject.Singleton;
import java.util.concurrent.atomic.AtomicBoolean;

@Singleton
public class StandardTelnetServerImpl
implements TelnetServerService {
    private static final ArkLogger LOGGER = ArkLoggerFactory.getDefaultLogger();
    private static final int WORKER_THREAD_POOL_SIZE = 2;
    private int port = -1;
    private AtomicBoolean shutdown = new AtomicBoolean(false);
    private boolean enableTelnetServer = EnvironmentUtils.getProperty((String)"sofa.ark.telnet.server.enable", (String)"true").equalsIgnoreCase("true");
    private NettyTelnetServer nettyTelnetServer;

    public StandardTelnetServerImpl() {
        if (this.enableTelnetServer) {
            String telnetPort = EnvironmentUtils.getProperty((String)"sofa.ark.telnet.port");
            try {
                this.port = !StringUtils.isEmpty((String)telnetPort) ? Integer.parseInt(telnetPort) : PortSelectUtils.selectAvailablePort((int)1234, (int)100);
            }
            catch (NumberFormatException e) {
                LOGGER.error(String.format("Invalid port in %s", telnetPort), (Throwable)e);
                throw new ArkRuntimeException((Throwable)e);
            }
        }
    }

    public void run() {
        AssertUtils.isTrue((this.port > 0 ? 1 : 0) != 0, (String)"Telnet port should be positive integer.", (Object[])new Object[0]);
        try {
            LOGGER.info("Listening on port: " + this.port);
            CommonThreadPool workerPool = new CommonThreadPool().setCorePoolSize(2).setDaemon(true).setThreadPoolName("telnet-server-worker");
            ThreadPoolManager.registerThreadPool((String)"telnet-server-worker", (CommonThreadPool)workerPool);
            this.nettyTelnetServer = new NettyTelnetServer(this.port, workerPool.getExecutor());
            this.nettyTelnetServer.open();
        }
        catch (InterruptedException e) {
            LOGGER.error("Unable to open netty telnet server.", (Throwable)e);
            throw new ArkRuntimeException((Throwable)e);
        }
    }

    public void shutdown() {
        if (this.shutdown.compareAndSet(false, true)) {
            try {
                if (this.nettyTelnetServer != null) {
                    this.nettyTelnetServer.close();
                    this.nettyTelnetServer = null;
                }
            }
            catch (Throwable t) {
                LOGGER.error("An error occurs when shutdown telnet server.", t);
                throw new ArkRuntimeException(t);
            }
        }
    }

    public void init() throws ArkRuntimeException {
        if (this.enableTelnetServer) {
            this.run();
        } else {
            LOGGER.warn("Telnet server is disabled.");
        }
    }

    public void dispose() throws ArkRuntimeException {
        if (this.enableTelnetServer) {
            this.shutdown();
        }
    }

    public int getPriority() {
        return Integer.MIN_VALUE;
    }
}

