/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.container.service.retrieval;

import com.alipay.sofa.ark.api.ArkClient;
import com.alipay.sofa.ark.common.log.ArkLogger;
import com.alipay.sofa.ark.common.log.ArkLoggerFactory;
import com.alipay.sofa.ark.common.util.EnvironmentUtils;
import com.alipay.sofa.ark.common.util.StringUtils;
import com.alipay.sofa.ark.container.service.classloader.BizClassLoader;
import com.alipay.sofa.ark.container.service.retrieval.ClassInfoMethod;
import com.alipay.sofa.ark.spi.service.session.CommandProvider;
import java.lang.instrument.Instrumentation;
import java.util.HashSet;
import java.util.Set;
import net.bytebuddy.agent.ByteBuddyAgent;

public class InfoQueryCommandProvider
implements CommandProvider {
    private final ArkLogger LOGGER = ArkLoggerFactory.getDefaultLogger();
    private static final String HELP_MESSAGE = "Query Class Info Or Other Info Command Tips:\n  USAGE: plugin [option...] [className/beanName...]\n  SAMPLE: ck -c com.sofa.ark.HelloWorld\n  -h  Shows the help message.\n  -c  Shows the class info.\n";

    public String getHelp() {
        return HELP_MESSAGE;
    }

    public String handleCommand(String command) {
        return new ContainerQueryInfoCommand(command).process();
    }

    public boolean validate(String command) {
        return new ContainerQueryInfoCommand(command).isValidate();
    }

    class ContainerQueryInfoCommand {
        private boolean isValidate;
        private Set<Character> options = new HashSet<Character>();
        private Set<String> parameters = new HashSet<String>();
        private final Instrumentation instrumentation = ByteBuddyAgent.install();

        ContainerQueryInfoCommand(String command) {
            if (StringUtils.isEmpty((String)command)) {
                this.isValidate = false;
                return;
            }
            String[] syntax = command.trim().split("\\s+");
            if (!"ck".equals(syntax[0])) {
                this.isValidate = false;
                return;
            }
            int argumentIndex = syntax.length;
            for (int i = 1; i < syntax.length; ++i) {
                if (!syntax[i].startsWith("-")) {
                    argumentIndex = i;
                    break;
                }
                if (syntax[i].startsWith("-") && syntax[i].length() == 1) {
                    this.isValidate = false;
                    return;
                }
                for (int j = 1; j < syntax[i].length(); ++j) {
                    this.options.add(Character.valueOf(syntax[i].charAt(j)));
                }
            }
            block5: for (Character option : this.options) {
                switch (option.charValue()) {
                    case 'c': 
                    case 'h': {
                        continue block5;
                    }
                }
                this.isValidate = false;
                return;
            }
            if (this.options.isEmpty()) {
                this.isValidate = false;
                return;
            }
            if ((this.options.contains(Character.valueOf('h')) || this.options.contains(Character.valueOf('c'))) && this.options.size() > 1) {
                this.isValidate = false;
                return;
            }
            while (argumentIndex < syntax.length) {
                this.parameters.add(syntax[argumentIndex++]);
            }
            if (this.options.contains(Character.valueOf('h')) && this.parameters.size() > 0) {
                this.isValidate = false;
                return;
            }
            if (!this.options.contains(Character.valueOf('h')) && this.parameters.isEmpty()) {
                this.isValidate = false;
                return;
            }
            if (this.options.contains(Character.valueOf('c')) && this.parameters.size() > 1) {
                this.isValidate = false;
                return;
            }
            this.isValidate = true;
        }

        boolean isValidate() {
            return this.isValidate;
        }

        String process() {
            if (!this.isValidate) {
                return "Error command format. Pls type 'ck -h' to get help message\n";
            }
            if (this.options.contains(Character.valueOf('h'))) {
                return InfoQueryCommandProvider.HELP_MESSAGE;
            }
            if (this.options.contains(Character.valueOf('c'))) {
                return this.queryClass();
            }
            return InfoQueryCommandProvider.HELP_MESSAGE;
        }

        String queryClass() {
            if (EnvironmentUtils.isOpenSecurity()) {
                return "Cannot execute 'ck -c' command in security mode.\n";
            }
            String param = this.parameters.toArray(new String[0])[0];
            HashSet matches = new HashSet();
            for (Class c : this.instrumentation.getAllLoadedClasses()) {
                if (c == null || !param.equals(c.getName())) continue;
                matches.add(c);
            }
            if (matches.isEmpty()) {
                return "Can not find class : " + param;
            }
            return this.createClassInfo(matches).toString();
        }

        StringBuilder createClassInfo(Set<Class<?>> classSet) {
            StringBuilder sb = new StringBuilder();
            for (Class<?> clazz : classSet) {
                String classInfo;
                ClassLoader classLoader = clazz.getClassLoader();
                if (null != ArkClient.getMasterBiz() && classLoader == ArkClient.getMasterBiz().getBizClassLoader()) {
                    classInfo = ClassInfoMethod.createClassInfo(clazz, ArkClient.getMasterBiz().getIdentity());
                    sb.append(classInfo).append("\n");
                    continue;
                }
                if (null != ArkClient.getMasterBiz() && classLoader instanceof BizClassLoader) {
                    classInfo = ClassInfoMethod.createClassInfo(clazz, ((BizClassLoader)classLoader).getBizIdentity());
                    sb.append(classInfo).append("\n");
                    continue;
                }
                classInfo = ClassInfoMethod.createClassInfo(clazz, classLoader.toString());
                sb.append(classInfo).append("\n");
            }
            return sb;
        }
    }
}

