/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.container.service.plugin;

import com.alipay.sofa.ark.common.log.ArkLogger;
import com.alipay.sofa.ark.common.log.ArkLoggerFactory;
import com.alipay.sofa.ark.exception.ArkRuntimeException;
import com.alipay.sofa.ark.spi.model.Plugin;
import com.alipay.sofa.ark.spi.service.plugin.PluginDeployService;
import com.alipay.sofa.ark.spi.service.plugin.PluginManagerService;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collections;
import java.util.List;

@Singleton
public class PluginDeployServiceImpl
implements PluginDeployService {
    private static final ArkLogger LOGGER = ArkLoggerFactory.getDefaultLogger();
    @Inject
    PluginManagerService pluginManagerService;

    public void deploy() throws ArkRuntimeException {
        for (Plugin plugin : this.pluginManagerService.getPluginsInOrder()) {
            try {
                this.deployPlugin(plugin);
            }
            catch (ArkRuntimeException e) {
                LOGGER.error(String.format("Deploy plugin: %s meet error", plugin.getPluginName()), (Throwable)e);
                throw e;
            }
        }
    }

    private void deployPlugin(Plugin plugin) throws ArkRuntimeException {
        try {
            LOGGER.info(String.format("Start to deploy plugin: %s", plugin.getPluginName()));
            plugin.start();
            LOGGER.info(String.format("Finish to deploy plugin: %s", plugin.getPluginName()));
        }
        catch (ArkRuntimeException e) {
            LOGGER.error(String.format("Start plugin: %s meet error", plugin.getPluginName()), (Throwable)e);
            throw e;
        }
    }

    public void unDeploy() throws ArkRuntimeException {
        List pluginsInOrder = this.pluginManagerService.getPluginsInOrder();
        Collections.reverse(pluginsInOrder);
        for (Plugin plugin : pluginsInOrder) {
            try {
                this.unDeployPlugin(plugin);
            }
            catch (ArkRuntimeException e) {
                LOGGER.error(String.format("UnDeploy plugin: %s meet error", plugin.getPluginName()), (Throwable)e);
                throw e;
            }
        }
    }

    private void unDeployPlugin(Plugin plugin) throws ArkRuntimeException {
        try {
            LOGGER.info(String.format("Start to unDeploy plugin: %s", plugin.getPluginName()) + plugin.getPluginName());
            plugin.stop();
            LOGGER.info(String.format("Stop to unDeploy plugin: %s", plugin.getPluginName()) + plugin.getPluginName());
        }
        catch (ArkRuntimeException e) {
            LOGGER.error(String.format("Stop plugin: %s meet error", plugin.getPluginName()), (Throwable)e);
            throw e;
        }
    }

    public void init() throws ArkRuntimeException {
    }

    public void dispose() throws ArkRuntimeException {
        this.unDeploy();
    }

    public int getPriority() {
        return 100;
    }
}

