/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.container.service.event;

import com.alipay.sofa.ark.common.log.ArkLoggerFactory;
import com.alipay.sofa.ark.common.util.OrderComparator;
import com.alipay.sofa.ark.spi.event.ArkEvent;
import com.alipay.sofa.ark.spi.event.biz.BeforeBizRecycleEvent;
import com.alipay.sofa.ark.spi.event.plugin.AfterPluginStopEvent;
import com.alipay.sofa.ark.spi.model.Biz;
import com.alipay.sofa.ark.spi.model.Plugin;
import com.alipay.sofa.ark.spi.registry.ServiceReference;
import com.alipay.sofa.ark.spi.service.event.EventAdminService;
import com.alipay.sofa.ark.spi.service.event.EventHandler;
import com.alipay.sofa.ark.spi.service.registry.RegistryService;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.slf4j.Logger;

@Singleton
public class EventAdminServiceImpl
implements EventAdminService,
EventHandler {
    private static final ConcurrentMap<ClassLoader, CopyOnWriteArraySet<EventHandler>> SUBSCRIBER_MAP = new ConcurrentHashMap<ClassLoader, CopyOnWriteArraySet<EventHandler>>();
    private static final Logger LOGGER = ArkLoggerFactory.getDefaultLogger();
    @Inject
    private RegistryService registryService;

    public EventAdminServiceImpl() {
        this.register(this);
    }

    public void sendEvent(ArkEvent event) {
        ArrayList<Object> eventHandlers = new ArrayList<Object>();
        for (CopyOnWriteArraySet copyOnWriteArraySet : SUBSCRIBER_MAP.values()) {
            eventHandlers.addAll(copyOnWriteArraySet);
        }
        for (ServiceReference serviceReference : this.registryService.referenceServices(EventHandler.class, null)) {
            eventHandlers.add(serviceReference.getService());
        }
        Collections.sort(eventHandlers, new OrderComparator());
        for (EventHandler eventHandler : eventHandlers) {
            if (!this.isSupportEventType(eventHandler, event)) continue;
            eventHandler.handleEvent(event);
        }
    }

    public void register(EventHandler eventHandler) {
        CopyOnWriteArraySet<EventHandler> set = (CopyOnWriteArraySet<EventHandler>)SUBSCRIBER_MAP.get(eventHandler.getClass().getClassLoader());
        if (set == null) {
            set = new CopyOnWriteArraySet<EventHandler>();
            CopyOnWriteArraySet old = SUBSCRIBER_MAP.putIfAbsent(eventHandler.getClass().getClassLoader(), set);
            if (old != null) {
                set = old;
            }
        }
        set.add(eventHandler);
        LOGGER.debug(String.format("Register event handler: %s.", eventHandler));
    }

    public void unRegister(EventHandler eventHandler) {
        CopyOnWriteArraySet set = (CopyOnWriteArraySet)SUBSCRIBER_MAP.get(eventHandler.getClass().getClassLoader());
        if (set != null) {
            set.remove(eventHandler);
            LOGGER.debug(String.format("Unregister event handler: %s.", eventHandler));
        }
    }

    public void unRegister(ClassLoader classLoader) {
        SUBSCRIBER_MAP.remove(classLoader);
        LOGGER.debug(String.format("Unregister event handler of classLoader: %s.", classLoader));
    }

    public void handleEvent(ArkEvent event) {
        ClassLoader classLoader = null;
        if (event instanceof BeforeBizRecycleEvent) {
            classLoader = ((Biz)((BeforeBizRecycleEvent)event).getSource()).getBizClassLoader();
        } else if (event instanceof AfterPluginStopEvent) {
            classLoader = ((Plugin)((AfterPluginStopEvent)event).getSource()).getPluginClassLoader();
        }
        if (classLoader != null) {
            this.unRegister(classLoader);
        }
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    private boolean isSupportEventType(EventHandler eventHandler, ArkEvent event) {
        boolean isSupport;
        block5: {
            isSupport = false;
            try {
                Class<?> aClass = eventHandler.getClass();
                Type[] types = aClass.getGenericInterfaces();
                if (types == null) break block5;
                for (Type type : types) {
                    if (!this.checkEventHandlerType(type)) continue;
                    if (type instanceof ParameterizedType) {
                        Type[] actualTypeArguments = ((ParameterizedType)type).getActualTypeArguments();
                        if (actualTypeArguments.length != 1 || !Class.forName(actualTypeArguments[0].getTypeName()).isAssignableFrom(event.getClass())) continue;
                        isSupport = true;
                    } else {
                        if (!ArkEvent.class.isAssignableFrom(event.getClass())) continue;
                        isSupport = true;
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return isSupport;
    }

    private boolean checkEventHandlerType(Type type) {
        if (type.getTypeName().equals(EventHandler.class.getTypeName())) {
            return true;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return parameterizedType.getRawType().getTypeName().equals(EventHandler.class.getTypeName());
        }
        return false;
    }
}

