/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.container.service.classloader;

import com.alipay.sofa.ark.bootstrap.AgentClassLoader;
import com.alipay.sofa.ark.common.log.ArkLogger;
import com.alipay.sofa.ark.common.log.ArkLoggerFactory;
import com.alipay.sofa.ark.common.util.AssertUtils;
import com.alipay.sofa.ark.common.util.ClassLoaderUtils;
import com.alipay.sofa.ark.common.util.ClassUtils;
import com.alipay.sofa.ark.container.service.classloader.JDKDelegateClassLoader;
import com.alipay.sofa.ark.exception.ArkRuntimeException;
import com.alipay.sofa.ark.spi.model.Biz;
import com.alipay.sofa.ark.spi.model.Plugin;
import com.alipay.sofa.ark.spi.service.biz.BizManagerService;
import com.alipay.sofa.ark.spi.service.classloader.ClassLoaderService;
import com.alipay.sofa.ark.spi.service.plugin.PluginManagerService;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

@Singleton
public class ClassLoaderServiceImpl
implements ClassLoaderService {
    private static final ArkLogger LOGGER = ArkLoggerFactory.getDefaultLogger();
    private static final String ARK_SPI_PACKAGES = "com.alipay.sofa.ark.spi";
    private static final String ARK_API_PACKAGES = "com.alipay.sofa.ark.api";
    private static final String ARK_LOG_PACKAGES = "com.alipay.sofa.ark.common.log";
    private static final String ARK_EXCEPTION_PACKAGES = "com.alipay.sofa.ark.exception";
    private static final List<String> SUN_REFLECT_GENERATED_ACCESSOR = new ArrayList<String>();
    private ConcurrentHashMap<String, ClassLoader> exportClassAndClassLoaderMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, ClassLoader> exportNodeAndClassLoaderMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, ClassLoader> exportStemAndClassLoaderMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, List<ClassLoader>> exportResourceAndClassLoaderMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, List<ClassLoader>> exportPrefixStemResourceAndClassLoaderMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, List<ClassLoader>> exportSuffixStemResourceAndClassLoaderMap = new ConcurrentHashMap();
    private ClassLoader jdkClassLoader;
    private ClassLoader arkClassLoader;
    private ClassLoader systemClassLoader;
    private ClassLoader agentClassLoader;
    @Inject
    private PluginManagerService pluginManagerService;
    @Inject
    private BizManagerService bizManagerService;

    public boolean isSunReflectClass(String className) {
        for (String sunAccessor : SUN_REFLECT_GENERATED_ACCESSOR) {
            if (!className.startsWith(sunAccessor)) continue;
            return true;
        }
        return false;
    }

    public boolean isArkSpiClass(String className) {
        return className.startsWith(ARK_SPI_PACKAGES);
    }

    public boolean isArkApiClass(String className) {
        return className.startsWith(ARK_API_PACKAGES);
    }

    public boolean isArkLogClass(String className) {
        return className.startsWith(ARK_LOG_PACKAGES);
    }

    public boolean isArkExceptionClass(String className) {
        return className.startsWith(ARK_EXCEPTION_PACKAGES);
    }

    public void prepareExportClassAndResourceCache() {
        for (Plugin plugin : this.pluginManagerService.getPluginsInOrder()) {
            for (String exportIndex : plugin.getExportPackageNodes()) {
                this.exportNodeAndClassLoaderMap.putIfAbsent(exportIndex, plugin.getPluginClassLoader());
            }
            for (String exportIndex : plugin.getExportPackageStems()) {
                this.exportStemAndClassLoaderMap.putIfAbsent(exportIndex, plugin.getPluginClassLoader());
            }
            for (String exportIndex : plugin.getExportClasses()) {
                this.exportClassAndClassLoaderMap.putIfAbsent(exportIndex, plugin.getPluginClassLoader());
            }
            for (String resource : plugin.getExportResources()) {
                this.exportResourceAndClassLoaderMap.putIfAbsent(resource, new LinkedList());
                this.exportResourceAndClassLoaderMap.get(resource).add(plugin.getPluginClassLoader());
            }
            for (String resource : plugin.getExportPrefixResourceStems()) {
                this.exportPrefixStemResourceAndClassLoaderMap.putIfAbsent(resource, new LinkedList());
                this.exportPrefixStemResourceAndClassLoaderMap.get(resource).add(plugin.getPluginClassLoader());
            }
            for (String resource : plugin.getExportSuffixResourceStems()) {
                this.exportSuffixStemResourceAndClassLoaderMap.putIfAbsent(resource, new LinkedList());
                this.exportSuffixStemResourceAndClassLoaderMap.get(resource).add(plugin.getPluginClassLoader());
            }
        }
    }

    public boolean isClassInImport(String pluginName, String className) {
        Plugin plugin = this.pluginManagerService.getPluginByName(pluginName);
        AssertUtils.assertNotNull((Object)plugin, (String)("plugin: " + pluginName + " is null"));
        for (String importName : plugin.getImportClasses()) {
            if (!className.equals(importName)) continue;
            return true;
        }
        String pkg = ClassUtils.getPackageName((String)className);
        for (String pattern : plugin.getImportPackageNodes()) {
            if (!pkg.equals(pattern)) continue;
            return true;
        }
        for (String pattern : plugin.getImportPackageStems()) {
            if (!pkg.startsWith(pattern)) continue;
            return true;
        }
        return false;
    }

    public ClassLoader findExportClassLoader(String className) {
        ClassLoader exportClassLoader = this.exportClassAndClassLoaderMap.get(className);
        String packageName = ClassUtils.getPackageName((String)className);
        if (exportClassLoader == null) {
            exportClassLoader = this.exportNodeAndClassLoaderMap.get(packageName);
        }
        while (!".".equals(packageName) && exportClassLoader == null) {
            exportClassLoader = this.exportStemAndClassLoaderMap.get(packageName);
            packageName = ClassUtils.getPackageName((String)packageName);
        }
        return exportClassLoader;
    }

    public boolean isResourceInImport(String pluginName, String resourceName) {
        Plugin plugin = this.pluginManagerService.getPluginByName(pluginName);
        AssertUtils.assertNotNull((Object)plugin, (String)("plugin: " + pluginName + " is null"));
        for (String importResource : plugin.getImportResources()) {
            if (!importResource.equals(resourceName)) continue;
            return true;
        }
        for (String importResource : plugin.getImportPrefixResourceStems()) {
            if (!resourceName.startsWith(importResource)) continue;
            return true;
        }
        for (String importResource : plugin.getImportSuffixResourceStems()) {
            if (!resourceName.endsWith(importResource)) continue;
            return true;
        }
        return false;
    }

    public List<ClassLoader> findExportResourceClassLoadersInOrder(String resourceName) {
        if (this.exportResourceAndClassLoaderMap.containsKey(resourceName)) {
            return this.exportResourceAndClassLoaderMap.get(resourceName);
        }
        for (String stemResource : this.exportPrefixStemResourceAndClassLoaderMap.keySet()) {
            if (!resourceName.startsWith(stemResource)) continue;
            return this.exportPrefixStemResourceAndClassLoaderMap.get(stemResource);
        }
        for (String stemResource : this.exportSuffixStemResourceAndClassLoaderMap.keySet()) {
            if (!resourceName.endsWith(stemResource)) continue;
            return this.exportSuffixStemResourceAndClassLoaderMap.get(stemResource);
        }
        return null;
    }

    public ClassLoader getJDKClassLoader() {
        return this.jdkClassLoader;
    }

    public ClassLoader getArkClassLoader() {
        return this.arkClassLoader;
    }

    public ClassLoader getSystemClassLoader() {
        return this.systemClassLoader;
    }

    public ClassLoader getAgentClassLoader() {
        return this.agentClassLoader;
    }

    public ClassLoader getBizClassLoader(String bizIdentity) {
        Biz biz = this.bizManagerService.getBizByIdentity(bizIdentity);
        return biz == null ? null : biz.getBizClassLoader();
    }

    public ClassLoader getPluginClassLoader(String pluginName) {
        Plugin plugin = this.pluginManagerService.getPluginByName(pluginName);
        return plugin == null ? null : plugin.getPluginClassLoader();
    }

    public void init() throws ArkRuntimeException {
        this.arkClassLoader = this.getClass().getClassLoader();
        this.systemClassLoader = ClassLoader.getSystemClassLoader();
        this.agentClassLoader = this.createAgentClassLoader();
        ClassLoader extClassLoader = this.systemClassLoader;
        while (extClassLoader.getParent() != null) {
            extClassLoader = extClassLoader.getParent();
        }
        ArrayList<URL> jdkUrls = new ArrayList<URL>();
        try {
            URL[] urls;
            String javaHome = System.getProperty("java.home").replace(File.separator + "jre", "");
            for (URL url : urls = ClassLoaderUtils.getURLs((ClassLoader)this.systemClassLoader)) {
                if (!url.getPath().startsWith(javaHome)) continue;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("Find JDK Url: %s", url));
                }
                jdkUrls.add(url);
            }
        }
        catch (Throwable e) {
            LOGGER.warn("Meet exception when parse JDK urls", e);
        }
        this.jdkClassLoader = new JDKDelegateClassLoader(jdkUrls.toArray(new URL[0]), extClassLoader);
    }

    public void dispose() throws ArkRuntimeException {
    }

    private ClassLoader createAgentClassLoader() throws ArkRuntimeException {
        return new AgentClassLoader(ClassLoaderUtils.getAgentClassPath(), null);
    }

    public boolean isDeniedImportClass(String bizIdentity, String className) {
        Biz biz = this.bizManagerService.getBizByIdentity(bizIdentity);
        if (biz == null) {
            return false;
        }
        for (String pattern : biz.getDenyImportClasses()) {
            if (!pattern.equals(className)) continue;
            return true;
        }
        String pkg = ClassUtils.getPackageName((String)className);
        for (String pattern : biz.getDenyImportPackageNodes()) {
            if (!pkg.equals(pattern)) continue;
            return true;
        }
        for (String pattern : biz.getDenyImportPackageStems()) {
            if (!pkg.startsWith(pattern)) continue;
            return true;
        }
        return false;
    }

    public boolean isDeniedImportResource(String bizIdentity, String resourceName) {
        Biz biz = this.bizManagerService.getBizByIdentity(bizIdentity);
        if (biz == null) {
            return false;
        }
        for (String resource : biz.getDenyImportResources()) {
            if (!resource.equals(resourceName)) continue;
            return true;
        }
        for (String resource : biz.getDenyPrefixImportResourceStems()) {
            if (!resourceName.startsWith(resource)) continue;
            return true;
        }
        for (String resource : biz.getDenySuffixImportResourceStems()) {
            if (!resourceName.endsWith(resource)) continue;
            return true;
        }
        return false;
    }

    public int getPriority() {
        return 100;
    }

    static {
        SUN_REFLECT_GENERATED_ACCESSOR.add("sun.reflect.GeneratedMethodAccessor");
        SUN_REFLECT_GENERATED_ACCESSOR.add("sun.reflect.GeneratedConstructorAccessor");
        SUN_REFLECT_GENERATED_ACCESSOR.add("sun.reflect.GeneratedSerializationConstructorAccessor");
    }
}

