/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.container.service.biz;

import com.alipay.sofa.ark.api.ArkConfigs;
import com.alipay.sofa.ark.common.util.AssertUtils;
import com.alipay.sofa.ark.common.util.ClassLoaderUtils;
import com.alipay.sofa.ark.common.util.FileUtils;
import com.alipay.sofa.ark.common.util.StringUtils;
import com.alipay.sofa.ark.container.model.BizModel;
import com.alipay.sofa.ark.container.service.classloader.BizClassLoader;
import com.alipay.sofa.ark.loader.DirectoryBizArchive;
import com.alipay.sofa.ark.loader.ExplodedBizArchive;
import com.alipay.sofa.ark.loader.JarBizArchive;
import com.alipay.sofa.ark.loader.archive.JarFileArchive;
import com.alipay.sofa.ark.loader.jar.JarFile;
import com.alipay.sofa.ark.spi.archive.Archive;
import com.alipay.sofa.ark.spi.archive.BizArchive;
import com.alipay.sofa.ark.spi.model.Biz;
import com.alipay.sofa.ark.spi.model.BizOperation;
import com.alipay.sofa.ark.spi.model.BizState;
import com.alipay.sofa.ark.spi.model.Plugin;
import com.alipay.sofa.ark.spi.service.biz.BizFactoryService;
import com.alipay.sofa.ark.spi.service.plugin.PluginManagerService;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.Attributes;

@Singleton
public class BizFactoryServiceImpl
implements BizFactoryService {
    @Inject
    private PluginManagerService pluginManagerService;

    public Biz createBiz(BizArchive bizArchive) throws IOException {
        AssertUtils.isTrue((boolean)this.isArkBiz(bizArchive), (String)"Archive must be a ark biz!", (Object[])new Object[0]);
        BizModel bizModel = new BizModel();
        Attributes manifestMainAttributes = bizArchive.getManifest().getMainAttributes();
        bizModel.setBizState(BizState.RESOLVED).setBizName(manifestMainAttributes.getValue("Ark-Biz-Name")).setBizVersion(manifestMainAttributes.getValue("Ark-Biz-Version")).setMainClass(manifestMainAttributes.getValue("Main-Class")).setPriority(manifestMainAttributes.getValue("priority")).setWebContextPath(manifestMainAttributes.getValue("web-context-path")).setDenyImportPackages(manifestMainAttributes.getValue("deny-import-packages")).setDenyImportClasses(manifestMainAttributes.getValue("deny-import-classes")).setDenyImportResources(manifestMainAttributes.getValue("deny-import-resources")).setInjectPluginDependencies(this.getInjectDependencies(manifestMainAttributes.getValue("inject-plugin-dependencies"))).setInjectExportPackages(manifestMainAttributes.getValue("inject-export-packages")).setDeclaredLibraries(manifestMainAttributes.getValue("declared-libraries")).setClassPath(bizArchive.getUrls()).setPluginClassPath(this.getPluginURLs());
        BizClassLoader bizClassLoader = new BizClassLoader(bizModel.getIdentity(), this.getBizUcp(bizModel.getClassPath()), bizArchive instanceof ExplodedBizArchive || bizArchive instanceof DirectoryBizArchive);
        bizClassLoader.setBizModel(bizModel);
        bizModel.setClassLoader(bizClassLoader);
        return bizModel;
    }

    public Biz createBiz(File file) throws IOException {
        JarBizArchive bizArchive;
        if (ArkConfigs.isEmbedEnable()) {
            File unpackFile = new File(file.getAbsolutePath() + "-unpack");
            if (!unpackFile.exists()) {
                unpackFile = FileUtils.unzip((File)file, (String)(file.getAbsolutePath() + "-unpack"));
            }
            if (file.exists()) {
                file.delete();
            }
            file = unpackFile;
            bizArchive = new ExplodedBizArchive(unpackFile);
        } else {
            JarFile bizFile = new JarFile(file);
            JarFileArchive jarFileArchive = new JarFileArchive(bizFile);
            bizArchive = new JarBizArchive((Archive)jarFileArchive);
        }
        BizModel biz = (BizModel)this.createBiz((BizArchive)bizArchive);
        biz.setBizTempWorkDir(file);
        return biz;
    }

    public Biz createBiz(BizOperation bizOperation, File file) throws IOException {
        BizModel biz = (BizModel)this.createBiz(file);
        if (bizOperation != null && !StringUtils.isEmpty((String)bizOperation.getBizVersion())) {
            biz.setBizVersion(bizOperation.getBizVersion());
            if (biz.getBizClassLoader() instanceof BizClassLoader) {
                BizClassLoader bizClassLoader = (BizClassLoader)biz.getBizClassLoader();
                bizClassLoader.setBizIdentity(biz.getIdentity());
            }
        }
        return biz;
    }

    public Biz createEmbedMasterBiz(ClassLoader masterClassLoader) {
        BizModel bizModel = new BizModel();
        bizModel.setBizState(BizState.RESOLVED).setBizName(ArkConfigs.getStringValue((String)"com.alipay.sofa.ark.master.biz")).setBizVersion("1.0.0").setMainClass("embed main").setPriority("100").setWebContextPath("/").setDenyImportPackages(null).setDenyImportClasses(null).setDenyImportResources(null).setInjectPluginDependencies(new HashSet<String>()).setInjectExportPackages(null).setClassPath(ClassLoaderUtils.getURLs((ClassLoader)masterClassLoader)).setClassLoader(masterClassLoader);
        return bizModel;
    }

    private Set<String> getInjectDependencies(String injectPluginDependencies) {
        HashSet<String> dependencies = new HashSet<String>();
        if (StringUtils.strToSet((String)injectPluginDependencies, (String)",") != null) {
            dependencies.addAll(StringUtils.strToSet((String)injectPluginDependencies, (String)","));
        }
        return dependencies;
    }

    private boolean isArkBiz(BizArchive bizArchive) {
        if (ArkConfigs.isEmbedEnable() && bizArchive instanceof ExplodedBizArchive) {
            return true;
        }
        return bizArchive.isEntryExist(new Archive.EntryFilter(){

            public boolean matches(Archive.Entry entry) {
                return !entry.isDirectory() && entry.getName().equals("com/alipay/sofa/ark/biz/mark");
            }
        });
    }

    private URL[] getBizUcp(URL[] bizClassPath) {
        ArrayList<URL> bizUcp = new ArrayList<URL>();
        bizUcp.addAll(Arrays.asList(bizClassPath));
        bizUcp.addAll(Arrays.asList(this.getPluginURLs()));
        return bizUcp.toArray(new URL[bizUcp.size()]);
    }

    private URL[] getPluginURLs() {
        ArrayList<URL> pluginUrls = new ArrayList<URL>();
        for (Plugin plugin : this.pluginManagerService.getPluginsInOrder()) {
            pluginUrls.add(plugin.getPluginURL());
        }
        return pluginUrls.toArray(new URL[pluginUrls.size()]);
    }
}

