/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.container.service.biz;

import com.alipay.sofa.ark.common.log.ArkLogger;
import com.alipay.sofa.ark.common.log.ArkLoggerFactory;
import com.alipay.sofa.ark.exception.ArkRuntimeException;
import com.alipay.sofa.ark.spi.registry.ServiceReference;
import com.alipay.sofa.ark.spi.service.biz.BizDeployService;
import com.alipay.sofa.ark.spi.service.biz.BizDeployer;
import com.alipay.sofa.ark.spi.service.registry.RegistryService;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class BizDeployServiceImpl
implements BizDeployService {
    private static final ArkLogger LOGGER = ArkLoggerFactory.getDefaultLogger();
    @Inject
    private RegistryService registryService;
    private BizDeployer bizDeployer;

    public void deploy(String[] args) throws ArkRuntimeException {
        ServiceReference serviceReference = this.registryService.referenceService(BizDeployer.class);
        this.bizDeployer = (BizDeployer)serviceReference.getService();
        LOGGER.info(String.format("BizDeployer='%s' is starting.", this.bizDeployer.getDesc()));
        this.bizDeployer.init(args);
        this.bizDeployer.deploy();
    }

    public void unDeploy() throws ArkRuntimeException {
        if (this.bizDeployer != null) {
            LOGGER.info(String.format("BizDeployer='%s' is stopping.", this.bizDeployer.getDesc()));
            this.bizDeployer.unDeploy();
        }
    }

    public void init() throws ArkRuntimeException {
    }

    public void dispose() throws ArkRuntimeException {
        this.unDeploy();
    }

    public int getPriority() {
        return 100;
    }
}

