/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.container.service;

import com.alipay.sofa.ark.api.ArkClient;
import com.alipay.sofa.ark.common.guice.AbstractArkGuiceModule;
import com.alipay.sofa.ark.common.log.ArkLogger;
import com.alipay.sofa.ark.common.log.ArkLoggerFactory;
import com.alipay.sofa.ark.common.util.ClassLoaderUtils;
import com.alipay.sofa.ark.common.util.OrderComparator;
import com.alipay.sofa.ark.container.service.ArkServiceContainerHolder;
import com.alipay.sofa.ark.exception.ArkRuntimeException;
import com.alipay.sofa.ark.spi.service.ArkService;
import com.alipay.sofa.ark.spi.service.biz.BizFactoryService;
import com.alipay.sofa.ark.spi.service.biz.BizManagerService;
import com.alipay.sofa.ark.spi.service.event.EventAdminService;
import com.alipay.sofa.ark.spi.service.injection.InjectionService;
import com.alipay.sofa.ark.spi.service.plugin.PluginManagerService;
import com.google.inject.Binding;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.TypeLiteral;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicBoolean;

public class ArkServiceContainer {
    private Injector injector;
    private List<ArkService> arkServiceList = new ArrayList<ArkService>();
    private AtomicBoolean started = new AtomicBoolean(false);
    private AtomicBoolean stopped = new AtomicBoolean(false);
    private final String[] arguments;
    private static final ArkLogger LOGGER = ArkLoggerFactory.getDefaultLogger();

    public ArkServiceContainer(String[] arguments) {
        this.arguments = arguments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws ArkRuntimeException {
        if (this.started.compareAndSet(false, true)) {
            ClassLoader oldClassLoader = ClassLoaderUtils.pushContextClassLoader((ClassLoader)this.getClass().getClassLoader());
            try {
                LOGGER.info("Begin to start ArkServiceContainer");
                this.injector = Guice.createInjector(this.findServiceModules());
                for (Binding binding : this.injector.findBindingsByType((TypeLiteral)new TypeLiteral<ArkService>(){})) {
                    this.arkServiceList.add((ArkService)binding.getProvider().get());
                }
                Collections.sort(this.arkServiceList, new OrderComparator());
                for (ArkService arkService : this.arkServiceList) {
                    LOGGER.info(String.format("Init Service: %s", arkService.getClass().getName()));
                    arkService.init();
                }
                ArkServiceContainerHolder.setContainer(this);
                ArkClient.setBizFactoryService((BizFactoryService)this.getService(BizFactoryService.class));
                ArkClient.setBizManagerService((BizManagerService)this.getService(BizManagerService.class));
                ArkClient.setInjectionService((InjectionService)this.getService(InjectionService.class));
                ArkClient.setEventAdminService((EventAdminService)this.getService(EventAdminService.class));
                ArkClient.setPluginManagerService((PluginManagerService)this.getService(PluginManagerService.class));
                ArkClient.setArguments((String[])this.arguments);
                LOGGER.info("Finish to start ArkServiceContainer");
            }
            finally {
                ClassLoaderUtils.popContextClassLoader((ClassLoader)oldClassLoader);
            }
        }
    }

    private List<AbstractArkGuiceModule> findServiceModules() throws ArkRuntimeException {
        try {
            ArrayList<AbstractArkGuiceModule> modules = new ArrayList<AbstractArkGuiceModule>();
            for (AbstractArkGuiceModule module : ServiceLoader.load(AbstractArkGuiceModule.class)) {
                modules.add(module);
            }
            return modules;
        }
        catch (Throwable e) {
            throw new ArkRuntimeException(e);
        }
    }

    public <T> T getService(Class<T> clazz) {
        return (T)this.injector.getInstance(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws ArkRuntimeException {
        if (this.stopped.compareAndSet(false, true)) {
            LOGGER.info("Begin to stop ArkServiceContainer");
            ClassLoader oldClassLoader = ClassLoaderUtils.pushContextClassLoader((ClassLoader)this.getClass().getClassLoader());
            try {
                Collections.reverse(this.arkServiceList);
                for (ArkService arkService : this.arkServiceList) {
                    LOGGER.info(String.format("Dispose service: %s", arkService.getClass().getName()));
                    arkService.dispose();
                }
                LOGGER.info("Finish to stop ArkServiceContainer");
            }
            finally {
                ClassLoaderUtils.popContextClassLoader((ClassLoader)oldClassLoader);
            }
        }
    }

    public boolean isStarted() {
        return this.started.get();
    }

    public boolean isRunning() {
        return this.isStarted() && !this.stopped.get();
    }
}

