/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.container.pipeline;

import com.alipay.sofa.ark.api.ArkClient;
import com.alipay.sofa.ark.api.ArkConfigs;
import com.alipay.sofa.ark.common.log.ArkLogger;
import com.alipay.sofa.ark.common.log.ArkLoggerFactory;
import com.alipay.sofa.ark.common.util.AssertUtils;
import com.alipay.sofa.ark.common.util.StringUtils;
import com.alipay.sofa.ark.exception.ArkRuntimeException;
import com.alipay.sofa.ark.loader.DirectoryBizArchive;
import com.alipay.sofa.ark.loader.JarBizArchive;
import com.alipay.sofa.ark.spi.archive.BizArchive;
import com.alipay.sofa.ark.spi.archive.ExecutableArchive;
import com.alipay.sofa.ark.spi.archive.PluginArchive;
import com.alipay.sofa.ark.spi.model.Biz;
import com.alipay.sofa.ark.spi.model.Plugin;
import com.alipay.sofa.ark.spi.pipeline.PipelineContext;
import com.alipay.sofa.ark.spi.pipeline.PipelineStage;
import com.alipay.sofa.ark.spi.service.biz.BizFactoryService;
import com.alipay.sofa.ark.spi.service.biz.BizManagerService;
import com.alipay.sofa.ark.spi.service.plugin.PluginFactoryService;
import com.alipay.sofa.ark.spi.service.plugin.PluginManagerService;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.Attributes;

@Singleton
public class HandleArchiveStage
implements PipelineStage {
    private static final ArkLogger LOGGER = ArkLoggerFactory.getDefaultLogger();
    @Inject
    private PluginManagerService pluginManagerService;
    @Inject
    private PluginFactoryService pluginFactoryService;
    @Inject
    private BizManagerService bizManagerService;
    @Inject
    private BizFactoryService bizFactoryService;

    public void process(PipelineContext pipelineContext) throws ArkRuntimeException {
        try {
            if (ArkConfigs.isEmbedEnable()) {
                this.processEmbed(pipelineContext);
                return;
            }
            ExecutableArchive executableArchive = pipelineContext.getExecutableArchive();
            List bizArchives = executableArchive.getBizArchives();
            List pluginArchives = executableArchive.getPluginArchives();
            if (this.useDynamicConfig()) {
                AssertUtils.isFalse((boolean)StringUtils.isEmpty((String)ArkConfigs.getStringValue((String)"com.alipay.sofa.ark.master.biz")), (String)"Master biz should be configured when using dynamic config.", (Object[])new Object[0]);
            }
            int bizCount = 0;
            for (Object bizArchive : bizArchives) {
                Biz biz = this.bizFactoryService.createBiz((BizArchive)bizArchive);
                if (bizArchive instanceof DirectoryBizArchive) {
                    if (((DirectoryBizArchive)bizArchive).isTestMode()) continue;
                    this.bizManagerService.registerBiz(biz);
                    ++bizCount;
                    continue;
                }
                if (this.useDynamicConfig()) {
                    if (biz.getBizName().equals(ArkConfigs.getStringValue((String)"com.alipay.sofa.ark.master.biz"))) {
                        this.bizManagerService.registerBiz(biz);
                        ++bizCount;
                        continue;
                    }
                    LOGGER.warn("The biz of {} is ignored when using dynamic config.", (Object)biz.getIdentity());
                    continue;
                }
                if (!this.isBizExcluded(biz)) {
                    this.bizManagerService.registerBiz(biz);
                    ++bizCount;
                    continue;
                }
                LOGGER.warn(String.format("The biz of %s is excluded.", biz.getIdentity()));
            }
            if (bizCount > 1) {
                AssertUtils.isFalse((boolean)StringUtils.isEmpty((String)ArkConfigs.getStringValue((String)"com.alipay.sofa.ark.master.biz")), (String)"Master biz should be configured when deploy multi biz.", (Object[])new Object[0]);
                String masterBizName = ArkConfigs.getStringValue((String)"com.alipay.sofa.ark.master.biz");
                for (Biz biz : this.bizManagerService.getBizInOrder()) {
                    if (!masterBizName.equals(biz.getBizName())) continue;
                    ArkClient.setMasterBiz((Biz)biz);
                }
            } else {
                List bizList = this.bizManagerService.getBizInOrder();
                if (!bizList.isEmpty() && StringUtils.isEmpty((String)ArkConfigs.getStringValue((String)"com.alipay.sofa.ark.master.biz"))) {
                    ArkConfigs.putStringValue((String)"com.alipay.sofa.ark.master.biz", (String)((Biz)bizList.get(0)).getBizName());
                    ArkClient.setMasterBiz((Biz)((Biz)bizList.get(0)));
                }
            }
            URL[] exportUrls = null;
            HashSet exportPackages = new HashSet();
            Biz masterBiz = ArkClient.getMasterBiz();
            for (BizArchive bizArchive : bizArchives) {
                Attributes mainAttributes = bizArchive.getManifest().getMainAttributes();
                String bizName = mainAttributes.getValue("Ark-Biz-Name");
                if (!(bizArchive instanceof JarBizArchive) || !masterBiz.getBizName().equalsIgnoreCase(bizName)) continue;
                String exportPackageStr = mainAttributes.getValue("inject-export-packages");
                exportPackages.addAll(StringUtils.strToSet((String)exportPackageStr, (String)","));
                exportUrls = ((JarBizArchive)bizArchive).getExportUrls();
            }
            for (PluginArchive pluginArchive : pluginArchives) {
                Plugin plugin = this.pluginFactoryService.createPlugin(pluginArchive, exportUrls, exportPackages);
                if (!this.isPluginExcluded(plugin)) {
                    this.pluginManagerService.registerPlugin(plugin);
                    continue;
                }
                LOGGER.warn(String.format("The plugin of %s is excluded.", plugin.getPluginName()));
            }
        }
        catch (Throwable ex) {
            throw new ArkRuntimeException(ex.getMessage(), ex);
        }
    }

    protected void processEmbed(PipelineContext pipelineContext) throws Exception {
        ClassLoader masterBizClassLoader = pipelineContext.getClass().getClassLoader();
        Biz masterBiz = this.bizFactoryService.createEmbedMasterBiz(masterBizClassLoader);
        this.bizManagerService.registerBiz(masterBiz);
        ArkClient.setMasterBiz((Biz)masterBiz);
        ArkConfigs.putStringValue((String)"com.alipay.sofa.ark.master.biz", (String)masterBiz.getBizName());
        ExecutableArchive executableArchive = pipelineContext.getExecutableArchive();
        List pluginArchives = executableArchive.getPluginArchives();
        for (PluginArchive pluginArchive : pluginArchives) {
            Plugin plugin = this.pluginFactoryService.createEmbedPlugin(pluginArchive, masterBizClassLoader);
            if (!this.isPluginExcluded(plugin)) {
                this.pluginManagerService.registerPlugin(plugin);
                continue;
            }
            LOGGER.warn(String.format("The plugin of %s is excluded.", plugin.getPluginName()));
        }
    }

    public void processStaticBizFromClasspath(PipelineContext pipelineContext) throws Exception {
        ExecutableArchive executableArchive = pipelineContext.getExecutableArchive();
        List bizArchives = executableArchive.getBizArchives();
        for (BizArchive bizArchive : bizArchives) {
            Biz biz = this.bizFactoryService.createBiz(bizArchive);
            this.bizManagerService.registerBiz(biz);
        }
    }

    public boolean isPluginExcluded(Plugin plugin) {
        String pluginName = plugin.getPluginName();
        String includePluginConf = ArkConfigs.getStringValue((String)"ark.plugin.active.include");
        String excludePluginConf = ArkConfigs.getStringValue((String)"ark.plugin.active.exclude");
        Set includePlugins = StringUtils.strToSet((String)includePluginConf, (String)",");
        Set excludePlugins = StringUtils.strToSet((String)excludePluginConf, (String)",");
        if (includePluginConf == null && excludePluginConf == null) {
            return false;
        }
        if (includePluginConf == null) {
            return excludePlugins.contains(pluginName);
        }
        return !includePlugins.contains(pluginName);
    }

    public boolean isBizExcluded(Biz biz) {
        String bizIdentity = biz.getIdentity();
        String includeBizConf = ArkConfigs.getStringValue((String)"ark.biz.active.include");
        String excludeBizConf = ArkConfigs.getStringValue((String)"ark.biz.active.exclude");
        Set includeBizs = StringUtils.strToSet((String)includeBizConf, (String)",");
        Set excludeBizs = StringUtils.strToSet((String)excludeBizConf, (String)",");
        if (includeBizConf == null && excludeBizConf == null) {
            return false;
        }
        if (includeBizConf == null) {
            return excludeBizs.contains(bizIdentity);
        }
        return !includeBizs.contains(bizIdentity);
    }

    public boolean useDynamicConfig() {
        return !StringUtils.isEmpty((String)ArkConfigs.getStringValue((String)"com.alipay.sofa.ark.config.address"));
    }
}

