/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.container.model;

import com.alipay.sofa.ark.container.registry.PluginServiceProvider;
import com.alipay.sofa.ark.container.service.ArkServiceContainerHolder;
import com.alipay.sofa.ark.spi.model.Plugin;
import com.alipay.sofa.ark.spi.model.PluginContext;
import com.alipay.sofa.ark.spi.registry.ServiceFilter;
import com.alipay.sofa.ark.spi.registry.ServiceProvider;
import com.alipay.sofa.ark.spi.registry.ServiceReference;
import com.alipay.sofa.ark.spi.service.plugin.PluginManagerService;
import com.alipay.sofa.ark.spi.service.registry.RegistryService;
import java.util.List;
import java.util.Set;

public class PluginContextImpl
implements PluginContext {
    private Plugin plugin;
    private PluginManagerService pluginManagerService = ArkServiceContainerHolder.getContainer().getService(PluginManagerService.class);
    private RegistryService registryService = ArkServiceContainerHolder.getContainer().getService(RegistryService.class);

    public PluginContextImpl(Plugin plugin) {
        this.plugin = plugin;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public Plugin getPlugin(String pluginName) {
        return this.pluginManagerService.getPluginByName(pluginName);
    }

    public <T> ServiceReference<T> publishService(Class<T> ifClass, T implObject) {
        return this.publishService(ifClass, implObject, "");
    }

    public <T> ServiceReference<T> publishService(Class<T> ifClass, T implObject, String uniqueId) {
        return this.registryService.publishService(ifClass, implObject, uniqueId, (ServiceProvider)new PluginServiceProvider(this.plugin));
    }

    public <T> ServiceReference<T> referenceService(Class<T> ifClass) {
        return this.referenceService(ifClass, "");
    }

    public <T> ServiceReference<T> referenceService(Class<T> ifClass, String uniqueId) {
        return this.registryService.referenceService(ifClass, uniqueId);
    }

    public List<ServiceReference> referenceServices(ServiceFilter serviceFilter) {
        return this.registryService.referenceServices(serviceFilter);
    }

    public Set<String> getPluginNames() {
        return this.pluginManagerService.getAllPluginNames();
    }

    public ClassLoader getClassLoader() {
        return this.plugin.getPluginClassLoader();
    }
}

