/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.container.service.biz;

import com.alipay.sofa.ark.api.ArkClient;
import com.alipay.sofa.ark.common.log.ArkLoggerFactory;
import com.alipay.sofa.ark.common.thread.ThreadPoolManager;
import com.alipay.sofa.ark.common.util.EnvironmentUtils;
import com.alipay.sofa.ark.common.util.StringUtils;
import com.alipay.sofa.ark.spi.model.Biz;
import com.alipay.sofa.ark.spi.model.BizOperation;
import com.alipay.sofa.ark.spi.model.BizState;
import com.alipay.sofa.ark.spi.service.ArkInject;
import com.alipay.sofa.ark.spi.service.biz.BizManagerService;
import com.alipay.sofa.ark.spi.service.session.CommandProvider;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;

public class BizCommandProvider
implements CommandProvider {
    private Logger LOGGER = ArkLoggerFactory.getDefaultLogger();
    @ArkInject
    private BizManagerService bizManagerService;
    private static final String HELP_MESSAGE = "Biz Command Tips:\n  USAGE: biz [option...] [arguments...]\n  SAMPLE: biz -m bizIdentityA bizIdentityB.\n  -h  Shows the help message.\n  -a  Shows all biz.\n  -m  Shows the meta info of specified bizIdentity.\n  -s  Shows the service info of specified bizIdentity.\n  -d  Shows the detail info of specified bizIdentity.\n  -i  Install biz of specified bizIdentity or bizUrl.\n  -u  Uninstall biz of specified bizIdentity.\n  -o  Switch biz of specified bizIdentity.\n";

    public String getHelp() {
        return HELP_MESSAGE;
    }

    public String handleCommand(String command) {
        return new BizCommand(command).process();
    }

    public boolean validate(String command) {
        return new BizCommand(command).isValidate();
    }

    class BizCommand {
        private boolean isValidate;
        private Set<Character> options = new HashSet<Character>();
        private Set<String> parameters = new HashSet<String>();

        BizCommand(String command) {
            if (StringUtils.isEmpty((String)command)) {
                this.isValidate = false;
                return;
            }
            String[] syntax = command.trim().split("\\s+");
            if (!"biz".equals(syntax[0])) {
                this.isValidate = false;
                return;
            }
            int argumentIndex = syntax.length;
            for (int i = 1; i < syntax.length; ++i) {
                if (!syntax[i].startsWith("-")) {
                    argumentIndex = i;
                    break;
                }
                if (syntax[i].startsWith("-") && syntax[i].length() == 1) {
                    this.isValidate = false;
                    return;
                }
                for (int j = 1; j < syntax[i].length(); ++j) {
                    this.options.add(Character.valueOf(syntax[i].charAt(j)));
                }
            }
            block5: for (Character option : this.options) {
                switch (option.charValue()) {
                    case 'a': 
                    case 'd': 
                    case 'h': 
                    case 'i': 
                    case 'm': 
                    case 'o': 
                    case 's': 
                    case 'u': {
                        continue block5;
                    }
                }
                this.isValidate = false;
                return;
            }
            if (this.options.isEmpty()) {
                this.isValidate = false;
                return;
            }
            if ((this.options.contains(Character.valueOf('h')) || this.options.contains(Character.valueOf('a')) || this.options.contains(Character.valueOf('i')) || this.options.contains(Character.valueOf('u')) || this.options.contains(Character.valueOf('o'))) && this.options.size() > 1) {
                this.isValidate = false;
                return;
            }
            while (argumentIndex < syntax.length) {
                this.parameters.add(syntax[argumentIndex++]);
            }
            if ((this.options.contains(Character.valueOf('h')) || this.options.contains(Character.valueOf('a'))) && this.parameters.size() > 0) {
                this.isValidate = false;
                return;
            }
            if (!this.options.contains(Character.valueOf('h')) && !this.options.contains(Character.valueOf('a')) && this.parameters.isEmpty()) {
                this.isValidate = false;
                return;
            }
            if ((this.options.contains(Character.valueOf('i')) || this.options.contains(Character.valueOf('u')) || this.options.contains(Character.valueOf('o'))) && this.parameters.size() > 1) {
                this.isValidate = false;
                return;
            }
            this.isValidate = true;
        }

        boolean isValidate() {
            return this.isValidate;
        }

        String process() {
            if (!this.isValidate) {
                return "Error command format. Pls type 'biz -h' to get help message\n";
            }
            StringBuilder sb = new StringBuilder(512);
            if (this.options.contains(Character.valueOf('h'))) {
                return BizCommandProvider.HELP_MESSAGE;
            }
            if (this.options.contains(Character.valueOf('a'))) {
                return this.bizList();
            }
            if (this.options.contains(Character.valueOf('i'))) {
                return this.installBiz();
            }
            if (this.options.contains(Character.valueOf('u'))) {
                return this.uninstallBiz();
            }
            if (this.options.contains(Character.valueOf('o'))) {
                return this.switchBiz();
            }
            Set candidates = BizCommandProvider.this.bizManagerService.getAllBizIdentities();
            boolean matched = false;
            for (String pattern : this.parameters) {
                for (String candidate : candidates) {
                    if (!Pattern.matches(pattern, candidate)) continue;
                    matched = true;
                    sb.append(this.bizInfo(candidate));
                }
            }
            if (!matched) {
                sb.append("no matched biz candidates.").append("\n");
            }
            return sb.toString();
        }

        String bizList() {
            List bizList = BizCommandProvider.this.bizManagerService.getBizInOrder();
            StringBuilder sb = new StringBuilder(128);
            for (Biz biz : bizList) {
                sb.append(biz.getIdentity()).append(":").append(biz.getBizState()).append("\n");
            }
            sb.append("biz count = ").append(bizList.size()).append("\n");
            return sb.toString();
        }

        String installBiz() {
            if (EnvironmentUtils.isOpenSecurity()) {
                return "Cannot execute install command in security mode.\n";
            }
            if (!this.isReadyInstall()) {
                return "Exists some biz whose state is neither 'activated' nor 'deactivated'.\n";
            }
            ThreadPoolManager.getThreadPool((String)"telnet-command").getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    BizOperation bizOperation = new BizOperation().setOperationType(BizOperation.OperationType.INSTALL);
                    String param = BizCommand.this.parameters.toArray(new String[0])[0];
                    try {
                        URL url = new URL(param);
                        bizOperation.putParameter("bizUrl", param);
                    }
                    catch (Throwable t) {
                        String[] nameAndVersion = param.split(":");
                        if (nameAndVersion.length != 2) {
                            BizCommandProvider.this.LOGGER.error("Invalid telnet biz install command {}", (Object)param);
                            return;
                        }
                        bizOperation.setBizName(nameAndVersion[0]).setBizVersion(nameAndVersion[1]);
                    }
                    try {
                        ArkClient.installOperation((BizOperation)bizOperation);
                    }
                    catch (Throwable throwable) {
                        BizCommandProvider.this.LOGGER.error("Fail to process telnet install command: " + param, throwable);
                    }
                }
            });
            return "Start to process install command now, pls wait and check.";
        }

        String uninstallBiz() {
            if (EnvironmentUtils.isOpenSecurity()) {
                return "Cannot execute uninstall command in security mode.\n";
            }
            ThreadPoolManager.getThreadPool((String)"telnet-command").getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    String param = BizCommand.this.parameters.toArray(new String[0])[0];
                    String[] nameAndVersion = param.split(":");
                    if (nameAndVersion.length != 2) {
                        BizCommandProvider.this.LOGGER.error("Invalid telnet biz uninstall command {}", (Object)param);
                        return;
                    }
                    try {
                        ArkClient.uninstallBiz((String)nameAndVersion[0], (String)nameAndVersion[1]);
                    }
                    catch (Throwable throwable) {
                        BizCommandProvider.this.LOGGER.error("Fail to process telnet uninstall command: " + param, throwable);
                    }
                }
            });
            return "Start to process uninstall command now, pls wait and check.";
        }

        String switchBiz() {
            ThreadPoolManager.getThreadPool((String)"telnet-command").getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    String param = BizCommand.this.parameters.toArray(new String[0])[0];
                    String[] nameAndVersion = param.split(":");
                    if (nameAndVersion.length != 2) {
                        BizCommandProvider.this.LOGGER.error("Invalid telnet biz switch command {}", (Object)param);
                        return;
                    }
                    try {
                        ArkClient.switchBiz((String)nameAndVersion[0], (String)nameAndVersion[1]);
                    }
                    catch (Throwable throwable) {
                        BizCommandProvider.this.LOGGER.error("Fail to process telnet switch command: " + param, throwable);
                    }
                }
            });
            return "Start to process switch command now, pls wait and check.";
        }

        String bizInfo(String bizIdentity) {
            Biz biz = BizCommandProvider.this.bizManagerService.getBizByIdentity(bizIdentity);
            if (biz == null) {
                return "Invalid bizIdentity: " + bizIdentity + "\n";
            }
            StringBuilder sb = new StringBuilder(256);
            if (this.options.contains(Character.valueOf('m'))) {
                sb.append("BizName:                  ").append(biz.getBizName()).append("\n");
                sb.append("Version:                  ").append(biz.getBizVersion()).append("\n");
                sb.append("Priority:                 ").append(biz.getPriority()).append("\n");
                sb.append("MainClass:                ").append(biz.getMainClass()).append("\n");
                sb.append("WebContextPath:           ").append(biz.getWebContextPath()).append("\n");
                sb.append("Deny Import Packages:     ").append(StringUtils.setToStr((Set)biz.getDenyImportPackages(), (String)",", (String)"\\")).append("\n");
                sb.append("Deny Import Classes:      ").append(StringUtils.setToStr((Set)biz.getDenyImportClasses(), (String)",", (String)"\\")).append("\n");
                sb.append("Deny Import Resources:    ").append(StringUtils.setToStr((Set)biz.getDenyImportResources(), (String)",", (String)"\\")).append("\n");
            }
            if (this.options.contains(Character.valueOf('s'))) {
                // empty if block
            }
            if (this.options.contains(Character.valueOf('d'))) {
                sb.append("ClassLoader: ").append(biz.getBizClassLoader()).append("\n");
                sb.append("ClassPath:   ").append(this.join(biz.getClassPath(), ",")).append("\n");
            }
            sb.append("\n");
            return sb.toString();
        }

        public boolean isReadyInstall() {
            for (Biz biz : BizCommandProvider.this.bizManagerService.getBizInOrder()) {
                if (biz.getBizState() == BizState.ACTIVATED || biz.getBizState() == BizState.DEACTIVATED) continue;
                return false;
            }
            return true;
        }

        String join(URL[] urls, String separator) {
            HashSet<String> set = new HashSet<String>();
            if (urls != null) {
                for (URL url : urls) {
                    set.add(url.getPath());
                }
            }
            return StringUtils.setToStr(set, (String)separator, (String)"\\");
        }
    }
}

