/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.loader.jar;

import com.alipay.sofa.ark.common.util.StringUtils;
import com.alipay.sofa.ark.loader.archive.JarFileArchive;
import com.alipay.sofa.ark.loader.jar.JarFile;
import com.alipay.sofa.ark.spi.archive.Archive;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;

public class JarUtils {
    private static final String CLASSPATH_ROOT_IDENTITY = "/target/classes/";
    private static final String TEST_CLASSPATH_ROOT_IDENTITY = "/target/test-classes/";
    private static final String TARGET_ROOT_IDENTITY = "/target/";
    private static final String JAR_POM_PROPERTIES_RELATIVE_PATH = "maven-archiver/pom.properties";
    private static final String JAR_ARTIFACT_ID = "artifactId";
    private static final String JAR_POM_PROPERTIES = "pom.properties";
    private static final String VERSION_REGEX = "^([0-9]+\\.)+.+";
    private static final Map<String, Optional<String>> artifactIdCacheMap = new ConcurrentHashMap<String, Optional<String>>();

    private static File searchPomProperties(File dirOrFile) {
        File[] files;
        if (dirOrFile == null || !dirOrFile.exists()) {
            return null;
        }
        if (dirOrFile.isFile() && JAR_POM_PROPERTIES.equals(dirOrFile.getName())) {
            return dirOrFile;
        }
        if (dirOrFile.isDirectory() && (files = dirOrFile.listFiles()) != null) {
            for (File file : files) {
                File result = JarUtils.searchPomProperties(file);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getArtifactIdFromLocalClassPath(String fileClassPath) {
        String pomPropertiesPath;
        String libraryFile = fileClassPath.replace("file:", "");
        int classesRootIndex = libraryFile.indexOf(CLASSPATH_ROOT_IDENTITY);
        int testClassesRootIndex = libraryFile.indexOf(TEST_CLASSPATH_ROOT_IDENTITY);
        if (classesRootIndex != -1) {
            pomPropertiesPath = libraryFile.substring(0, classesRootIndex + TARGET_ROOT_IDENTITY.length()) + JAR_POM_PROPERTIES_RELATIVE_PATH;
        } else if (testClassesRootIndex != -1) {
            pomPropertiesPath = libraryFile.substring(0, testClassesRootIndex + TARGET_ROOT_IDENTITY.length()) + JAR_POM_PROPERTIES_RELATIVE_PATH;
        } else {
            File pomPropertiesFile = JarUtils.searchPomProperties(new File(libraryFile));
            if (pomPropertiesFile == null) return null;
            if (!pomPropertiesFile.exists()) return null;
            pomPropertiesPath = pomPropertiesFile.getAbsolutePath();
        }
        try (InputStream inputStream = Files.newInputStream(Paths.get(pomPropertiesPath, new String[0]), new OpenOption[0]);){
            Properties properties = new Properties();
            properties.load(inputStream);
            String string = properties.getProperty(JAR_ARTIFACT_ID);
            return string;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String parseArtifactId(String jarLocation) {
        artifactIdCacheMap.computeIfAbsent(jarLocation, a -> {
            try {
                String artifactId;
                String[] as = a.split("!/", -1);
                if (as.length == 1) {
                    String filePath = as[0];
                    if (a.endsWith(".jar")) {
                        artifactId = JarUtils.doGetArtifactIdFromFileName(filePath);
                        if (StringUtils.isEmpty((String)artifactId)) {
                            artifactId = JarUtils.parseArtifactIdFromJar(filePath);
                        }
                    } else {
                        artifactId = JarUtils.getArtifactIdFromLocalClassPath(filePath);
                    }
                } else if (as.length == 2) {
                    String filePath = as[0];
                    artifactId = JarUtils.doGetArtifactIdFromFileName(filePath);
                    if (StringUtils.isEmpty((String)artifactId)) {
                        artifactId = JarUtils.parseArtifactIdFromJar(filePath);
                    }
                } else {
                    CharSequence[] jarPathInfo = Arrays.copyOf(as, as.length - 1);
                    String filePath = String.join((CharSequence)"!/", jarPathInfo);
                    artifactId = JarUtils.doGetArtifactIdFromFileName(filePath);
                    if (StringUtils.isEmpty((String)artifactId)) {
                        artifactId = JarUtils.parseArtifactIdFromJarInJar(filePath);
                    }
                }
                return Optional.ofNullable(artifactId);
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Failed to parse artifact id from jar %s.", jarLocation), e);
            }
        });
        return artifactIdCacheMap.get(jarLocation).orElse(null);
    }

    private static String doGetArtifactIdFromFileName(String jarLocation) {
        String[] jarInfos = jarLocation.split("/");
        if (jarInfos.length == 0) {
            return null;
        }
        String artifactVersion = jarInfos[jarInfos.length - 1];
        String[] artifactVersionInfos = artifactVersion.split("-");
        ArrayList<String> artifactInfos = new ArrayList<String>();
        boolean getVersion = false;
        for (String info : artifactVersionInfos) {
            if (!StringUtils.isEmpty((String)info) && info.matches(VERSION_REGEX)) {
                getVersion = true;
                break;
            }
            artifactInfos.add(info);
        }
        if (getVersion) {
            return String.join((CharSequence)"-", artifactInfos);
        }
        return null;
    }

    private static String parseArtifactIdFromJarInJar(String jarLocation) throws IOException {
        String subNestedPath;
        String rootPath = jarLocation.substring(0, jarLocation.lastIndexOf("!/"));
        JarFile jarFile = new JarFile(new File(rootPath));
        JarFileArchive jarFileArchive = new JarFileArchive(jarFile);
        List<Archive> archives = jarFileArchive.getNestedArchives(arg_0 -> JarUtils.lambda$parseArtifactIdFromJarInJar$1(subNestedPath = jarLocation.substring(jarLocation.lastIndexOf("!/") + 2), arg_0));
        if (archives.size() != 1) {
            return null;
        }
        Archive archive = archives.get(0);
        Properties properties = ((JarFileArchive)archive).getPomProperties();
        return properties.getProperty(JAR_ARTIFACT_ID);
    }

    private static String parseArtifactIdFromJar(String jarLocation) throws IOException {
        try (java.util.jar.JarFile jarFile = new java.util.jar.JarFile(jarLocation);){
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (!entry.getName().endsWith(JAR_POM_PROPERTIES)) continue;
                try (InputStream is = jarFile.getInputStream(entry);){
                    Properties p = new Properties();
                    p.load(is);
                    String string = p.getProperty(JAR_ARTIFACT_ID);
                    return string;
                }
            }
            String string = null;
            return string;
        }
    }

    private static /* synthetic */ boolean lambda$parseArtifactIdFromJarInJar$1(String subNestedPath, Archive.Entry entry) {
        return !StringUtils.isEmpty((String)entry.getName()) && entry.getName().equals(subNestedPath);
    }
}

