/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.bootstrap;

import com.alipay.sofa.ark.bootstrap.UseFastConnectionExceptionsEnumeration;
import com.alipay.sofa.ark.loader.jar.Handler;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;

public class ContainerClassLoader
extends URLClassLoader {
    private static final String ARK_SPI_PACKAGES = "com.alipay.sofa.ark.spi";
    private static final String ARK_API_PACKAGES = "com.alipay.sofa.ark.api";
    private static final String ARK_EXCEPTION_PACKAGES = "com.alipay.sofa.ark.exception";
    private static final String ARK_LOG_PACKAGES = "com.alipay.sofa.ark.common.log";
    private ClassLoader exportClassLoader;

    public ContainerClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    public ContainerClassLoader(URL[] urls, ClassLoader parent, ClassLoader exportClassLoader) {
        super(urls, parent);
        this.exportClassLoader = exportClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Handler.setUseFastConnectionExceptions(true);
        try {
            Class<?> clazz = this.resolveArkExportClass(name);
            if (clazz != null) {
                Class<?> clazz2 = clazz;
                return clazz2;
            }
            Class<?> clazz3 = super.loadClass(name, resolve);
            return clazz3;
        }
        finally {
            Handler.setUseFastConnectionExceptions(false);
        }
    }

    protected Class<?> resolveArkExportClass(String name) {
        if (this.exportClassLoader != null && this.isArkExportClass(name)) {
            try {
                return this.exportClassLoader.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean isArkExportClass(String className) {
        return className.startsWith(ARK_SPI_PACKAGES) || className.startsWith(ARK_API_PACKAGES) || className.startsWith(ARK_EXCEPTION_PACKAGES) || className.endsWith(ARK_LOG_PACKAGES);
    }

    @Override
    public URL getResource(String name) {
        Handler.setUseFastConnectionExceptions(true);
        try {
            URL uRL = super.getResource(name);
            return uRL;
        }
        finally {
            Handler.setUseFastConnectionExceptions(false);
        }
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Handler.setUseFastConnectionExceptions(true);
        try {
            UseFastConnectionExceptionsEnumeration useFastConnectionExceptionsEnumeration = new UseFastConnectionExceptionsEnumeration(super.getResources(name));
            return useFastConnectionExceptionsEnumeration;
        }
        finally {
            Handler.setUseFastConnectionExceptions(false);
        }
    }
}

