/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.loader;

import com.alipay.sofa.ark.spi.archive.Archive;
import com.alipay.sofa.ark.spi.archive.BizArchive;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;

public class ExplodedBizArchive
implements BizArchive {
    private static final String SOFA_ARK_BIZ_LIB = "lib/";
    private static final String MANIFEST_NAME = "META-INF/MANIFEST.MF";
    private File file;
    private URL[] urls;
    private Manifest manifest;

    public ExplodedBizArchive(File root) throws IOException {
        this.file = root;
        this.urls = this.scanUrl();
        this.manifest = new Manifest(new FileInputStream(new File(root, MANIFEST_NAME)));
    }

    private URL[] scanUrl() throws MalformedURLException {
        ArrayList<URL> urls = new ArrayList<URL>();
        urls.add(this.file.toURI().toURL());
        File libs = new File(this.file, SOFA_ARK_BIZ_LIB);
        urls.add(libs.toURI().toURL());
        File[] files = libs.listFiles();
        if (files != null) {
            for (File lib : files) {
                urls.add(lib.toURI().toURL());
            }
        }
        return urls.toArray(new URL[0]);
    }

    public URL[] getUrls() throws IOException {
        return this.urls;
    }

    public boolean isEntryExist(Archive.EntryFilter filter) {
        throw new UnsupportedOperationException("unreachable invocation.");
    }

    public URL getUrl() throws MalformedURLException {
        return this.file.toURI().toURL();
    }

    public Manifest getManifest() throws IOException {
        return this.manifest;
    }

    public List<Archive> getNestedArchives(Archive.EntryFilter filter) throws IOException {
        throw new UnsupportedOperationException("unreachable invocation.");
    }

    public Archive getNestedArchive(Archive.Entry entry) throws IOException {
        throw new UnsupportedOperationException("unreachable invocation.");
    }

    public InputStream getInputStream(ZipEntry zipEntry) throws IOException {
        throw new UnsupportedOperationException("unreachable invocation.");
    }

    public Iterator<Archive.Entry> iterator() {
        throw new UnsupportedOperationException("unreachable invocation.");
    }
}

