/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.loader;

import com.alipay.sofa.ark.bootstrap.ClasspathLauncher;
import com.alipay.sofa.ark.exception.ArkRuntimeException;
import com.alipay.sofa.ark.loader.JarContainerArchive;
import com.alipay.sofa.ark.loader.JarPluginArchive;
import com.alipay.sofa.ark.loader.archive.JarFileArchive;
import com.alipay.sofa.ark.spi.archive.Archive;
import com.alipay.sofa.ark.spi.archive.BizArchive;
import com.alipay.sofa.ark.spi.archive.ContainerArchive;
import com.alipay.sofa.ark.spi.archive.PluginArchive;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class EmbedClassPathArchive
extends ClasspathLauncher.ClassPathArchive {
    public EmbedClassPathArchive(String className, String method, URL[] urls) throws IOException {
        super(className, method, urls);
    }

    @Override
    public ContainerArchive getContainerArchive() throws Exception {
        List<URL> urlList = this.filterUrls("com/alipay/sofa/ark/container/mark");
        if (urlList.isEmpty()) {
            return this.createDirectoryContainerArchive();
        }
        if (urlList.size() > 1) {
            throw new ArkRuntimeException("Duplicate Container Jar File Found.");
        }
        return new JarContainerArchive(this.getUrlJarFileArchive(urlList.get(0)));
    }

    @Override
    public List<BizArchive> getBizArchives() {
        return new ArrayList<BizArchive>();
    }

    @Override
    public List<PluginArchive> getPluginArchives() throws Exception {
        List<URL> urlList = this.filterUrls("com/alipay/sofa/ark/plugin/mark");
        ArrayList<PluginArchive> pluginArchives = new ArrayList<PluginArchive>();
        for (URL url : urlList) {
            pluginArchives.add(new JarPluginArchive(this.getUrlJarFileArchive(url)));
        }
        return pluginArchives;
    }

    protected JarFileArchive getUrlJarFileArchive(URL url) throws IOException {
        String file = url.getFile();
        if (file.contains("!/")) {
            int pos = file.indexOf("!/");
            File fatJarFile = new File(file.substring(0, pos));
            String nestedJar = file.substring(file.lastIndexOf("/") + 1);
            JarFileArchive fatJarFileArchive = new JarFileArchive(fatJarFile);
            List<Archive> matched = fatJarFileArchive.getNestedArchives(entry -> entry.getName().contains(nestedJar));
            return (JarFileArchive)matched.get(0);
        }
        return new JarFileArchive(new File(file));
    }
}

