/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.bootstrap;

import com.alipay.sofa.ark.bootstrap.ArkLauncher;
import com.alipay.sofa.ark.common.util.AssertUtils;
import com.alipay.sofa.ark.common.util.ClassLoaderUtils;
import com.alipay.sofa.ark.common.util.ClassUtils;
import com.alipay.sofa.ark.common.util.StringUtils;
import com.alipay.sofa.ark.exception.ArkRuntimeException;
import com.alipay.sofa.ark.loader.DirectoryBizArchive;
import com.alipay.sofa.ark.loader.DirectoryContainerArchive;
import com.alipay.sofa.ark.loader.JarBizArchive;
import com.alipay.sofa.ark.loader.JarContainerArchive;
import com.alipay.sofa.ark.loader.JarPluginArchive;
import com.alipay.sofa.ark.loader.archive.JarFileArchive;
import com.alipay.sofa.ark.spi.archive.Archive;
import com.alipay.sofa.ark.spi.archive.BizArchive;
import com.alipay.sofa.ark.spi.archive.ContainerArchive;
import com.alipay.sofa.ark.spi.archive.ExecutableArchive;
import com.alipay.sofa.ark.spi.archive.PluginArchive;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;

public class ClasspathLauncher
extends ArkLauncher {
    public ClasspathLauncher(ClassPathArchive classPathArchive) {
        super(classPathArchive);
    }

    public static class ClassPathArchive
    implements ExecutableArchive {
        public static final String FILE_IN_JAR = "!/";
        private final String className;
        private final String methodName;
        private final URL[] urls;
        private final URLClassLoader urlClassLoader;
        private File arkConfBaseDir;

        public ClassPathArchive(String className, String methodName, URL[] urls) throws IOException {
            AssertUtils.isFalse((boolean)StringUtils.isEmpty((String)className), (String)"Entry class name must be specified.", (Object[])new Object[0]);
            this.className = className;
            this.methodName = methodName;
            this.urls = urls;
            List<URL> classpath = this.getConfClasspath();
            classpath.addAll(Arrays.asList(this.urls));
            this.urlClassLoader = new URLClassLoader(classpath.toArray(new URL[0]), null);
        }

        public List<URL> filterUrls(String resource) throws Exception {
            ArrayList<URL> urlList = new ArrayList<URL>();
            Enumeration<URL> enumeration = this.urlClassLoader.findResources(resource);
            while (enumeration.hasMoreElements()) {
                URL resourceUrl = enumeration.nextElement();
                String resourceFile = resourceUrl.getFile();
                String jarFile = resourceFile.substring(0, resourceFile.length() - resource.length() - FILE_IN_JAR.length());
                urlList.add(new URL(jarFile));
            }
            return urlList;
        }

        public ContainerArchive getContainerArchive() throws Exception {
            ContainerArchive archive = this.getJarContainerArchive();
            if (archive == null) {
                archive = this.createDirectoryContainerArchive();
            }
            if (archive == null) {
                throw new ArkRuntimeException("No Ark Container Jar File Found.");
            }
            return archive;
        }

        protected ContainerArchive getJarContainerArchive() throws Exception {
            List<URL> urlList = this.filterUrls("com/alipay/sofa/ark/container/mark");
            if (urlList.isEmpty()) {
                return null;
            }
            if (urlList.size() > 1) {
                throw new ArkRuntimeException("Duplicate Container Jar File Found.");
            }
            return new JarContainerArchive(new JarFileArchive(new File(urlList.get(0).getFile())));
        }

        public List<BizArchive> getBizArchives() throws Exception {
            List<URL> urlList = this.filterUrls("com/alipay/sofa/ark/biz/mark");
            LinkedList<BizArchive> bizArchives = new LinkedList<BizArchive>();
            if (this.className != null && this.methodName != null) {
                bizArchives.add(this.createDirectoryBizModuleArchive());
            }
            for (URL url : urlList) {
                bizArchives.add(new JarBizArchive(new JarFileArchive(new File(url.getFile()))));
            }
            return bizArchives;
        }

        public List<PluginArchive> getPluginArchives() throws Exception {
            List<URL> urlList = this.filterUrls("com/alipay/sofa/ark/plugin/mark");
            ArrayList<PluginArchive> pluginArchives = new ArrayList<PluginArchive>();
            for (URL url : urlList) {
                pluginArchives.add(new JarPluginArchive(new JarFileArchive(new File(url.getFile()))));
            }
            return pluginArchives;
        }

        public List<URL> getConfClasspath() throws IOException {
            ArrayList<URL> urls = new ArrayList<URL>();
            if (this.arkConfBaseDir == null) {
                this.arkConfBaseDir = this.deduceArkConfBaseDir();
            }
            this.scanConfClasspath(this.arkConfBaseDir, urls);
            return urls;
        }

        private void scanConfClasspath(File arkConfBaseDir, List<URL> classpath) throws IOException {
            if (arkConfBaseDir == null || arkConfBaseDir.isFile() || arkConfBaseDir.listFiles() == null) {
                return;
            }
            classpath.add(arkConfBaseDir.toURI().toURL());
            for (File subFile : arkConfBaseDir.listFiles()) {
                this.scanConfClasspath(subFile, classpath);
            }
        }

        private File deduceArkConfBaseDir() {
            File arkConfDir = null;
            try {
                File file;
                URLClassLoader tempClassLoader = new URLClassLoader(this.urls);
                Class<?> entryClass = tempClassLoader.loadClass(this.className);
                String classLocation = ClassUtils.getCodeBase(entryClass);
                File file2 = file = classLocation == null ? null : new File(classLocation);
                while (!(file == null || (arkConfDir = new File(file.getPath() + File.separator + "conf/ark")).exists() && arkConfDir.isDirectory())) {
                    file = file.getParentFile();
                }
            }
            catch (Throwable throwable) {
                throw new ArkRuntimeException(throwable);
            }
            return arkConfDir == null ? null : arkConfDir.getParentFile();
        }

        public URL getUrl() {
            throw new RuntimeException("unreachable invocation.");
        }

        public Manifest getManifest() {
            throw new RuntimeException("unreachable invocation.");
        }

        public List<Archive> getNestedArchives(Archive.EntryFilter filter) {
            throw new RuntimeException("unreachable invocation.");
        }

        public Archive getNestedArchive(Archive.Entry entry) {
            throw new RuntimeException("unreachable invocation.");
        }

        public InputStream getInputStream(ZipEntry zipEntry) {
            throw new RuntimeException("unreachable invocation.");
        }

        public Iterator<Archive.Entry> iterator() {
            throw new RuntimeException("unreachable invocation.");
        }

        protected BizArchive createDirectoryBizModuleArchive() {
            return new DirectoryBizArchive(this.className, this.methodName, this.filterBizUrls(this.urls));
        }

        protected ContainerArchive createDirectoryContainerArchive() {
            URL[] candidates = this.urls.length == 1 || this.urls.length == 2 ? this.parseClassPathFromSurefireBoot(this.getSurefireBooterJar(this.urls)) : this.urls;
            URL[] filterUrls = this.filterURLs(candidates);
            return filterUrls == null ? null : new DirectoryContainerArchive(filterUrls);
        }

        private URL getSurefireBooterJar(URL[] urls) {
            for (URL url : urls) {
                if (!url.getFile().contains("surefirebooter")) continue;
                return url;
            }
            return null;
        }

        protected URL[] filterURLs(URL[] urls) {
            Set<String> arkContainerJarMarkers = DirectoryContainerArchive.getArkContainerJarMarkers();
            HashSet<URL> containerClassPath = new HashSet<URL>();
            for (String marker : arkContainerJarMarkers) {
                for (URL url : urls) {
                    if (!url.getPath().contains(marker)) continue;
                    containerClassPath.add(url);
                }
            }
            return arkContainerJarMarkers.size() != containerClassPath.size() ? null : containerClassPath.toArray(new URL[0]);
        }

        protected URL[] filterBizUrls(URL[] urls) {
            List<URL> urlList;
            URL[] agentClassPath = ClassLoaderUtils.getAgentClassPath();
            try {
                urlList = this.filterUrls("com/alipay/sofa/ark/biz/mark");
            }
            catch (Throwable throwable) {
                urlList = Collections.emptyList();
            }
            ArrayList<URL> bizURls = new ArrayList<URL>();
            for (URL url : urls) {
                boolean isAgent = false;
                for (URL agentUrl : agentClassPath) {
                    if (!url.equals(agentUrl)) continue;
                    isAgent = true;
                    break;
                }
                if (isAgent || urlList.contains(url)) continue;
                bizURls.add(url);
            }
            return bizURls.toArray(new URL[0]);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected URL[] parseClassPathFromSurefireBoot(URL surefireBootJar) {
            AssertUtils.assertNotNull((Object)surefireBootJar, (String)"SurefireBooter jar should not be null.");
            try (JarFile jarFile = new JarFile(surefireBootJar.getFile());){
                String[] classPath = jarFile.getManifest().getMainAttributes().getValue("Class-Path").split(" ");
                ArrayList<URL> urls = new ArrayList<URL>();
                for (String path : classPath) {
                    urls.add(new URL(path));
                }
                Object[] objectArray = urls.toArray(new URL[0]);
                return objectArray;
            }
            catch (IOException ex) {
                throw new ArkRuntimeException("Parse classpath failed from surefire boot jar.", (Throwable)ex);
            }
        }
    }
}

