/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.spring.configuration;

import com.alipay.sofa.ark.spi.model.Biz;
import com.alipay.sofa.healthcheck.core.HealthChecker;
import com.alipay.sofa.runtime.SofaFramework;
import com.alipay.sofa.runtime.api.client.ReferenceClient;
import com.alipay.sofa.runtime.api.client.ServiceClient;
import com.alipay.sofa.runtime.client.impl.ClientFactoryImpl;
import com.alipay.sofa.runtime.component.impl.StandardSofaRuntimeManager;
import com.alipay.sofa.runtime.service.client.ReferenceClientImpl;
import com.alipay.sofa.runtime.service.client.ServiceClientImpl;
import com.alipay.sofa.runtime.service.impl.BindingAdapterFactoryImpl;
import com.alipay.sofa.runtime.service.impl.BindingConverterFactoryImpl;
import com.alipay.sofa.runtime.spi.binding.BindingAdapter;
import com.alipay.sofa.runtime.spi.binding.BindingAdapterFactory;
import com.alipay.sofa.runtime.spi.component.SofaRuntimeContext;
import com.alipay.sofa.runtime.spi.service.BindingConverter;
import com.alipay.sofa.runtime.spi.service.BindingConverterFactory;
import com.alipay.sofa.runtime.spring.ApplicationShutdownCallbackPostProcessor;
import com.alipay.sofa.runtime.spring.ClientFactoryBeanPostProcessor;
import com.alipay.sofa.runtime.spring.ServiceAnnotationBeanPostProcessor;
import com.alipay.sofa.runtime.spring.SofaRuntimeContextAwareProcessor;
import com.alipay.sofa.runtime.spring.callback.CloseApplicationContextCallBack;
import com.alipay.sofa.runtime.spring.config.SofaRuntimeConfigurationProperties;
import com.alipay.sofa.runtime.spring.health.DefaultRuntimeHealthChecker;
import com.alipay.sofa.runtime.spring.health.MultiApplicationHealthIndicator;
import com.alipay.sofa.runtime.spring.health.SofaComponentHealthChecker;
import com.alipay.sofa.runtime.spring.health.SofaComponentHealthIndicator;
import java.util.HashSet;
import java.util.ServiceLoader;
import java.util.Set;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Role;

@Configuration
@EnableConfigurationProperties(value={SofaRuntimeConfigurationProperties.class})
public class SofaRuntimeAutoConfiguration {
    @Bean
    @Role(value=2)
    public static BindingConverterFactory bindingConverterFactory() {
        BindingConverterFactoryImpl bindingConverterFactory = new BindingConverterFactoryImpl();
        bindingConverterFactory.addBindingConverters(SofaRuntimeAutoConfiguration.getClassesByServiceLoader(BindingConverter.class));
        return bindingConverterFactory;
    }

    @Bean
    @Role(value=2)
    public static BindingAdapterFactory bindingAdapterFactory() {
        BindingAdapterFactoryImpl bindingAdapterFactory = new BindingAdapterFactoryImpl();
        bindingAdapterFactory.addBindingAdapters(SofaRuntimeAutoConfiguration.getClassesByServiceLoader(BindingAdapter.class));
        return bindingAdapterFactory;
    }

    @Bean
    @Role(value=2)
    public static SofaRuntimeContext sofaRuntimeContext(@Value(value="${spring.application.name}") String appName, BindingConverterFactory bindingConverterFactory, BindingAdapterFactory bindingAdapterFactory) {
        ClientFactoryImpl clientFactoryInternal = new ClientFactoryImpl();
        StandardSofaRuntimeManager sofaRuntimeManager = new StandardSofaRuntimeManager(appName, SofaRuntimeAutoConfiguration.class.getClassLoader(), clientFactoryInternal);
        sofaRuntimeManager.getComponentManager().registerComponentClient(ReferenceClient.class, new ReferenceClientImpl(sofaRuntimeManager.getSofaRuntimeContext(), bindingConverterFactory, bindingAdapterFactory));
        sofaRuntimeManager.getComponentManager().registerComponentClient(ServiceClient.class, new ServiceClientImpl(sofaRuntimeManager.getSofaRuntimeContext(), bindingConverterFactory, bindingAdapterFactory));
        SofaFramework.registerSofaRuntimeManager(sofaRuntimeManager);
        return sofaRuntimeManager.getSofaRuntimeContext();
    }

    @Bean
    public static ServiceAnnotationBeanPostProcessor serviceAnnotationBeanPostProcessor(BindingAdapterFactory bindingAdapterFactory, BindingConverterFactory bindingConverterFactory) {
        return new ServiceAnnotationBeanPostProcessor(bindingAdapterFactory, bindingConverterFactory);
    }

    @Bean
    public static ClientFactoryBeanPostProcessor clientFactoryBeanPostProcessor(SofaRuntimeContext sofaRuntimeContext) {
        return new ClientFactoryBeanPostProcessor(sofaRuntimeContext.getClientFactory());
    }

    @Bean
    public static ApplicationShutdownCallbackPostProcessor applicationShutdownCallbackPostProcessor(SofaRuntimeContext sofaRuntimeContext) {
        return new ApplicationShutdownCallbackPostProcessor(sofaRuntimeContext.getSofaRuntimeManager());
    }

    @Bean
    public static SofaRuntimeContextAwareProcessor sofaRuntimeContextAwareProcessor(SofaRuntimeContext sofaRuntimeContext) {
        return new SofaRuntimeContextAwareProcessor(sofaRuntimeContext);
    }

    @Bean
    public CloseApplicationContextCallBack closeApplicationContextCallBack() {
        return new CloseApplicationContextCallBack();
    }

    private static <T> Set<T> getClassesByServiceLoader(Class<T> clazz) {
        ServiceLoader<T> serviceLoader = ServiceLoader.load(clazz);
        HashSet<T> result = new HashSet<T>();
        for (T t : serviceLoader) {
            result.add(t);
        }
        return result;
    }

    @Configuration
    @ConditionalOnClass(value={HealthChecker.class})
    @AutoConfigureAfter(value={SofaRuntimeAutoConfiguration.class})
    public static class SofaModuleHealthCheckerConfiguration {
        @Bean
        public SofaComponentHealthChecker sofaComponentHealthChecker(SofaRuntimeContext sofaRuntimeContext) {
            return new SofaComponentHealthChecker(sofaRuntimeContext);
        }
    }

    @Configuration
    @ConditionalOnClass(value={HealthIndicator.class})
    @ConditionalOnMissingClass(value={"com.alipay.sofa.healthcheck.core.HealthChecker"})
    @AutoConfigureAfter(value={SofaRuntimeAutoConfiguration.class})
    public static class SofaRuntimeHealthIndicatorConfiguration {
        @Bean
        public SofaComponentHealthIndicator sofaComponentHealthIndicator(SofaRuntimeContext sofaRuntimeContext) {
            return new SofaComponentHealthIndicator(sofaRuntimeContext);
        }
    }

    @Configuration
    @ConditionalOnClass(value={HealthChecker.class, Biz.class})
    public static class MultiApplicationHealthIndicatorConfiguration {
        @Bean
        public MultiApplicationHealthIndicator multiApplicationHealthIndicator() {
            return new MultiApplicationHealthIndicator();
        }
    }

    @Configuration
    @ConditionalOnClass(value={HealthChecker.class})
    @AutoConfigureAfter(value={SofaRuntimeAutoConfiguration.class})
    public static class DefaultRuntimeHealthCheckerConfiguration {
        @Bean
        public DefaultRuntimeHealthChecker defaultRuntimeHealthChecker(SofaRuntimeContext sofaRuntimeContext) {
            return new DefaultRuntimeHealthChecker(sofaRuntimeContext);
        }
    }
}

