/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.spring;

import com.alipay.sofa.runtime.api.annotation.SofaClientFactory;
import com.alipay.sofa.runtime.api.aware.ClientFactoryAware;
import com.alipay.sofa.runtime.api.client.ClientFactory;
import com.alipay.sofa.runtime.client.impl.ClientFactoryImpl;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.PriorityOrdered;
import org.springframework.util.ReflectionUtils;

public class ClientFactoryBeanPostProcessor
implements BeanPostProcessor,
PriorityOrdered {
    private ClientFactory clientFactory;

    public ClientFactoryBeanPostProcessor(ClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    public Object postProcessBeforeInitialization(final Object bean, String beanName) throws BeansException {
        if (bean instanceof ClientFactoryAware) {
            ((ClientFactoryAware)bean).setClientFactory(this.clientFactory);
        }
        ReflectionUtils.doWithFields(bean.getClass(), (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                if (field.getType().equals(ClientFactory.class)) {
                    ReflectionUtils.makeAccessible((Field)field);
                    ReflectionUtils.setField((Field)field, (Object)bean, (Object)ClientFactoryBeanPostProcessor.this.clientFactory);
                } else if (ClientFactoryBeanPostProcessor.this.clientFactory instanceof ClientFactoryImpl && ((ClientFactoryImpl)ClientFactoryBeanPostProcessor.this.clientFactory).getAllClientTypes().contains(field.getType())) {
                    Object client = ClientFactoryBeanPostProcessor.this.clientFactory.getClient(field.getType());
                    ReflectionUtils.makeAccessible((Field)field);
                    ReflectionUtils.setField((Field)field, (Object)bean, client);
                } else {
                    throw new RuntimeException("Field annotated by ClientFactorySetter must be of type ClientFactory or client store in the ClientFactory.");
                }
            }
        }, (ReflectionUtils.FieldFilter)new ReflectionUtils.FieldFilter(){

            public boolean matches(Field field) {
                return !Modifier.isStatic(field.getModifiers()) && field.isAnnotationPresent(SofaClientFactory.class);
            }
        });
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

