/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.spi.log;

import com.alipay.sofa.runtime.spi.log.SofaRuntimeLoggerFactory;
import java.text.MessageFormat;
import org.slf4j.Logger;

public class SofaLogger {
    private static final Logger DEFAULT_LOG = SofaRuntimeLoggerFactory.getLogger("com.alipay.sofa");

    public static void debug(String format, Object ... args) {
        if (DEFAULT_LOG.isDebugEnabled()) {
            DEFAULT_LOG.debug(SofaLogger.getMessage(format, args));
        }
    }

    public static void info(String format, Object ... args) {
        if (DEFAULT_LOG.isInfoEnabled()) {
            DEFAULT_LOG.info(SofaLogger.getMessage(format, args));
        }
    }

    public static void warn(String format, Object ... args) {
        if (DEFAULT_LOG.isWarnEnabled()) {
            DEFAULT_LOG.warn(SofaLogger.getMessage(format, args));
        }
    }

    public static void error(String format, Object ... args) {
        DEFAULT_LOG.error(SofaLogger.getMessage(format, args));
    }

    public static void error(Throwable t, String format, Object ... args) {
        DEFAULT_LOG.error(SofaLogger.getMessage(format, args), t);
    }

    private static String getMessage(String format, Object ... args) {
        return MessageFormat.format(format, args);
    }

    public static boolean isDebugEnabled() {
        return DEFAULT_LOG.isDebugEnabled();
    }
}

