/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hessian.io.throwable;

import com.caucho.hessian.io.AbstractFieldAdaptorSerializer;
import com.caucho.hessian.io.AbstractHessianOutput;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ThrowableSerializer
extends AbstractFieldAdaptorSerializer {
    protected static final Logger log = Logger.getLogger(ThrowableSerializer.class.getName());
    protected Method getSuppressed = null;

    public ThrowableSerializer(Class<?> clazz) {
        super(clazz);
        try {
            this.getSuppressed = clazz.getMethod("getSuppressed", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    @Override
    public void writeObject(Object obj, AbstractHessianOutput out) throws IOException {
        ((Throwable)obj).getStackTrace();
        super.writeObject(obj, out);
    }

    @Override
    protected void serializeField(AbstractHessianOutput out, Object obj, Field field) throws IOException {
        if (!(obj instanceof Throwable)) {
            throw new UnsupportedOperationException(String.valueOf(this));
        }
        Throwable current = (Throwable)obj;
        if ("detailMessage".equals(field.getName())) {
            out.writeString(current.getMessage());
        } else if ("cause".equals(field.getName())) {
            out.writeObject(current.getCause());
        } else if ("stackTrace".equals(field.getName())) {
            out.writeObject(current.getStackTrace());
        } else if ("suppressedExceptions".equals(field.getName())) {
            Throwable[] throwableArray;
            if (this.getSuppressed == null) {
                throw new UnsupportedOperationException(String.valueOf(this));
            }
            try {
                throwableArray = (Throwable[])this.getSuppressed.invoke(obj, new Object[0]);
            }
            catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
            List<Object> throwableList = throwableArray.length == 0 ? Collections.unmodifiableList(new ArrayList()) : new ArrayList<Throwable>(Arrays.asList(throwableArray));
            out.writeObject(throwableList);
        } else {
            this.defaultSerializeField(out, obj, field);
        }
    }

    protected void defaultSerializeField(AbstractHessianOutput out, Object obj, Field field) throws IOException {
        Object fieldValue = null;
        try {
            field.setAccessible(true);
            fieldValue = field.get(obj);
        }
        catch (IllegalAccessException e) {
            log.log(Level.FINE, e.toString());
        }
        out.writeObject(fieldValue);
    }
}

