/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.common.log;

import com.alipay.sofa.common.utils.StringUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class CommonLoggingConfigurations {
    private static Set<String> loggerConsoleWhiteSet;
    private static final Map<String, String> externalConfigurations;

    public static void loadExternalConfiguration(String key, String value) {
        if (StringUtil.isNotEmpty(key) && StringUtil.isNotEmpty(value)) {
            externalConfigurations.put(key, value);
        }
    }

    public static Map<String, String> getExternalConfigurations() {
        return externalConfigurations;
    }

    public static void setLoggerConsoleWhiteSet(Set<String> set) {
        loggerConsoleWhiteSet = set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void appendConsoleLoggerName(String loggerName) {
        if (loggerConsoleWhiteSet == null) {
            Class<CommonLoggingConfigurations> clazz = CommonLoggingConfigurations.class;
            // MONITORENTER : com.alipay.sofa.common.log.CommonLoggingConfigurations.class
            if (loggerConsoleWhiteSet == null) {
                loggerConsoleWhiteSet = Collections.synchronizedSet(new HashSet());
            }
            // MONITOREXIT : clazz
        }
        loggerConsoleWhiteSet.add(loggerName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void addAllConsoleLogger(Set<String> set) {
        if (loggerConsoleWhiteSet == null) {
            Class<CommonLoggingConfigurations> clazz = CommonLoggingConfigurations.class;
            // MONITORENTER : com.alipay.sofa.common.log.CommonLoggingConfigurations.class
            if (loggerConsoleWhiteSet == null) {
                loggerConsoleWhiteSet = Collections.synchronizedSet(new HashSet());
            }
            // MONITOREXIT : clazz
        }
        if (set == null) return;
        loggerConsoleWhiteSet.addAll(set);
    }

    public static Set<String> getLoggerConsoleWhiteSet() {
        return loggerConsoleWhiteSet;
    }

    public static boolean shouldAttachConsoleAppender(String loggerName) {
        if (loggerConsoleWhiteSet == null) {
            return false;
        }
        return loggerConsoleWhiteSet.contains(loggerName);
    }

    static {
        externalConfigurations = new ConcurrentHashMap<String, String>();
    }
}

