/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.template;

import com.alicp.jetcache.AbstractCacheBuilder;
import com.alicp.jetcache.CacheBuilder;
import com.alicp.jetcache.template.CacheMonitorInstaller;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CacheBuilderTemplate {
    private final boolean penetrationProtect;
    private final Map<String, CacheBuilder>[] cacheBuilders;
    private final List<CacheMonitorInstaller> cacheMonitorInstallers = new ArrayList<CacheMonitorInstaller>();

    @SafeVarargs
    public CacheBuilderTemplate(boolean penetrationProtect, Map<String, CacheBuilder> ... cacheBuilders) {
        this.penetrationProtect = penetrationProtect;
        this.cacheBuilders = cacheBuilders;
    }

    public boolean isPenetrationProtect() {
        return this.penetrationProtect;
    }

    public CacheBuilder getCacheBuilder(int level, String area) {
        CacheBuilder cb = this.cacheBuilders[level].get(area);
        if (cb instanceof AbstractCacheBuilder) {
            return (CacheBuilder)((AbstractCacheBuilder)cb).clone();
        }
        return cb;
    }

    public List<CacheMonitorInstaller> getCacheMonitorInstallers() {
        return this.cacheMonitorInstallers;
    }
}

