/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache;

import com.alicp.jetcache.AbstractCache;
import com.alicp.jetcache.Cache;
import com.alicp.jetcache.CacheException;
import com.alicp.jetcache.CacheGetResult;
import com.alicp.jetcache.CacheLoader;
import com.alicp.jetcache.CacheResultCode;
import com.alicp.jetcache.CacheUtil;
import com.alicp.jetcache.LoadingCache;
import com.alicp.jetcache.MultiGetResult;
import com.alicp.jetcache.MultiLevelCache;
import com.alicp.jetcache.ProxyCache;
import com.alicp.jetcache.RefreshPolicy;
import com.alicp.jetcache.embedded.AbstractEmbeddedCache;
import com.alicp.jetcache.event.CacheEvent;
import com.alicp.jetcache.external.AbstractExternalCache;
import com.alicp.jetcache.support.JetCacheExecutor;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefreshCache<K, V>
extends LoadingCache<K, V> {
    private static final Logger logger = LoggerFactory.getLogger(RefreshCache.class);
    private ConcurrentHashMap<Object, RefreshTask> taskMap = new ConcurrentHashMap();
    private boolean multiLevelCache = this.isMultiLevelCache();

    public RefreshCache(Cache cache) {
        super(cache);
    }

    protected void stopRefresh() {
        ArrayList<RefreshTask> tasks = new ArrayList<RefreshTask>();
        tasks.addAll(this.taskMap.values());
        tasks.forEach(task -> ((RefreshTask)task).cancel());
    }

    @Override
    public void close() {
        this.stopRefresh();
        super.close();
    }

    private boolean hasLoader() {
        return this.config.getLoader() != null;
    }

    @Override
    public V computeIfAbsent(K key, Function<K, V> loader) {
        return this.computeIfAbsent(key, loader, this.config().isCacheNullValue());
    }

    @Override
    public V computeIfAbsent(K key, Function<K, V> loader, boolean cacheNullWhenLoaderReturnNull) {
        return AbstractCache.computeIfAbsentImpl(key, loader, cacheNullWhenLoaderReturnNull, 0L, null, this);
    }

    @Override
    public V computeIfAbsent(K key, Function<K, V> loader, boolean cacheNullWhenLoaderReturnNull, long expireAfterWrite, TimeUnit timeUnit) {
        return AbstractCache.computeIfAbsentImpl(key, loader, cacheNullWhenLoaderReturnNull, expireAfterWrite, timeUnit, this);
    }

    protected Cache concreteCache() {
        Cache c = this.getTargetCache();
        while (true) {
            if (c instanceof ProxyCache) {
                c = ((ProxyCache)c).getTargetCache();
                continue;
            }
            if (!(c instanceof MultiLevelCache)) break;
            Cache[] caches = ((MultiLevelCache)c).caches();
            c = caches[caches.length - 1];
        }
        return c;
    }

    private boolean isMultiLevelCache() {
        Cache c = this.getTargetCache();
        while (c instanceof ProxyCache) {
            c = ((ProxyCache)c).getTargetCache();
        }
        return c instanceof MultiLevelCache;
    }

    private Object getTaskId(K key) {
        Cache c = this.concreteCache();
        if (c instanceof AbstractEmbeddedCache) {
            return ((AbstractEmbeddedCache)c).buildKey(key);
        }
        if (c instanceof AbstractExternalCache) {
            byte[] bs = ((AbstractExternalCache)c).buildKey(key);
            return ByteBuffer.wrap(bs);
        }
        logger.error("can't getTaskId from " + c.getClass());
        return null;
    }

    protected void addOrUpdateRefreshTask(K key, CacheLoader<K, V> loader) {
        RefreshPolicy refreshPolicy = this.config.getRefreshPolicy();
        if (refreshPolicy == null) {
            return;
        }
        long refreshMillis = refreshPolicy.getRefreshMillis();
        if (refreshMillis > 0L) {
            Object taskId = this.getTaskId(key);
            RefreshTask refreshTask = this.taskMap.computeIfAbsent(taskId, (? super K tid) -> {
                logger.debug("add refresh task. interval={},  key={}", (Object)refreshMillis, key);
                RefreshTask task = new RefreshTask(taskId, key, loader);
                task.lastAccessTime = System.currentTimeMillis();
                ScheduledFuture<?> future = JetCacheExecutor.heavyIOExecutor().scheduleWithFixedDelay(task, refreshMillis, refreshMillis, TimeUnit.MILLISECONDS);
                task.future = future;
                return task;
            });
            refreshTask.lastAccessTime = System.currentTimeMillis();
        }
    }

    @Override
    public CacheGetResult<V> GET(K key) {
        if (this.config.getRefreshPolicy() != null && this.hasLoader()) {
            this.addOrUpdateRefreshTask(key, null);
        }
        return this.cache.GET(key);
    }

    @Override
    public MultiGetResult<K, V> GET_ALL(Set<? extends K> keys) {
        if (this.config.getRefreshPolicy() != null && this.hasLoader()) {
            for (K key : keys) {
                this.addOrUpdateRefreshTask(key, null);
            }
        }
        return this.cache.GET_ALL(keys);
    }

    private byte[] combine(byte[] bs1, byte[] bs2) {
        byte[] newArray = Arrays.copyOf(bs1, bs1.length + bs2.length);
        System.arraycopy(bs2, 0, newArray, bs1.length, bs2.length);
        return newArray;
    }

    class RefreshTask
    implements Runnable {
        private Object taskId;
        private K key;
        private CacheLoader<K, V> loader;
        private long lastAccessTime;
        private ScheduledFuture future;

        RefreshTask(Object taskId, K key, CacheLoader<K, V> loader) {
            this.taskId = taskId;
            this.key = key;
            this.loader = loader;
        }

        private void cancel() {
            logger.debug("cancel refresh: {}", this.key);
            this.future.cancel(false);
            RefreshCache.this.taskMap.remove(this.taskId);
        }

        private void load() throws Throwable {
            Object v;
            CacheLoader l;
            CacheLoader cacheLoader = l = this.loader == null ? RefreshCache.this.config.getLoader() : this.loader;
            if (l != null && RefreshCache.this.needUpdate(v = (l = CacheUtil.createProxyLoader(RefreshCache.this.cache, l, (Consumer<CacheEvent>)RefreshCache.this.eventConsumer)).load(this.key), l)) {
                RefreshCache.this.cache.PUT(this.key, v);
            }
        }

        private void externalLoad(Cache concreteCache, long currentTime) throws Throwable {
            byte[] newKey = ((AbstractExternalCache)concreteCache).buildKey(this.key);
            byte[] lockKey = RefreshCache.this.combine(newKey, "_#RL#".getBytes());
            long loadTimeOut = RefreshCache.this.config.getRefreshPolicy().getRefreshLockTimeoutMillis();
            long refreshMillis = RefreshCache.this.config.getRefreshPolicy().getRefreshMillis();
            byte[] timestampKey = RefreshCache.this.combine(newKey, "_#TS#".getBytes());
            CacheGetResult refreshTimeResult = concreteCache.GET(timestampKey);
            boolean shouldLoad = false;
            if (refreshTimeResult.isSuccess()) {
                shouldLoad = currentTime >= Long.parseLong(refreshTimeResult.getValue().toString()) + refreshMillis;
            } else if (refreshTimeResult.getResultCode() == CacheResultCode.NOT_EXISTS) {
                shouldLoad = true;
            }
            if (!shouldLoad) {
                if (RefreshCache.this.multiLevelCache) {
                    this.refreshUpperCaches(this.key);
                }
                return;
            }
            Runnable r = () -> {
                try {
                    this.load();
                    concreteCache.put(timestampKey, String.valueOf(System.currentTimeMillis()));
                }
                catch (Throwable e) {
                    throw new CacheException("refresh error", e);
                }
            };
            boolean lockSuccess = concreteCache.tryLockAndRun(lockKey, loadTimeOut, TimeUnit.MILLISECONDS, r);
            if (!lockSuccess && RefreshCache.this.multiLevelCache) {
                JetCacheExecutor.heavyIOExecutor().schedule(() -> this.refreshUpperCaches(this.key), (long)(0.2 * (double)refreshMillis), TimeUnit.MILLISECONDS);
            }
        }

        private void refreshUpperCaches(K key) {
            int len;
            MultiLevelCache targetCache = (MultiLevelCache)RefreshCache.this.getTargetCache();
            Cache[] caches = targetCache.caches();
            CacheGetResult cacheGetResult = caches[(len = caches.length) - 1].GET(key);
            if (!cacheGetResult.isSuccess()) {
                return;
            }
            for (int i = 0; i < len - 1; ++i) {
                caches[i].PUT(key, cacheGetResult.getValue());
            }
        }

        @Override
        public void run() {
            try {
                if (RefreshCache.this.config.getRefreshPolicy() == null || this.loader == null && !RefreshCache.this.hasLoader()) {
                    this.cancel();
                    return;
                }
                long now = System.currentTimeMillis();
                long stopRefreshAfterLastAccessMillis = RefreshCache.this.config.getRefreshPolicy().getStopRefreshAfterLastAccessMillis();
                if (stopRefreshAfterLastAccessMillis > 0L && this.lastAccessTime + stopRefreshAfterLastAccessMillis < now) {
                    logger.debug("cancel refresh: {}", this.key);
                    this.cancel();
                    return;
                }
                logger.debug("refresh key: {}", this.key);
                Cache concreteCache = RefreshCache.this.concreteCache();
                if (concreteCache instanceof AbstractExternalCache) {
                    this.externalLoad(concreteCache, now);
                } else {
                    this.load();
                }
            }
            catch (Throwable e) {
                logger.error("refresh error: key=" + this.key, e);
            }
        }
    }
}

