/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl;

import com.alibaba.ttl.TransmittableThreadLocal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;

public final class TtlCallable<V>
implements Callable<V> {
    private final AtomicReference<Map<TransmittableThreadLocal<?>, Object>> copiedRef = new AtomicReference(TransmittableThreadLocal.copy());
    private final Callable<V> callable;
    private final boolean releaseTtlValueReferenceAfterCall;

    private TtlCallable(Callable<V> callable, boolean releaseTtlValueReferenceAfterCall) {
        this.callable = callable;
        this.releaseTtlValueReferenceAfterCall = releaseTtlValueReferenceAfterCall;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V call() throws Exception {
        Map<TransmittableThreadLocal<?>, Object> copied = this.copiedRef.get();
        if (copied == null || this.releaseTtlValueReferenceAfterCall && !this.copiedRef.compareAndSet(copied, null)) {
            throw new IllegalStateException("TTL value reference is released after call!");
        }
        Map<TransmittableThreadLocal<?>, Object> backup = TransmittableThreadLocal.backupAndSet(copied);
        try {
            V v = this.callable.call();
            return v;
        }
        finally {
            TransmittableThreadLocal.restore(backup);
        }
    }

    public Callable<V> getCallable() {
        return this.callable;
    }

    public static <T> TtlCallable<T> get(Callable<T> callable) {
        return TtlCallable.get(callable, false);
    }

    public static <T> TtlCallable<T> get(Callable<T> callable, boolean releaseTtlValueReferenceAfterCall) {
        return TtlCallable.get(callable, releaseTtlValueReferenceAfterCall, false);
    }

    public static <T> TtlCallable<T> get(Callable<T> callable, boolean releaseTtlValueReferenceAfterCall, boolean idempotent) {
        if (null == callable) {
            return null;
        }
        if (callable instanceof TtlCallable) {
            if (idempotent) {
                return (TtlCallable)callable;
            }
            throw new IllegalStateException("Already TtlCallable!");
        }
        return new TtlCallable<T>(callable, releaseTtlValueReferenceAfterCall);
    }

    public static <T> List<TtlCallable<T>> gets(Collection<? extends Callable<T>> tasks) {
        return TtlCallable.gets(tasks, false, false);
    }

    public static <T> List<TtlCallable<T>> gets(Collection<? extends Callable<T>> tasks, boolean releaseTtlValueReferenceAfterCall) {
        if (null == tasks) {
            return Collections.emptyList();
        }
        ArrayList<TtlCallable<T>> copy = new ArrayList<TtlCallable<T>>();
        for (Callable<T> task : tasks) {
            copy.add(TtlCallable.get(task, releaseTtlValueReferenceAfterCall, false));
        }
        return copy;
    }

    public static <T> List<TtlCallable<T>> gets(Collection<? extends Callable<T>> tasks, boolean releaseTtlValueReferenceAfterCall, boolean idempotent) {
        if (null == tasks) {
            return Collections.emptyList();
        }
        ArrayList<TtlCallable<T>> copy = new ArrayList<TtlCallable<T>>();
        for (Callable<T> task : tasks) {
            copy.add(TtlCallable.get(task, releaseTtlValueReferenceAfterCall, idempotent));
        }
        return copy;
    }
}

